/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.ImportMasterCardVo;
import jp.mosp.payroll.dao.MImportDao;
import jp.mosp.payroll.dao.MImportFieldDao;
import jp.mosp.payroll.dao.PmDetailPaDao;
import jp.mosp.payroll.dao.PmDetailPbDao;
import jp.mosp.payroll.dao.PmDetailPdDao;
import jp.mosp.payroll.dao.PmDetailPsDao;
import jp.mosp.payroll.dao.PmDetailPtDao;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailPaDto;
import jp.mosp.payroll.dto.DetailPbDto;
import jp.mosp.payroll.dto.DetailPdDto;
import jp.mosp.payroll.dto.DetailTimeDto;
import jp.mosp.payroll.dto.MImportDto;
import jp.mosp.payroll.dto.MImportFieldDto;

public class ImportMasterCardAction extends MosPAction {

	// R}h
	private static final String CMD_IMPORT_MASTER_CARD_SHOW	= "P9030";	// \(ǉ)
	private static final String CMD_IMPORT_MASTER_CARD_SELECT	= "P9031";	// \(I)
	private static final String CMD_IMPORT_MASTER_CARD_INSERT	= "P9032";	// o^
	private static final String CMD_IMPORT_MASTER_CARD_UPDATE	= "P9033";	// XV
	private static final String CMD_IMPORT_MASTER_CARD_DELETE	= "P9034";	// 폜

	public List<DetailPaDto>		detailPaDto_lst;
	public List<DetailPbDto>		detailPbDto_lst;
	public List<DetailPdDto>		detailPdDto_lst;
	public List<DetailMoneyDto>		detailPsDto_lst;
	public List<DetailTimeDto>		detailPtDto_lst;
	
	/**
	 * RXgN^
	 */
	public ImportMasterCardAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new ImportMasterCardVo();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO擾yѐݒ
		prepareVo();
		// R}h̏
		if (cmd.equals(CMD_IMPORT_MASTER_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_SELECT)) {
			select();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_INSERT)) {
			insert();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_UPDATE)) {
			update();
		} else if (cmd.equals(CMD_IMPORT_MASTER_CARD_DELETE)) {
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	private void show() throws SQLException, IllegalAccessException, NoSuchFieldException {
		setPulldown(key1);
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setAryHidIField(getImportFieldCodeArray	(key1));
		vo.setAryLblIField(getImportFieldNameArray	(key1));
		vo.setAryPltIOrder(getImportFieldOrderArray	(key1));
		vo.setTxtICode("");
		vo.setTxtIName("");
		vo.setHidITable(key1);
		vo.setLblITable(util.getCodeName(key1, vo.aryPltTable));
		vo.setMode(ImportMasterCardVo.MODE_INSERT);
	}

	private void select() throws Exception {
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		MImportFieldDao mImportFieldDao = new MImportFieldDao();
		mImportFieldDao.initDao(cfg, cmd, aspUser, user, conn);
		MImportDto dto = dao.findForKey(key1);
		chkExist(dto);
		setPulldown(dto.getITable());
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setAryHidIField(getImportFieldCodeArray	(dto.getITable()));
		vo.setAryLblIField(getImportFieldNameArray	(dto.getITable()));
		vo.setAryPltIOrder(getImportFieldOrderArray	(dto.getITable()));
		// VOɏZbg
		vo.setFields(dto);
		vo.setFields(mImportFieldDao.findForCondition(dto.getICode()));
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		//ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}

	private void insert() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setParams(request);
		// p[^[̑ÓmF
		vo.validate();
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtICode()), vo);
		// DTȌ
		MImportDto dto = new MImportDto();
		vo.setDtoFields(dto);
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getICode());
		chkInsert(dto);
		// C|[gtB[h̑}
		insertImportField();
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}

	private void update() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.setParams(request);
		//p[^[̑ÓmF
		vo.validate();
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MImportDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MImportDto ? (MImportDto)obj : null;
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtICode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MImportDto retDto = dao.findForKey(dto.getICode());
		chkUpdate(retDto);
		// C|[gtB[h̑}
		insertImportField();
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, retDto);
	}

	private void delete() throws Exception {
		// DAȌ
		MImportDao dao = new MImportDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̎擾
		MImportDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MImportDto ? (MImportDto)obj : null;
		// f[^̍XV
		dao.delete(dto);
		// C|[gtB[h̍폜
		deleteImportField(dto.getICode());
		// R~bg
		commit();
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		// [hݒ
		vo.setMode(ImportMasterCardVo.MODE_INSERT);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
		// ZbVDTOZbg
		session.setAttribute(MospConst.ATT_DTO, dto);
	}

	private void insertImportField() throws Exception {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		// 폜
		deleteImportField(vo.getTxtICode());
		// DAȌ
		MImportFieldDao dao = new MImportFieldDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		MImportFieldDto dto = new MImportFieldDto();
		String[] importFieldOrder = vo.getAryPltIOrder();
		for (int i = 0; i < importFieldOrder.length; i++) {
			if (!importFieldOrder[i].equals("")) {
				vo.setDtoFields(dto, i);
				// f[^̑}
				dao.insert(dto);
				// DTO̍Ď擾
				dto = dao.findForKey(dto.getICode(), dto.getIField());
				chkInsert(dto);
			}
		}
	}

	private void deleteImportField(String icode) throws Exception {
		// DAȌ
		MImportFieldDao dao = new MImportFieldDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̍XV
		dao.delete(icode, dao.findForCondition(icode).size());
	}

	private void setPulldown(String table) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// VO擾
		ImportMasterCardVo vo = (ImportMasterCardVo)getVo();
		vo.aryPltTable = getImportTableArray();
		vo.aryPltOrder = util.getCountArray(1, getImportFieldCodeArray(table).length, 1);
	}

	/**
	 * C|[gtB[hR[h擾
	 * @param table C|[ge[u
	 * @return C|[gtB[hR[hpz
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private String[] getImportFieldCodeArray(String table) throws SQLException, IllegalAccessException, NoSuchFieldException {
		String[] aryImportFieldCode = new String[0];
        int tmo_count = 0;
		ArrayList<String> add_list = new ArrayList<String>();
		if (table.equals(PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT)) {
			
			// DAȌ
			PmDetailPaDao pmDetailPaDao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
			PmDetailPbDao pmDetailPbDao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
			PmDetailPdDao pmDetailPdDao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
			PmDetailPsDao pmDetailPsDao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
			PmDetailPtDao pmDetailPtDao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
			detailPaDto_lst = pmDetailPaDao.findNotDelete();
			detailPbDto_lst = pmDetailPbDao.findNotDelete();
			detailPdDto_lst = pmDetailPdDao.findNotDelete();
			detailPsDto_lst = pmDetailPsDao.findNotDelete();
			detailPtDto_lst = pmDetailPtDao.findNotDelete();

			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.DTL_SNEN );
			add_list.add( PayrollConst.DTL_STUKI );
			add_list.add( PayrollConst.DTL_SHI );
			
			for (Iterator<DetailPaDto> it = detailPaDto_lst.iterator(); it.hasNext();) {
				DetailPaDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailCode());
				}
			}

			for (Iterator<DetailPbDto> it = detailPbDto_lst.iterator(); it.hasNext();) {
				DetailPbDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailCode());
				}
			}

			for (Iterator<DetailPdDto> it = detailPdDto_lst.iterator(); it.hasNext();) {
				DetailPdDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailCode());
				}
			}
			
			for (Iterator<DetailMoneyDto> it = detailPsDto_lst.iterator(); it.hasNext();) {
				DetailMoneyDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailCode());
				}
			}

			for (Iterator<DetailTimeDto> it = detailPtDto_lst.iterator(); it.hasNext();) {
				DetailTimeDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailCode());
					if(dto.getDetailCode().equals( PayrollConst.DTL_WARIMASI1 )){
						tmo_count = 1;
					}
				}
			}

			if(tmo_count == 0){
				add_list.add(PayrollConst.DTL_WARIMASI1);
			}
			aryImportFieldCode = paiLieToArrayList( add_list );
			
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO)) {
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HIZUKE );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KINMU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SHANKYUKB );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KYUSYUKB );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TIRIYUU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TICOMENT );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TISYOUMEI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TIJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KINMUJI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KYUKEIJI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_THANKYUKB );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SORIYUU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SOCOMENT );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SOSYOUMEI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SOJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_ZAJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KSJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SNJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SYOKJI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_CYOKU1 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_CYOKU2 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_CYOKU3 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HOKA1 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HOKA2 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HOKA3 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HOKA4 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HOKA5 );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KKRIYUU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_DAIKYUJYU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KKCOMENT );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KKSYOUMEI );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KKJIKAN );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NIJIKYU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NZAJIKAN );
			aryImportFieldCode = paiLieToArrayList( add_list );
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLCT_TIMECARD)) {
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_HIZUKE );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SYJIKOKU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_TAJIKOKU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KINMU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KKRIYUU );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_SHANKYUKB );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_THANKYUKB );
			add_list.add( PayrollConst.CODE_IMPORT_FIELD_KYUSYUKB );
//			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NIJIKYU );
//			add_list.add( PayrollConst.CODE_IMPORT_FIELD_NZAJIKAN );
			aryImportFieldCode = paiLieToArrayList( add_list );
		}
		return aryImportFieldCode;
	}

	/**
	 * C|[gtB[h̎擾
	 * @param table C|[ge[u
	 * @return C|[gtB[h̗pz
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private String[] getImportFieldNameArray(String table) throws SQLException, IllegalAccessException, NoSuchFieldException {
		String[] aryImportFieldName	= new String[0];
		ArrayList<String> add_list = new ArrayList<String>();

		if (table.equals(PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT)) {
			// DAȌ
			PmDetailPaDao pmDetailPaDao = new PmDetailPaDao(cfg, cmd, aspUser, user, conn);
			PmDetailPbDao pmDetailPbDao = new PmDetailPbDao(cfg, cmd, aspUser, user, conn);
			PmDetailPdDao pmDetailPdDao = new PmDetailPdDao(cfg, cmd, aspUser, user, conn);
			PmDetailPsDao pmDetailPsDao = new PmDetailPsDao(cfg, cmd, aspUser, user, conn);
			PmDetailPtDao pmDetailPtDao = new PmDetailPtDao(cfg, cmd, aspUser, user, conn);
			
			detailPaDto_lst = pmDetailPaDao.findNotDelete();
			detailPbDto_lst = pmDetailPbDao.findNotDelete();
			detailPdDto_lst = pmDetailPdDao.findNotDelete();
			detailPsDto_lst = pmDetailPsDao.findNotDelete();
			detailPtDto_lst = pmDetailPtDao.findNotDelete();

			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_DTL_SNEN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_DTL_STUKI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_DTL_DTL_SHI );
			
			for (Iterator<DetailPaDto> it = detailPaDto_lst.iterator(); it.hasNext();) {
				DetailPaDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailName());
				}
			}

			for (Iterator<DetailPbDto> it = detailPbDto_lst.iterator(); it.hasNext();) {
				DetailPbDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailName());
				}
			}

			for (Iterator<DetailPdDto> it = detailPdDto_lst.iterator(); it.hasNext();) {
				DetailPdDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailName());
				}
			}
			
			for (Iterator<DetailMoneyDto> it = detailPsDto_lst.iterator(); it.hasNext();) {
				DetailMoneyDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailName());
				}
			}

			for (Iterator<DetailTimeDto> it = detailPtDto_lst.iterator(); it.hasNext();) {
				DetailTimeDto dto = it.next();
				if( dto.getInputType() == PayrollConst.DETAIL_IN_UPLOAD ){
					add_list.add(dto.getDetailName());
				}
			}
			add_list.add(PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN);
			aryImportFieldName = paiLieToArrayList( add_list );
		    
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO)) {
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HIZUKE );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KINMU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TIRIYUU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TICOMENT );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TISYOUMEI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TIJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KINMUJI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KYUKEIJI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_THANKYUKB );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SORIYUU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SOCOMENT );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SOSYOUMEI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SOJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_ZAJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KSJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SNJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SYOKJI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_CYOKU1 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_CYOKU2 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_CYOKU3 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HOKA1 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HOKA2 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HOKA3 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HOKA4 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HOKA5 );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KKRIYUU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_DAIKYUJYU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KKCOMENT );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KKSYOUMEI );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KKJIKAN );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NIJIKYU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN );

			aryImportFieldName = paiLieToArrayList( add_list );
		} else if (table.equals(PayrollConst.CODE_IMPORT_TABLCT_TIMECARD)) {
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KCODE );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_HIZUKE );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SYJIKOKU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_TAJIKOKU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KINMU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KKRIYUU );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_SHANKYUKB );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_THANKYUKB );
			add_list.add( PayrollConst.NAM_IMPORT_FIELD_KYUSYUKB );
//			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NIJIKYU );
//			add_list.add( PayrollConst.NAM_IMPORT_FIELD_NZAJIKAN );
			aryImportFieldName = paiLieToArrayList( add_list );
		}
		return aryImportFieldName;
	}

	private String[] getImportFieldOrderArray(String table) throws SQLException, IllegalAccessException, NoSuchFieldException {
		return new String[getImportFieldCodeArray(table).length];
	}

	/**
	 * C|[ge[uv_E擾
	 * @return C|[ge[uv_Epz
	 */
	protected String[][] getImportTableArray() {
		String[][] aryImportTable = new String[3][2];
		aryImportTable[0][0] = PayrollConst.CODE_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[0][1] = PayrollConst.NAM_IMPORT_TABLE_PI_PAYMENT;
		aryImportTable[1][0] = PayrollConst.CODE_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[1][1] = PayrollConst.NAM_IMPORT_TABLE_M_SYUKKINBO;
		aryImportTable[2][0] = PayrollConst.CODE_IMPORT_TABLCT_TIMECARD;
		aryImportTable[2][1] = PayrollConst.NAM_IMPORT_TABLCT_TIMECARD;
		return aryImportTable;
	}
	
	  /**
	  * StringListStringzɕϊ
	  * @param List Xg
	  * @return String̔z
	  */
	  public static String[] paiLieToArrayList(List<String> list){
	    String[] strs = (String[])list.toArray(new String[]{});
	    return strs;
	  }


}
