/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.KintaiCompileAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartManager;

import jp.mosp.payroll.dto.MKintaiDto;
import jp.mosp.payroll.vo.CompileAmendmentCardVo;

public class CompileAmendmentCardAction extends KintaiCompileAction {

	// R}h
	private static final String CMD_AMENDMENT_CARD_SELECT 	= "P1046";	// \(I)
	private static final String CMD_AMENDMENT_CARD_REGIST 	= "P1047";	// o^

	/**
	 * RXgN^
	 */
	public CompileAmendmentCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾yѐݒ
		CompileAmendmentCardVo vo = new CompileAmendmentCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		MKintaiDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MKintaiDto ? (MKintaiDto)obj : null;
		// v_EXg̐ݒ
		setPullDownList(vo);
		// R}h̏
		if (cmd.equals(CMD_AMENDMENT_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = select(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_AMENDMENT_CARD_REGIST)) {
			// o^
			dto = regist(vo, dto);
			// R~bg
			commit();
			// [hݒ
			vo.setMode(CompileAmendmentCardVo.MODE_EDIT);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * I
	 * @param vo
	 * @throws Exception
	 */
	private MKintaiDto select(CompileAmendmentCardVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// ЈR[h擾
		String kcode = getBasisInfo(key1).getKCode();
		// DTÕZbg
		MKintaiDto dto;
		// ΑӏWv
		MKintaiDto currentDto = kintaiDao().findForKey(kcode, key2);
		// IN
		String[] target = util.divideByHyphen(key2, 1);
		Date targetMonth = util.getFirstDateOfMonth(target[0], target[1]);
		if (chkExistDto(currentDto)) {
			// DTOɌ݂̒lZbg
			dto = currentDto;
		} else {
			// ΑӃf[^擾			
			getAttendanceList(kcode, targetMonth);
			// ΑӌWv
			dto = getCompiledInfo(kcode, targetMonth, attendanceList);
		}
		// VOɏZbg
		vo.setFields(dto);
		// ΑӏWvݒ
		setAmendmentInfo(vo, kcode, targetMonth);
		// [h̐ݒ
		if (!chkExistDto(PartManager.calculate(partInfo()).findForCalc())) {
			vo.setMode(CompileAmendmentCardVo.MODE_IMPOSSIBLE);
		} else if (targetMonth.compareTo(getCalcMonth()) < 0) {
			vo.setMode(CompileAmendmentCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(CompileAmendmentCardVo.MODE_EDIT);
		}
		return dto;
	}

	/**
	 * o^
	 * @param vo
	 * @param dto
	 * @throws Exception
	 */
	private MKintaiDto regist(CompileAmendmentCardVo vo, MKintaiDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		Date targetMonth = util.getFirstDateOfMonth(vo.getHidYear(), vo.getHidMonth());
		if (dto == null) {
			dto = new MKintaiDto();
		}
		// DTȌ
		vo.setDtoFields(dto);
		dto.setSikyuYM(util.convDateToStringYearMonthShort(targetMonth));
		// ݃`FbN
		MKintaiDto currentDto = kintaiDao().findForKey(vo.getHidKCode(), util.convDateToStringYearMonthShort(targetMonth));
		if (chkExistDto(currentDto)) {
			// rmF
			chkExclusive(currentDto, kintaiDao().findForUpdate(vo.getHidKCode(), util.convDateToStringYearMonthShort(targetMonth)), vo);
			// f[^̍XV
			kintaiDao().update(dto);
		} else {
			// ݃`FbN
			chkDuplicate(kintaiDao().findForKey(vo.getHidKCode(), util.convDateToStringYearMonthShort(targetMonth)), vo);
			// f[^̑}
			kintaiDao().insert(dto);
		}
		// DTO̍Ď擾
		MKintaiDto retDto = kintaiDao().findForKey(dto.getKCode(), dto.getSikyuYM());
		chkUpdate(retDto);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// ΑӏWvݒ
		setAmendmentInfo(vo, retDto.getKCode(), targetMonth);	
		return retDto;
	}

	/**
	 * v_EXgݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPullDownList(CompileAmendmentCardVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// 蓖
		vo.aryAllowance = getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME);
		// xɗR
		vo.aryHolidayReason = getMosPCodeArray(CommonConst.TID_LEAVE_REASON);
		// FΎ蓖L
		vo.aryPerfectAttendanceFlag = util.getExistenceArray();
	}

	/**
	 * ΑӏWvݒ
	 * @param vo ΏVO
	 * @param kcode IЈR[h
	 * @param targetMonth Ώ۔N
	 * @throws Exception
	 */
	private void setAmendmentInfo(CompileAmendmentCardVo vo, String kcode, Date targetMonth) throws Exception {
		// lݒ
		vo.setHidKCode(kcode);
		vo.setLblKCode(kcode);
		vo.setLblKName(getKName(kcode));
		vo.setLblSection(getSectionName(getBasisInfo(kcode).getSCode()));
		// ΑӏWvݒ
		vo.setHidYear(String.valueOf(MospUtility.getYear(targetMonth)));
		vo.setHidMonth(String.valueOf(MospUtility.getMonth(targetMonth)));
		vo.setLblSelectDate(MospUtility.getDateString(
				targetMonth,
				CommonConst.FORMAT_YEAR_MONTH_JP)
		);
	}

}
