/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.human.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPHumanAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.vo.HumanListVo;

public class HumanListAction extends MosPHumanAction {

	// R}h
	private static final String CMD_HUMAN_LIST_SHOW		= "H1010";
	private static final String CMD_HUMAN_LIST_SEARCH		= "H1011";
	private static final String CMD_HUMAN_LIST_RE_SEARCH	= "H1012";
	private static final String CMD_HUMAN_LIST_SORT		= "H1013";

	/**
	 * RXgN^
	 */
	public HumanListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// HUMANmF
		confirmHumanAuth();
		// VO̎擾
		boolean hasVoExisted = true;
		HumanListVo vo = (HumanListVo)getStoredVo(CommonConst.VO_HUMAN_LIST);
		if (vo == null) {
			vo = new HumanListVo();
			hasVoExisted = false;
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_HUMAN_LIST, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		if (mKihon == null) {
			// [U[擾
			getInfo(user.getUserId());
		}
		// v_E擾
		if (vo.aryPltPositionAll == null) {
			vo.aryPltOfficeAll		= getOfficeArrayAll();
			vo.aryPltOffice 		= getOfficeArray();
			vo.aryPltSectionAll		= getSectionArrayAll();
			vo.aryPltSection		= getSectionArrayForHuman();
			vo.aryPltPositionAll	= getPositionArrayAll();
			vo.aryPltPosition		= getPositionTitleArray();
			vo.aryPltRetirement		= util.getRetirementFlagArrayAll();
		}
		// R}h̏
		if (cmd.equals(CMD_HUMAN_LIST_SHOW)) {
			// \
			vo.setPltRetirement(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF));
		} else if (cmd.equals(CMD_HUMAN_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			serachEmployeeList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_HUMAN_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			if (hasVoExisted) {
				serachEmployeeList(vo);
				vo.setPageButton();
				sortList(vo);
			} else {
				vo.setPltRetirement(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF));
			}
		} else if (cmd.equals(CMD_HUMAN_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ЈXg
	 * @param vo HumanListVoCX^X
	 * @throws Exception
	 */
	private void serachEmployeeList(HumanListVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// 
		MKihonDao dao = new MKihonDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MKihonDto> list = dao.findForHumanList(
				vo.getTxtKCode(),
				vo.getTxtKName(),
				vo.getPltOfiice(),
				vo.getPltSection(),
				vo.getPltPosition(),
				vo.getPltRetirement()
		);
		// VOɐݒ
		vo.setFields(list);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryKCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, HumanListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(HumanListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, HumanListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_OFFICE)) {
			comp = new CompOffice();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else if (key.equals(vo.KEY_RETIREMENT)) {
			comp = new CompRetirement();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5119036808145029871L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 193124556803850458L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}

	/**
	 * ƏR[hɂrNX
	 */
	protected static class CompOffice implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 4714384681014176376L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getJCode().compareTo(dto2.getJCode());
		}
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -541480811429249595L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

	/**
	 * EijɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -6565419791696911049L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}

	/**
	 * ގГɂrNX
	 */
	protected static class CompRetirement implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5285750385665762813L;
		public int compare(Object obj1, Object obj2) {
			MKihonDto dto1 = (MKihonDto)obj1;
			MKihonDto dto2 = (MKihonDto)obj2;
			return dto1.getKnKubun().compareTo(dto2.getKnKubun());
		}
	}

}
