/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dao.CtWorkflowCommentDao;
import jp.mosp.common.dao.CtWorkflowDao;
import jp.mosp.common.dto.CtWorkflowCommentDto;
import jp.mosp.common.dto.CtWorkflowDto;

/**
 * [Nt[ɊւPartNX
 * @author yoshida
 *	@version	0.0.4
 */
public class WorkflowPart extends BasePart {

	/**
	 * RXgN^
	 */
	public WorkflowPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public WorkflowPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * [Nt[e[uDAO̎擾
	 * @return	ςCtWorkflowDaoCX^X
	 * @throws Exception
	 */
	public CtWorkflowDao getCtWorkflowDao() throws Exception {
		return (CtWorkflowDao) getPreparedDao(CtWorkflowDao.class.getCanonicalName());
	}

	/**
	 * [Nt[Rge[upDAO̎擾
	 * @since	0.0.2
	 * @return	ςCtWorkflowCommentDaoCX^X
	 * @throws Exception
	 */
	public CtWorkflowCommentDao getCtWorkflowCommentDao() throws Exception {
		return (CtWorkflowCommentDao) getPreparedDao(CtWorkflowCommentDao.class.getCanonicalName());
	}

	/**
	 * Xe[^XR[hXg擾
	 * @return Xe[^XR[hXgz
	 * <p>
	 * [0]cFi\j
	 * [1]cF
	 * [2]cߒ
	 * [3]cF
	 * [4]c
	 * </p>
	 */
	public static String[] getStatusCodeArray() {
		// z̍쐬
		String[] aryStatus = new String[5];
		aryStatus[0] = CommonConst.CODE_REQUEST;
		aryStatus[1] = CommonConst.CODE_APPROVED;
		aryStatus[2] = CommonConst.CODE_RETURNED;
		aryStatus[3] = CommonConst.CODE_UNLOCK;
		aryStatus[4] = CommonConst.CODE_DRAFT;
		return aryStatus;
	}

	/**
	 * Xe[^XXg擾
	 * @return Xe[^XXgz
	 * <p>
	 * [0]cFi\j
	 * [1]cF
	 * [2]cߒ
	 * [3]cF
	 * [4]c
	 * </p>
	 */
	public static String[][] getStatusArray() {
		// z̍쐬
		String[][] aryStatus = new String[5][2];
		aryStatus[0][0] = getStatusCodeArray()[0];
		aryStatus[0][1] = CommonConst.NAM_REMAIN_APPROVED;
		aryStatus[1][0] = getStatusCodeArray()[1];
		aryStatus[1][1] = CommonConst.NAME_APPROVED;
		aryStatus[2][0] = getStatusCodeArray()[2];
		aryStatus[2][1] = CommonConst.NAME_RETURNED;
		aryStatus[3][0] = getStatusCodeArray()[3];
		aryStatus[3][1] = CommonConst.NAME_UNLOCK;
		aryStatus[4][0] = getStatusCodeArray()[4];
		aryStatus[4][1] = CommonConst.NAME_DRAFT;
		return aryStatus;
	}

	/**
	 * [Nt[擾
	 * @param workflow		[Nt[ԍ
	 * @return	(DTO)
	 * @throws Exception
	 */
	public CtWorkflowDto getWorkflowDto(long workflow) throws Exception {
		return getCtWorkflowDao().findForKey(workflow);
	}

	/**
	 * F󋵃R[h擾
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵃R[h
	 * @throws Exception 
	 */
	public String getStatusCode(long workflow) throws Exception {
		CtWorkflowDto dto = getWorkflowDto(workflow);
		if (VariousPart.chkExistDto(dto)) {
			return dto.getCurrentStatus();
		}
		return "";
	}

	/**
	 * F󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	F󋵂̐
	 * @throws Exception 
	 */
	public static boolean isRequest(String code) throws Exception {
		return getStatusCodeArray()[0].equals(code);
	}

	/**
	 * F󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	F󋵂̐
	 * @throws Exception 
	 */
	public boolean isStatusRequest(long workflow) throws Exception {
		return isRequest(getStatusCode(workflow));
	}

	/**
	 * Fςݏ󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	Fςݏ󋵂̐
	 * @throws Exception 
	 */
	public static boolean isApproved(String code) throws Exception {
		return getStatusCodeArray()[1].equals(code);
	}

	/**
	 * Fςݏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Fςݏ󋵂̐
	 * @throws Exception 
	 */
	public boolean isStatusApproved(long workflow) throws Exception {
		return isApproved(getStatusCode(workflow));
	}

	/**
	 * ߏ󋵂̊mF
	 * @since	0.0.4
	 * @param code		ΏۃR[h
	 * @return	ߏ󋵂̐
	 * @throws Exception 
	 */
	public static boolean isReturned(String code) throws Exception {
		return getStatusCodeArray()[2].equals(code);
	}

	/**
	 * ߏ󋵂̊mF
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	ߏ󋵂̐
	 * @throws Exception 
	 */
	public boolean isStatusReturned(long workflow) throws Exception {
		return isReturned(getStatusCode(workflow));
	}

	/**
	 * f
	 * @since	0.0.3
	 * @param code		ΏۃR[h
	 * @return
	 */
	public static boolean isDraft(String code) {
		return getStatusCodeArray()[4].equals(code);
	}

	/**
	 * 󋵂̊mF
	 * @since	0.0.3
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	󋵂̐
	 * @throws Exception 
	 */
	public boolean isStatusDraft(long workflow) throws Exception {
		return isDraft(getStatusCode(workflow));
	}

	/**
	 * FҌRg擾
	 * @since	0.0.2
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				ŐṼRg
	 * @throws Exception
	 */
	public CtWorkflowCommentDto getWorkflowCommentForApprover(long workflow) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		CtWorkflowDto workflowDto = getWorkflowDto(workflow);
		if (VariousPart.chkExistDto(workflowDto)) {
			dto = getCtWorkflowCommentDao().findForMaxApprover(workflowDto.getRtCode(), workflow);
		}
		return dto;
	}

	/**
	 * ΏێҌRg擾
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				ŐṼRg
	 * @throws Exception
	 */
	public CtWorkflowCommentDto getWorkflowCommentForTarget(
			String target,
			long workflow
	) throws Exception {
		CtWorkflowCommentDto dto = new CtWorkflowCommentDto();
		if (VariousPart.chkExistDto(getWorkflowDto(workflow))) {
			dto = getCtWorkflowCommentDao().findForMaxTarget(target, workflow);
		}
		return dto;
	}

	/**
	 * ΏێҌRgꗗ
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return	Rgꗗ	ŐṼRg珇ɐ
	 * @throws Exception
	 */
	public List<CtWorkflowCommentDto> getWorkflowCommentListForTarget(
			String target,
			long workflow
	) throws Exception {
		List<CtWorkflowCommentDto> listComment = new ArrayList<CtWorkflowCommentDto>();
		if (VariousPart.chkExistDto(getWorkflowDto(workflow))) {
			listComment = getCtWorkflowCommentDao().findForTarget(target, workflow);
		}
		return listComment;
	}

	/**
	 * Rgꗗz
	 * @since	0.0.2
	 * @param target		RgΏێЈR[h	
	 * @param workflow		Ώۃ[Nt[ԍ
	 * @return				Rgꗗz
	 * @throws Exception
	 */
	public String[][] getWorkflowCommentArray(
			String target,
			long workflow
	) throws Exception {
		List<CtWorkflowCommentDto> list = getWorkflowCommentListForTarget(target, workflow);
		String[][] aryComments = new String[list.size()][2];
		for (int i = 0; i < aryComments.length; i++) {
			CtWorkflowCommentDto dto = (CtWorkflowCommentDto)list.get(i);
			aryComments[i][0] = human().getKName(dto.getKCode());
			aryComments[i][1] = dto.getAuthorComment();
		}
		return aryComments;
	}

	/**
	 * ΑӏFXe[^XR[h擾
	 * @since	0.0.3
	 * @param workflow			Ώۃ[Nt[ԍ
	 * @return	ΑӏFXe[^XR[h
	 * @throws Exception
	 */
	public String toKintaiApprovalStatus(long workflow) throws Exception {
		String status = "";
		CtWorkflowDto dto = getWorkflowDto(workflow);
		if (VariousPart.chkExistDto(dto)) {
			int number = dto.getLayerNumber();
			String current = dto.getCurrentStatus();
			// 
			if (isDraft(current)) {
				status = getStatusArray()[4][1];
			}
			// Fi\j
			if (isRequest(current)) {
				status = VariousPart.getApprovalStatusCodeArray()[0];
			}
			// ꎟ
			else if (CommonConst.NUM_LAYER1 == number) {
				if (isApproved(current)) {
					status = VariousPart.getApprovalStatusCodeArray()[1];
				} else if (isReturned(current)) {
					status = VariousPart.getApprovalStatusCodeArray()[2];
				}
			}
			// 
			else if (CommonConst.NUM_LAST_LAYER == number) {
				if (isApproved(current)) {
					status = VariousPart.getApprovalStatusCodeArray()[3];
				} else if (isReturned(current)) {
					status = VariousPart.getApprovalStatusCodeArray()[4];
				}
			}
		}
		return status;
	}

}
