/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.HumanBasisDtoInterface;

import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MYakusyokuDto;

/**
 * EɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class PositionPart extends BasePart {

	/**
	 * RXgN^
	 */
	public PositionPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public PositionPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * M_YAKUSYOKUe[upDAO擾
	 * @return	ςMYakusyokuDaoCX^X
	 * @throws Exception
	 */
	public MYakusyokuDao getMYakusyokuDao() throws Exception {
		return (MYakusyokuDao)getPreparedDao(MYakusyokuDao.class.getCanonicalName());
	}

	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	public String[][] getPositionArrayAll() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAll();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(L̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	public String[][] getPositionArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	public String[][] getPositionTitleArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findForTitle();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode();
			aryPosition[i][1] = listPosition.get(i).getYName();
		}
		return aryPosition;
	}

	/**
	 * ER[h擾(v_Ep)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception 
	 */
	public String[][] getPositionPltArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][2];
		for (int i = 0; i < listPosition.size(); i++) {
			aryPosition[i][0] = listPosition.get(i).getYCode() + CommonConst.STR_TIME_SEPARATOR + listPosition.get(i).getTokyu();
			aryPosition[i][1] = listPosition.get(i).getYName();
		}
		return aryPosition;
	}

	/**
	 * EXg擾(M_YAKUSYOKU)
	 * @return EXg
	 * @throws Exception 
	 */
	public Map<String, MYakusyokuDto> getPositionMap() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAll();
		// Map̍쐬
		HashMap<String, MYakusyokuDto> map = new HashMap<String, MYakusyokuDto>();
		for (int i = 0; i < listPosition.size(); i++) {
			map.put(listPosition.get(i).getYCode(), listPosition.get(i));
		}
		return map;
	}

	/**
	 * E擾(M_YAKUSYOKU)
	 * @param kCode		ΏێЈR[h
	 * @return 			ΏێЈE
	 * @throws Exception 
	 */
	public MYakusyokuDto getHoldingPositionInfo(
			String kCode
	) throws Exception {
		String positionCode = "";
		String grade = "0";
		// l{擾
		HumanBasisDtoInterface dto = human().getBasisInfo(kCode);
		if (VariousPart.chkExistObject(dto)) {
			// E擾
			positionCode = dto.getYCode();
			grade = dto.getTokyu();
		}
		return getMYakusyokuDao().findForKey(positionCode, grade);
	}


	/**
	 * E̎擾(t)
	 * @param kCode		ΏێЈR[h
	 * @return	ΏێЈE
	 * @throws Exception 
	 */
	public String getPositionName(
			String kCode
	) throws Exception {
		String name = "";
		HumanBasisDtoInterface dto = human().getBasisInfo(kCode);
		if (dto != null) {
			StringBuffer position = new StringBuffer();
			position.append(dto.getYCode());
			position.append(CommonConst.STR_TIME_SEPARATOR);
			position.append(dto.getTokyu());
			name = StringPart.getCodeName(position.toString(), getPositionPltArray());
			if (name.equals(CommonConst.STR_TIME_SEPARATOR)) {
				name = "";
			}
		}
		return name;
	}

	/**
	 * FΎ蓖p
	 * @since	0.0.2
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * FΎ蓖L̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public boolean isApplyAttendanceAllowance(String kCode) throws Exception {
		MYakusyokuDto dto = getHoldingPositionInfo(kCode);
		// FΎ蓖
		if (VariousPart.chkExistDto(dto) && CommonConst.NAM_COMMON_FLAG_ON.equals(dto.getKaikin())) {
			return true;
		}
		return false;
	}

}
