/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

/**
 * p[g̈ꗗ
 * @author yoshida
 *	@version	0.0.2
 */
public enum PartType {

	/**
	 * CM_CODEp[g
	 */
	cmcode(CmCodePart.class.getCanonicalName()),

	/**
	 * CM_CONFp[g
	 */
	mospconf(MosPConfPart.class.getCanonicalName()),

	/**
	 * M_CODEp[g
	 */
	mospcode(MosPCodePart.class.getCanonicalName()),

	/**
	 * M_KINTAIKEISANp[g
	 */
	calculate(CalculatePart.class.getCanonicalName()),

	/**
	 * CM_USERp[g
	 */
	mospuser(MosPUserPart.class.getCanonicalName()),

	/**
	 * M_KIHONp[g
	 */
	human(HumanPart.class.getCanonicalName()),

	/**
	 * CM_AUTHORITYp[g
	 */
	authority(AuthorityPart.class.getCanonicalName()),

	/**
	 * CM_COMPONENTp[g
	 */
	component(ComponentPart.class.getCanonicalName()),

	/**
	 * M_SYOZOKUp[g
	 */
	section(SectionPart.class.getCanonicalName()),

	/**
	 * M_KAISYAp[g
	 */
	office(OfficePart.class.getCanonicalName()),

	/**
	 * CM_WORKTYPEp[g
	 */
	worktype(WorkTypePart.class.getCanonicalName()),

	/**
	 * M_YAKUSYOKUp[g
	 */
	position(PositionPart.class.getCanonicalName()),

	/**
	 * ap[g
	 */
	jpdate(JPDatePart.class.getCanonicalName()),

	/**
	 * ֔ԃp[g
	 */
	rotation(RotationPart.class.getCanonicalName()),

	/**
	 * Fp[g
	 */
	approval(ApprovalPart.class.getCanonicalName()),

	/**
	 * ΑӏFp[g
	 */
	kintaiapproval(KintaiApprovalPart.class.getCanonicalName()),

	/**
	 * ΑӏWvp[g
	 */
	kintaicompile(KintaiCompilePart.class.getCanonicalName()),

	/**
	 * ΑӋʃp[g
	 */
	kintai(KintaiCommonPart.class.getCanonicalName()),

	/**
	 * jՓp[g
	 */
	holiday(HolidayPart.class.getCanonicalName()),

	/**
	 * cƐ\p[g
	 * @since	0.0.2
	 */
	overtime(OverTimePart.class.getCanonicalName()),

	/**
	 * [Nt[p[g
	 * @since	0.0.2
	 */
	workflow(WorkflowPart.class.getCanonicalName()),
	;

	private String name;

	private PartType (String name) {
		this.name = name;
	}

	public String toString() {
		return name;
	}

}
