/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Part}l[W[
 * @author yoshida
 *	@version	0.0.2
 */
public class PartManager {

	/**
	 * PartInfo
	 * @param cfg
	 * @param cmd
	 * @param aspUser
	 * @param user
	 * @param conn
	 * @return
	 */
	public static PartInfo createPartInfo(
			Properties cfg,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user,		
			Connection conn
	) {
		return new PartInfo(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * PartNXCX^X
	 * @param partClassName		ΏPartNX
	 * @param partInfo			
	 * @return					PartNXCX^X
	 * @throws MospException
	 */
	public static BasePart getPreparedPart(String partClassName, PartInfo partInfo) throws MospException {
		return PartFactory.create(partClassName, partInfo);
	}

	/**
	 * PartNXCX^X
	 * @param partType			ΏPartNX^Cv
	 * @param partInfo			
	 * @return					PartNXCX^X
	 * @throws MospException
	 */
	public static BasePart getPreparedPart(PartType partType, PartInfo partInfo) throws MospException {
		return getPreparedPart(partType.toString(), partInfo);
	}

	/**
	 * CmCodePartCX^X擾
	 * @param partInfo
	 * @return	CmCodePartCX^X
	 * @throws MospException
	 */
	public static CmCodePart cmcode(PartInfo partInfo) throws MospException {
		return (CmCodePart)getPreparedPart(PartType.cmcode, partInfo);
	}

	/**
	 * MosPConfPartCX^X擾
	 * @param partInfo
	 * @return	MosPConfPartCX^X
	 * @throws MospException
	 */
	public static MosPConfPart mospconf(PartInfo partInfo) throws MospException {
		return (MosPConfPart)getPreparedPart(PartType.mospconf, partInfo);
	}

	/**
	 * MosPCodePartCX^X擾
	 * @param partInfo
	 * @return	MosPCodePartCX^X
	 * @throws MospException
	 */
	public static MosPCodePart mospcode(PartInfo partInfo) throws MospException {
		return (MosPCodePart)getPreparedPart(PartType.mospcode, partInfo);
	}

	/**
	 * CalculatePartCX^X擾
	 * @param partInfo
	 * @return	CalculatePartCX^X
	 * @throws MospException
	 */
	public static CalculatePart calculate(PartInfo partInfo) throws MospException {
		return (CalculatePart)getPreparedPart(PartType.calculate, partInfo);
	}

	/**
	 * MosPUserPartCX^X擾
	 * @param partInfo
	 * @return	MosPUserPartCX^X
	 * @throws MospException
	 */
	public static MosPUserPart mospuser(PartInfo partInfo) throws MospException {
		return (MosPUserPart)getPreparedPart(PartType.mospuser, partInfo);
	}

	/**
	 * HumanPartCX^X擾
	 * @param partInfo
	 * @return	HumanPartCX^X
	 * @throws MospException
	 */
	public static HumanPart human(PartInfo partInfo) throws MospException {
		return (HumanPart)getPreparedPart(PartType.human, partInfo);
	}

	/**
	 * AuthorityPartCX^X擾
	 * @param partInfo
	 * @return	AuthorityPartCX^X
	 * @throws MospException
	 */
	public static AuthorityPart authority(PartInfo partInfo) throws MospException {
		return (AuthorityPart)getPreparedPart(PartType.authority, partInfo);
	}

	/**
	 * ComponentPartCX^X擾
	 * @param partInfo
	 * @return	ComponentPartCX^X
	 * @throws MospException
	 */
	public static ComponentPart component(PartInfo partInfo) throws MospException {
		return (ComponentPart)getPreparedPart(PartType.component, partInfo);
	}

	/**
	 * SectionPartCX^X擾
	 * @param partInfo
	 * @return	SectionPartCX^X
	 * @throws MospException
	 */
	public static SectionPart section(PartInfo partInfo) throws MospException {
		return (SectionPart)getPreparedPart(PartType.section, partInfo);
	}

	/**
	 * OfficePartCX^X擾
	 * @param partInfo
	 * @return	OfficePartCX^X
	 * @throws MospException
	 */
	public static OfficePart office(PartInfo partInfo) throws MospException {
		return (OfficePart)getPreparedPart(PartType.office, partInfo);
	}

	/**
	 * WorkTypePartCX^X擾
	 * @param partInfo
	 * @return	WorkTypePartCX^X
	 * @throws MospException
	 */
	public static WorkTypePart worktype(PartInfo partInfo) throws MospException {
		return (WorkTypePart)getPreparedPart(PartType.worktype, partInfo);
	}

	/**
	 * PositionPartCX^X擾
	 * @param partInfo
	 * @return	PositionPartCX^X
	 * @throws MospException
	 */
	public static PositionPart position(PartInfo partInfo) throws MospException {
		return (PositionPart)getPreparedPart(PartType.position, partInfo);
	}

	/**
	 * JPDatePartCX^X擾
	 * @param partInfo
	 * @return	JPDatePartCX^X
	 * @throws MospException
	 */
	public static JPDatePart jpdate(PartInfo partInfo) throws MospException {
		return (JPDatePart)getPreparedPart(PartType.jpdate, partInfo);
	}

	/**
	 * RotationPartCX^X擾
	 * @param partInfo
	 * @return	RotationPartCX^X
	 * @throws MospException
	 */
	public static RotationPart rotation(PartInfo partInfo) throws MospException {
		return (RotationPart) getPreparedPart(PartType.rotation, partInfo);
	}

	/**
	 * KintaiApprovalPartCX^X擾
	 * @param partInfo
	 * @return	KintaiApprovalPartCX^X
	 * @throws MospException
	 */
	public static KintaiApprovalPart kintaiapproval(PartInfo partInfo) throws MospException {
		return (KintaiApprovalPart) getPreparedPart(PartType.kintaiapproval, partInfo);
	}

	/**
	 * ApprovalPartCX^X擾
	 * @param partInfo
	 * @return	ApprovalPartCX^X
	 * @throws MospException
	 */
	public static ApprovalPart approval(PartInfo partInfo) throws MospException {
		return (ApprovalPart) getPreparedPart(PartType.approval, partInfo);
	}

	/**
	 * KintaiCommonPartCX^X擾
	 * @param partInfo
	 * @return	KintaiCommonPartCX^X
	 * @throws MospException
	 */
	public static KintaiCommonPart kintai(PartInfo partInfo) throws MospException {
		return (KintaiCommonPart) getPreparedPart(PartType.kintai, partInfo);
	}

	/**
	 * KintaiCompilePartCX^X擾
	 * @param partInfo
	 * @return	KintaiCompilePartCX^X
	 * @throws MospException
	 */
	public static KintaiCompilePart kintaicompile(PartInfo partInfo) throws MospException {
		return (KintaiCompilePart) getPreparedPart(PartType.kintaicompile, partInfo);
	}

	/**
	 * HolidayPartCX^X擾
	 * @param partInfo
	 * @return	HolidayPartCX^X
	 * @throws MospException
	 */
	public static HolidayPart holiday(PartInfo partInfo) throws MospException {
		return (HolidayPart) getPreparedPart(PartType.holiday, partInfo);
	}

	/**
	 * OverTimePartCX^X擾
	 * @since	0.0.2
	 * @param partInfo
	 * @return	OverTimePartCX^X
	 * @throws MospException
	 */
	public static OverTimePart overtime(PartInfo partInfo) throws MospException {
		return (OverTimePart) getPreparedPart(PartType.overtime, partInfo);
	}

	/**
	 * WorkflowPartCX^X擾
	 * @since	0.0.2
	 * @param partInfo
	 * @return	OverTimePartCX^X
	 * @throws MospException
	 */
	public static WorkflowPart workflow(PartInfo partInfo) throws MospException {
		return (WorkflowPart) getPreparedPart(PartType.workflow, partInfo);
	}

}
