/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

public class ExportInfoUtility {

	/**
	 * l擾pz
	 */
	protected String[] aryKihonItem;

	/**
	 * Αӏ񍀖ڗpz
	 */
	protected String[] aryKintaiItem;

	/**
	 * oΕ񍀖ڗpz
	 */
	protected String[] arySyukkinItem;

	/**
	 * Lxɏ񍀖ڗpz
	 */
	protected String[] aryYukyuItem;

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID			Ώۃe[uR[h
	 * @param aryKihonItem		l擾pz
	 * @param aryKintaiItem		Αӏ񍀖ڗpz
	 * @param arySyukkinItem	oΕ񍀖ڗpz
	 * @param aryYukyuItem		Lxɏ񍀖ڗpz
	 * @return	String[][]		GNX|[g񍀖ڔz
	 */
	public static String[][] getColumnDataItem(
			String strFLID,
			String[] aryKihonItem,
			String[] aryKintaiItem,
			String[] arySyukkinItem,
			String[] aryYukyuItem
	) {
		int ItemLength = aryKihonItem.length;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			ItemLength += aryKintaiItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			ItemLength += arySyukkinItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			ItemLength += aryYukyuItem.length;
		}
		int i = 0;
		String[][] aryItem = new String[ItemLength][2];
		// l擾pz
		for (i = 0; i < aryKihonItem.length; i++) {
			aryItem[i][0] = aryKihonItem[i];
			aryItem[i][1] = getSplitInfo(aryKihonItem[i], 3);
		}
		// Αӏ񍀖ڗpz
		int j = i;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			for (i = 0; i < aryKintaiItem.length; i++) {
				aryItem[j+i][0] = aryKintaiItem[i];
				aryItem[j+i][1] = getSplitInfo(aryKintaiItem[i], 3);
			}
		}
		// oΕ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			for (i = 0; i < arySyukkinItem.length; i++) {
				aryItem[j+i][0] = arySyukkinItem[i];
				aryItem[j+i][1] = getSplitInfo(arySyukkinItem[i], 3);
			}
		}
		// Lxɏ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			for (i = 0; i < aryYukyuItem.length; i++) {
				aryItem[j+i][0] = aryYukyuItem[i];
				aryItem[j+i][1] = getSplitInfo(aryYukyuItem[i], 3);
			}
		}
		return aryItem;
	}

	/**
	 * tB[h̓̃f[^擾
	 *  0 : t@CID
	 *  1 : Ǘԍ
	 *  2 : tB[hID
	 *  3 : tB[h
	 */
	protected static String getSplitInfo(String str, int i) {
		//@Ǘԍ擾
		if  (str.length()!= 0)  {
			String[] array;
			array = str.split(CommonConst.STR_CSV_SEPARATOR);
			return array[i];
		}
		return "";
	}

}
