<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "32kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.base.PayrollConst"
import = "jp.mosp.human.vo.HumanCardVo"
import = "jp.mosp.payroll.common.vo.AdjustmentCardVo"
%><%
AdjustmentCardVo vo = (AdjustmentCardVo)request.getAttribute(MospConst.ATT_VO);
%><%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_PAYROLL) %>
<div class="Body" id="adjustmentCard">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Change">
		<table id="tblChange">
			<tbody>
				<tr>
					<td>
						<%= PayrollConst.NAM_CHANGE_K_CODE %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td>
						<input type="text" class="UserIdText" id="<%= AdjustmentCardVo.PRM_TXT_CHANGE_K_CODE %>" name="<%= AdjustmentCardVo.PRM_TXT_CHANGE_K_CODE %>" value="<%= vo.getEscTxtChangeKCode() %>" />
					</td>
					<td>
						<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'P3022')">
							<%= PayrollConst.NAM_INPUT_ADJUSTMENT %>
						</button>
					</td>
					<td>
						<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'P3060')">
							<%= PayrollConst.NAM_REFER_WITHHOLD_BOOK %>
						</button>
					</td>
				</tr>
			</tbody>
		</table>
		<table id="tblToList">
			<tbody>
				<tr>
					<td>
						<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'P3001')">
							<%= PayrollConst.NAM_TO_ADJUSTMENT_CALC %>
						</button>
					</td>
					<td>
						<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'P3013')">
							<%= PayrollConst.NAM_TO_ADJUSTMENT_LIST %>
						</button>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<hr>
	<div class="Select">
		<table id="tblEmployee">
			<tbody>
				<tr>
					<td class="LabelTd">
						<%= PayrollConst.NAM_M_KIHON_KCODE + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscHidKCode() %>
						<input type="hidden" id="<%= AdjustmentCardVo.PRM_HID_K_CODE %>" name="<%= AdjustmentCardVo.PRM_HID_K_CODE %>" value="<%= vo.getEscHidKCode() %>" />
					</td>
					<td class="LabelTd">
						<%= PayrollConst.NAM_M_KIHON_SHIME + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscLblKName() %>
					</td>
					<td class="LabelTd">
						<%= PayrollConst.NAM_STATION + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscLblStationName() %> 
					</td>
					<td class="LabelTd">
						<%= PayrollConst.NAM_POSITION + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscLblPositionName() %>
					</td>
					<td class="LabelTd">
						<%= PayrollConst.NAM_ADJUSTMENT_TYPE + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscLblAdjustmentType() %>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="Execute">
		<table id="tblStatus">
			<tbody>
				<tr>
					<td class="LabelTd">
						<%= PayrollConst.NAM_ADJUST_YEAR + PayrollConst.STR_TITLE_SEPARATOR + vo.getHidAdjustYear() + PayrollConst.NAM_YEAR %>
						<input type="hidden" id="<%= AdjustmentCardVo.PRM_HID_ADJUST_YEAR %>" name="<%= AdjustmentCardVo.PRM_HID_ADJUST_YEAR %>" value="<%= vo.getHidAdjustYear() %>" />
					</td>
					<td class="LabelTd">
						<%= PayrollConst.NAM_CALC_STATUS + PayrollConst.STR_TITLE_SEPARATOR + vo.getEscLblAdjustStatus() %>
					</td>
				</tr>
			</tbody>
		</table>
		<table id="tblButton">
			<tbody>
				<tr>
					<td>
						<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form, 'P3023', 'QC0001', '')">
							<%= PayrollConst.NAM_REGIST %>
						</button>
					</td>
					<td>
						<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form, 'P3024', 'QU0001', '<%= PayrollConst.NAM_REGIST_AND_CALCULATE %>')">
							<%= PayrollConst.NAM_REGIST_AND_CALCULATE %>
						</button>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="Card">
		<table id="tblInput1">
			<tbody>
				<tr>
					<td colspan="2">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.CAP_INSURANCE_DEDUCTION %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_GENERAL_LIFE_INS %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_GENERAL_LIFE_INS %>" name="<%= AdjustmentCardVo.PRM_TXT_GENERAL_LIFE_INS %>" value="<%= vo.getTxtGeneralLifeIns() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_PRIVATE_PENSION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_PRIVATE_PENSION %>" name="<%= AdjustmentCardVo.PRM_TXT_PRIVATE_PENSION %>" value="<%= vo.getTxtPrivatePension() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_LIFE_INS_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_LIFE_INS_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_LIFE_INS_DEDUCTION %>" value="<%= vo.getTxtLifeInsDeduction() %>">
					</td>
				</tr>
				<tr class="CaptionTr">
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_EARTHQUAKE_INS %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_EARTHQUAKE_INS %>" name="<%= AdjustmentCardVo.PRM_TXT_EARTHQUAKE_INS %>" value="<%= vo.getTxtEarthquakeIns() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_LONG_TERM_DAMAGE_INS %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_LONG_TERM_DAMAGE_INS %>" name="<%= AdjustmentCardVo.PRM_TXT_LONG_TERM_DAMAGE_INS %>" value="<%= vo.getTxtLongTermDamageIns() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_DAMAGE_INS_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_DAMAGE_INS_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_DAMAGE_INS_DEDUCTION %>" value="<%= vo.getTxtDamageInsDeduction() %>">
					</td>
				</tr>
				<tr class="CaptionTr">
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_SOCIAL_INS_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_SOCIAL_INS_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_SOCIAL_INS_DEDUCTION %>" value="<%= vo.getTxtSocialInsDeduction() %>">
					</td>
				</tr>
				<tr class="CaptionTr">
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_MUTUAL_AID_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_MUTUAL_AID_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_MUTUAL_AID_DEDUCTION %>" value="<%= vo.getTxtMutualAidDeduction() %>">
					</td>
				</tr>

			</tbody>
		</table>

				
		<table id="tblInput2">
			<tbody>
				<tr>
					<td colspan="2">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.CAP_SPOUSE_SP_DEDUCTION %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_SPOUSE_SUM_INCOME %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_SPOUSE_SUM_INCOME %>" name="<%= AdjustmentCardVo.PRM_TXT_SPOUSE_SUM_INCOME %>" value="<%= vo.getTxtSpouseSumIncome() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_SPOUSE_SP_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_SPOUSE_SP_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_SPOUSE_SP_DEDUCTION %>" value="<%= vo.getTxtSpouseSpDeduction() %>">
					</td>
				</tr>
				<tr>
					<td class="CaptionTd" colspan="2">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.CAP_HOUSE_LOAN_DEDUCTION %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_HOUSE_LOAN_DEDUCTION %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_HOUSE_LOAN_DEDUCTION %>" name="<%= AdjustmentCardVo.PRM_TXT_HOUSE_LOAN_DEDUCTION %>" value="<%= vo.getTxtHouseLoanDeduction() %>">
					</td>
				</tr>
				<tr>
					<td class="CaptionTd" colspan="2">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.CAP_ADJUSTMENT_ITEMS %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_ALLOWANCE_ADJUSTMENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_ALLOWANCE_ADJUSTMENT %>" name="<%= AdjustmentCardVo.PRM_TXT_ALLOWANCE_ADJUSTMENT %>" value="<%= vo.getTxtAllowanceAdjustment() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_TAX_FREE_ADJUSTMENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_TAX_FREE_ADJUSTMENT %>" name="<%= AdjustmentCardVo.PRM_TXT_TAX_FREE_ADJUSTMENT %>" value="<%= vo.getTxtTaxFreeAdjustment() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_SOC_INS_ADJUSTMENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_SOC_INS_ADJUSTMENT %>" name="<%= AdjustmentCardVo.PRM_TXT_SOC_INS_ADJUSTMENT %>" value="<%= vo.getTxtSocInsAdjustment() %>">
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= AdjustmentCardVo.NAM_TAX_INC_ADJUSTMENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="text" class="NumberTextBox" id="<%= AdjustmentCardVo.PRM_TXT_TAX_INC_ADJUSTMENT %>" name="<%= AdjustmentCardVo.PRM_TXT_TAX_INC_ADJUSTMENT %>" value="<%= vo.getTxtTaxIncAdjustment() %>">
					</td>
				</tr>

				
			</tbody>
		</table>

		<table id="tblDependence">
			<tbody>
				<tr>
					<td colspan="6">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.NAM_DEPENDENCE_DEDUCTION %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd"><%= PayrollConst.NAM_SELF_WIDOW_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td                ><%= vo.getEscLblSelfWidowType() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_GENERAL_DEPENDENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblGeneralDependent() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_LIVE_WITH_HANDI_GE %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblLiveWithHandiGe() %></td>
				</tr>
				<tr>
					<td class="TitleTd"><%= PayrollConst.NAM_SELF_HANDICAP_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td                ><%= vo.getEscLblSelfHandicapType() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_SPECIFIC_DEPENDENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblSpecificDependent() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_LIVE_WITH_HANDI_SP %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblLiveWithHandiSp() %></td>
				</tr>
				<tr>
					<td class="TitleTd"><%= PayrollConst.NAM_SELF_STUDENT_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td                ><%= vo.getEscLblSelfStudentType() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_ELDERLY_DEPENDENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblElderlyDependent() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_LIVE_WITH_HANDI_EL %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblLiveWithHandiEl() %></td>
				</tr>
				<tr>
					<td class="TitleTd"><%= PayrollConst.NAM_SPOUSE_INTEND_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td                ><%= vo.getEscLblSpouseIntendType() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_LIVE_WITH_ELD_REL %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblLiveWithEldRel() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_LIVE_WITH_HANDI_ER %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblLiveWithHandiEr() %></td>
				</tr>
				<tr>
					<td></td>
					<td></td>
					<td class="TitleTd"><%= PayrollConst.NAM_GENERAL_HANDICAP %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblGeneralHandicap() %></td>
					<td class="TitleTd"><%= PayrollConst.NAM_SPECIFIC_HANDICAP %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" ><%= vo.getEscLblSpecificHandicap() %></td>
				</tr>
			</tbody>
		</table>
		<table  id="tblMidway">
			<tbody>
				<tr>
					<td colspan="5">
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.NAM_MIDWAY_ENTER %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= PayrollConst.NAM_ENTRANCE_DATE %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td colspan="4">
						<%= vo.getEsclblEntranceDate() %>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= PayrollConst.NAM_MIDWAY_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td>
						<%= vo.getEscLblMidwayType() %>
					</td>
					<td class="TitleTd">
						<%= PayrollConst.NAM_FORMER_INCOME %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td class="DataTd">
						<%= vo.getEscLblFormerIncome() %>
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= PayrollConst.NAM_FORMER_INSURANCE %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td class="DataTd">
						<%= vo.getEscLblFormerInsurance() %>
					</td>
					<td class="TitleTd">
						<%= PayrollConst.NAM_FORMER_TAX %><%= PayrollConst.STR_TITLE_SEPARATOR %>
					</td>
					<td class="DataTd">
						<%= vo.getEscLblFormerTax() %>
					</td>
					<td></td>
				</tr>

			</tbody>
		</table>
		<table id="tblInput3">
			<tbody>
				<tr class="CaptionTr">
					<td>
						<%= PayrollConst.BRACKET_LEFT %><%= PayrollConst.NAM_SELF_TYPE %><%= PayrollConst.BRACKET_RIGHT %>
					</td>
					<td class="TitleTd">&nbsp;&nbsp;<%= PayrollConst.NAM_DEAD_RETIREMENT %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="checkbox" class="CheckBox" id="<%= AdjustmentCardVo.PRM_CKB_DEAD_RETIREMENT %>" name="<%= AdjustmentCardVo.PRM_CKB_DEAD_RETIREMENT %>" <%= vo.getEscCkbDeadRetirement() %>>
					</td>
					<td class="TitleTd">&nbsp;&nbsp;<%= PayrollConst.NAM_SELF_DISASTER %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd">
						<input type="checkbox" class="CheckBox" id="<%= AdjustmentCardVo.PRM_CKB_SELF_DISASTER %>" name="<%= AdjustmentCardVo.PRM_CKB_SELF_DISASTER %>" <%= vo.getEscCkbSelfDisaster() %>>
					</td>
					<td class="TitleTd">&nbsp;&nbsp;<%= PayrollConst.NAM_FOREIGNER %><%= PayrollConst.STR_TITLE_SEPARATOR %></td>
					<td class="DataTd" colspan="2">
						<input type="checkbox" class="CheckBox" id="<%= AdjustmentCardVo.PRM_CKB_FOREIGNER %>" name="<%= AdjustmentCardVo.PRM_CKB_FOREIGNER %>" <%= vo.getEscCkbForeigner() %>>
					</td>
				</tr>
			</tbody>
		</table>		
		<input type="hidden" id="<%= HumanCardVo.PRM_HID_SELECT_LIST_CMD %>" name="<%= HumanCardVo.PRM_HID_SELECT_LIST_CMD %>" value="<%= PayrollConst.BTN_ADJUST %>" />
		<table id="tblWithhold">
			<tbody>
				<tr>
					<td>
						<%= PayrollConst.BRACKET_LEFT %><%= AdjustmentCardVo.NAM_WITHHOLD_SLIP_NOTES %><%= PayrollConst.BRACKET_RIGHT %>
<%--
						&nbsp;
						<button type="button" class="ExecuteButton" id="btnAddFamilyInfo" onclick="addFamilyInfo()">
							<%= PayrollConst.NAM_ADD_FAMILY_INFO %>
						</button>
--%>
					</td>
				</tr>
				<tr>
					<td>
						<input type="text"   class="TextBox" id="<%= AdjustmentCardVo.PRM_TXT_WITHHOLD_SLIP_NOTES %>" name="<%= AdjustmentCardVo.PRM_TXT_WITHHOLD_SLIP_NOTES %>" value="<%= vo.getTxtWithholdSlipNotes() %>" />
						<input type="hidden" id="<%= AdjustmentCardVo.PRM_HID_FAMILY_INFO %>" name="<%= AdjustmentCardVo.PRM_HID_FAMILY_INFO %>" value="<%= vo.getEscHidFamilyInfo() %>" />
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
