<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.base.PayrollConst"
import = "jp.mosp.payroll.common.vo.AdjustmentCalcVo"
%><%
AdjustmentCalcVo vo = (AdjustmentCalcVo)request.getAttribute(MospConst.ATT_VO);
String[] aryAdjustStatus   = vo.getEscAryAdjustStatus  ();
String[] aryKCode          = vo.getEscAryKCode         ();
String[] aryKName          = vo.getEscAryKName         ();
String[] aryEntranceDate   = vo.getEscAryEntranceDate  ();
String[] aryRetirementDate = vo.getEscAryRetirementDate();
String[] aryAdjustmentType = vo.getEscAryAdjustmentType();
String[] aryTaxGap         = vo.getEscAryTaxGap        ();
%><%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_PAYROLL) %>
<div class="Body" id="adjustmentCalc">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Select">
		<table id="tblBackAdjustYear">
			<tr>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmitMessage(document.form, 'P3007', 'QU0002', '<%= PayrollConst.NAM_ADJUST_YEAR %>')"><%= PayrollConst.NAM_BACK_ADJUST_YEAR %></button>
				</td>
<%--
			</tr>
		</table>
		<table id="tblNextAdjustYear">
			<tr>
 --%>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmitMessage(document.form, 'P3006', 'QU0003', '<%= PayrollConst.NAM_ADJUST_YEAR %>')"><%= PayrollConst.NAM_NEXT_ADJUST_YEAR %></button>
				</td>
			</tr>
		</table>
		<table id="tblAdjustYear">
			<tr>
				<td>
					<%= PayrollConst.NAM_ADJUST_YEAR + PayrollConst.STR_TITLE_SEPARATOR + vo.getHidAdjustYear() + PayrollConst.NAM_YEAR %>
					<input type="hidden" id="<%= AdjustmentCalcVo.PRM_HID_ADJUST_YEAR %>" name="<%= AdjustmentCalcVo.PRM_HID_ADJUST_YEAR %>" value="<%= vo.getHidAdjustYear() %>" />
				</td>
			</tr>
		</table>
		<table id="tblExecuteAdjust">
			<tr>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'P3021')"><%= PayrollConst.NAM_INPUT_ADJUSTMENT %></button>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmitMessage(document.form, 'P3005', 'QU0001', '<%= PayrollConst.NAM_CALC_ADJUSTMENT %>')"><%= PayrollConst.NAM_CALC_ADJUSTMENT %></button>
				</td>
			</tr>
		</table>
		<table id="tblToAdjustData">
			<tr>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'P3011')">
						<%= PayrollConst.NAM_TO_ADJUSTMENT_LIST %>
					</button>
				</td>
			</tr>
		</table>
		<table id="tblAdjustOutPut">
			<tr>
				<%--
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3032')"><%= PayrollConst.NAM_WITHHOLD_SLIP %></button>
				</td>
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3042')"><%= PayrollConst.NAM_WITHHOLD_BOOK %></button>
				</td>
				 --%>
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3052')"><%= PayrollConst.NAM_OUTPUT_ADJUSTMENT %></button>
				</td>
				<td>
					<%--
					<button type="button" onclick=""><%= PayrollConst.NAM_PAYMENT_LEDGER %></button>
					<button type="button" onclick="submitFile(document.form, 'U3342')"><%= PayrollConst.NAM_PAYMENT_LEDGER %></button>
					--%>
				</td>
			</tr>
		</table>
	</div>
	<hr>
	<div class="Search">
		<table>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= PayrollConst.NAM_M_KIHON_KCODE %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= AdjustmentCalcVo.PRM_TXT_K_CODE %>" name="<%= AdjustmentCalcVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= PayrollConst.NAM_M_KIHON_SHIME %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= AdjustmentCalcVo.PRM_TXT_K_NAME %>" name="<%= AdjustmentCalcVo.PRM_TXT_K_NAME %>" value="<%= vo.getEscTxtKName() %>" />
				</td>
				<td id="tdPosition">
					<span class="TitleLabel">&nbsp;&nbsp;&nbsp;&nbsp;<%= PayrollConst.NAM_POSITION %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select  id="<%= AdjustmentCalcVo.PRM_PLT_POSITION %>" name="<%= AdjustmentCalcVo.PRM_PLT_POSITION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltPosition, vo.getPltPosition()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= PayrollConst.NAM_MIDWAY_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= AdjustmentCalcVo.PRM_PLT_MIDWAY_TYPE %>" name="<%= AdjustmentCalcVo.PRM_PLT_MIDWAY_TYPE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltMidwayType, vo.getPltMidwayType()) %>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P3002')"><%= PayrollConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td>
					<span class="TitleLabel">&nbsp;<%= PayrollConst.NAM_RETIREMENT_FLAG %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select class="RetirementSelect" id="<%= AdjustmentCalcVo.PRM_PLT_RETIREMENT %>" name="<%= AdjustmentCalcVo.PRM_PLT_RETIREMENT %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltRetirement, vo.getPltRetirement()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel">&nbsp;<%= PayrollConst.NAM_K_KANA %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= AdjustmentCalcVo.PRM_TXT_K_KANA %>" name="<%= AdjustmentCalcVo.PRM_TXT_K_KANA %>" value="<%= vo.getEscTxtKKana() %>" />
				</td>
				<td>
					<span class="TitleLabel"><%= PayrollConst.NAM_ADJUSTMENT_TYPE %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= AdjustmentCalcVo.PRM_PLT_ADJUSTMENT_TYPE %>" name="<%= AdjustmentCalcVo.PRM_PLT_ADJUSTMENT_TYPE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAdjustmentType, vo.getPltAdjustmentType()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel">&nbsp;&nbsp;<%= PayrollConst.NAM_ADJUST_STATUS %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= AdjustmentCalcVo.PRM_PLT_ADJUST_STATUS %>" name="<%= AdjustmentCalcVo.PRM_PLT_ADJUST_STATUS %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAdjustStatus, vo.getPltAdjustStatus()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th class="ButtonTh"></th>
					<th id="thStatus"     onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_ADJUST_STATUS   %>', '')">&nbsp;<%= PayrollConst.NAM_ADJUST_STATUS   %>&nbsp;<%= vo.getSortMark(vo.KEY_ADJUST_STATUS  ) %></th>
					<th id="thKCode"      onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_K_CODE          %>', '')">&nbsp;<%= PayrollConst.NAM_M_KIHON_KCODE          %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE         ) %></th>
					<th id="thKName"      onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_K_NAME          %>', '')">&nbsp;<%= PayrollConst.NAM_M_KIHON_SHIME          %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME         ) %></th>
					<th id="thEntrance"   onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_ENTRANCE        %>', '')">&nbsp;<%= PayrollConst.NAM_ENTRANCE_DATE   %>&nbsp;<%= vo.getSortMark(vo.KEY_ENTRANCE       ) %></th>
					<th id="thRetirement" onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_RETIREMENT      %>', '')">&nbsp;<%= PayrollConst.NAM_RETIREMENT_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_RETIREMENT     ) %></th>
					<th id="thAdjustType" onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_ADJUSTMENT_TYPE %>', '')">&nbsp;<%= PayrollConst.NAM_ADJUSTMENT_TYPE %>&nbsp;<%= vo.getSortMark(vo.KEY_ADJUSTMENT_TYPE) %></th>
					<th id="thTaxGap"     onclick="doSubmitKey(document.form, 'P3004', '<%= vo.KEY_TAX_GAP         %>', '')">&nbsp;<%= PayrollConst.NAM_TAX_GAP         %>&nbsp;<%= vo.getSortMark(vo.KEY_TAX_GAP        ) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P3022', '<%= aryKCode[i] %>', ''                            )"><%= PayrollConst.NAM_INPUT %></button>
					</td>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P3060', '<%= aryKCode[i] %>', '<%= vo.getHidAdjustYear() %>')"><%= PayrollConst.NAM_REFER %></button>
					</td>
					<td                 ><%= aryAdjustStatus  [i] %></td>
					<td                 ><%= aryKCode         [i] %></td>
					<td                 ><%= aryKName         [i] %></td>
					<td                 ><%= aryEntranceDate  [i] %></td>
					<td                 ><%= aryRetirementDate[i] %></td>
					<td class="CenterTd"><%= aryAdjustmentType[i] %></td>
					<td class="RightTd" ><%= aryTaxGap        [i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
