<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "32kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.vo.ScheduleConfirmListVo"
import = "jp.mosp.common.common.BaseVo"
%><%
ScheduleConfirmListVo vo = (ScheduleConfirmListVo)request.getAttribute(MospConst.ATT_VO);
String[][] arySchedule = vo.getEscArySchedule();
String[] aryLabel = vo.getEscAryLabel();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_INPUT, vo.CMD_SCHEDULE_MENU, vo.TTL_SCHEDULE_MENU) %>
<div class="Body" id="scheduleList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectSectionName() %>
				</td>
<!--	2008/11/14	m.yoshida	I\	-->
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K1220')"><%= CommonConst.TTL_SCHEDULE_INPUT %></button>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, '<%= vo.CMD_SCHEDULE_EDIT_SEARCH %>')"><%= vo.TTL_SCHEDULE_EDIT %></button>
				</td>
				<td class="ButtonTd">
					&nbsp;
				</td>
			</tr>
		</table>
	</div>
	<div class="YearMonth">
		<table>
			<tr>
				<td class="YearMonthTd">
					<select id="<%= ScheduleConfirmListVo.PRM_PLT_YEAR %>" name="<%= ScheduleConfirmListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear()) %>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= ScheduleConfirmListVo.PRM_PLT_MONTH %>" name="<%= ScheduleConfirmListVo.PRM_PLT_MONTH %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth()) %>
					</select><%= CommonConst.NAM_MONTH %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K1232')"><%= CommonConst.NAM_RE_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thDay"				><%= CommonConst.NAM_DAY %>			</th>
					<th id="thDayOfWeek"		><%= CommonConst.NAM_DAY_OF_WEEK %>	</th>
					<th id="thAttendanceType"	><%= CommonConst.NAM_WORKING_TYPE %></th>
					
					<th class="TimeTh" ><%= CommonConst.NAM_START_TIME %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_QUIT_TIME %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_PAYMENT_HOURS_ABB %></th>
					<th class="TimeTh" ><%= CommonConst.NAM_INTERVAL_TIME %>	</th>
					
					<th class="RemarksTh" ><%= CommonConst.NAM_REMARKS %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < arySchedule.length; i++) {
%>
				<tr>
					<td id="tdDay"				><%= BaseVo.escapeHTML(arySchedule[i][0]) %></td>
					<td id="tdDayOfWeek"		><%= BaseVo.escapeHTML(arySchedule[i][1]) %></td>
					<td id="tdAttendanceType"	><%= BaseVo.escapeHTML(arySchedule[i][2]) %></td>
					
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(arySchedule[i][3]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(arySchedule[i][4]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(arySchedule[i][5]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(arySchedule[i][6]) %></td>
										
					<td class="RemarksTd"><%= BaseVo.escapeHTML(arySchedule[i][7]) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
		<table id="sum">
			<tr>
				<td class="sumLbl">
					<%= aryLabel[0] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[1] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[2] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[3] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[4] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[5] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[6] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[7] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[8] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[9] %>
				</td>
			</tr>
			<tr>
				<td>
					<%= vo.getEscWorkTimes() %>
				</td>
				<td>
					<%= vo.getEscBreakTimes() %>
				</td>
				<td>
					<%= vo.getEscPresence() %>
				</td>
				<td >
					<%= vo.getEscPaidHoliday() %>
				</td>
				<td >
					<%= vo.getEscParticularHoliday() %>
				</td>
				<td >
					<%= vo.getEscAbsence() %>
				</td>
				<td >
					<%= vo.getEscSick() %>
				</td>
				<td >
					<%= vo.getEscCompensationLeave() %>
				</td>
				<td >
					<%= vo.getEscTransfer() %>
				</td>
				<td >
					<%= vo.getEscOther() %>
				</td>
			</tr>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
