<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.vo.AttendanceHolidayCardVo"
%><%
AttendanceHolidayCardVo vo = (AttendanceHolidayCardVo) request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.getCmdMenuButton(), vo.getCmdListButton(), vo.getNamListButton()) %>
<div class="Body" id="holidayCard">
	<%=HtmlUtility.getMessages(vo)%>
	<jsp:include page="attendanceMenu.jsp" />
	<div id="divTitle"><span id="spnMode"></span></div>
	<div class="Card">
		<table id="tblHoliday">
			<thead>
				<tr>
					<th id="thTime" colspan="2">
						<%= CommonConst.NAM_VACATION_LEAVE %><%= CommonConst.NAM_COMMON_ITEM %>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td class="Title1Td"><%=AttendanceHolidayCardVo.NAM_HOLIDAY_REASON%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select class="ReasonSelect" id="<%= AttendanceHolidayCardVo.PRM_PLT_HOLIDAY_REASON %>" name="<%= AttendanceHolidayCardVo.PRM_PLT_HOLIDAY_REASON %>">
							<%=HtmlUtility.getSelectOption(vo.aryPltHolidayReason, vo.getPltHolidayReason())%>
						</select>
					</td>
				</tr>
				<tr>
					<td class="Title1Td"><%=AttendanceHolidayCardVo.NAM_HOLIDAY_CERTIFICATE%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceHolidayCardVo.PRM_PLT_HOLIDAY_CERTIFICATE %>" name="<%= AttendanceHolidayCardVo.PRM_PLT_HOLIDAY_CERTIFICATE %>">
							<option value=""></option>
							<%=HtmlUtility.getSelectOption(vo.aryPltHolidayCertificate, vo.getPltHolidayCertificate())%>
					</select></td>
				</tr>
				<tr>
					<td class="Title1Td">
						<%=AttendanceHolidayCardVo.NAM_HOLIDAY_COMMENT%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="TextBox" id="<%= AttendanceHolidayCardVo.PRM_TXT_HOLIDAY_COMMENT %>" name="<%= AttendanceHolidayCardVo.PRM_TXT_HOLIDAY_COMMENT %>" value="<%= vo.getEscTxtHolidayComment() %>" />
					</td>
				</tr>
				<tr>
					<td class="Title1Td">
						<%=AttendanceHolidayCardVo.NAM_SUBSTITUTE_HOLIDAY%><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select id="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_YEAR %>" name="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_YEAR %>">
							<option value=""></option>
							<%= HtmlUtility.getSelectOption(vo.aryPltSubstituteYear, vo.getPltSubstituteYear()) %>
						</select><%= CommonConst.NAM_YEAR %>
						<select id="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_MONTH %>" name="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_MONTH %>">
							<option value=""></option>
							<%= HtmlUtility.getSelectOption(vo.aryPltSubstituteMonth, vo.getPltSubstituteMonth()) %>
						</select><%= CommonConst.NAM_MONTH %>
						<select id="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_DAY %>" name="<%= AttendanceHolidayCardVo.PRM_PLT_SUBSTITUTE_DAY %>">
							<option value=""></option>
							<%= HtmlUtility.getSelectOption(vo.aryPltSubstituteDay, vo.getPltSubstituteDay()) %>
						</select><%= CommonConst.NAM_DAY %>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
	<div class="Footer">
		<button type="button" class="ExecuteButton" id="btnRegist" onclick="submitForm(document.form)"><%=CommonConst.NAM_REGIST%></button>
		<button type="button" class="ExecuteButton" id="btnDelete" onclick="doSubmitMessage(document.form, 'K1133','QC0002' ,'')"><%= CommonConst.NAM_DELETE %></button>
	</div>
</div>
<%=HtmlUtility.getFooter(vo)%>
