/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;

import jp.mosp.workflow.dto.AttendanceRouteDto;

public class AttendanceRouteListVo extends ApprovalMenuVo {

	private static final long serialVersionUID = 7562923266126590833L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/workflow/attendanceRouteList.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/attendanceRouteList.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/attendanceRouteList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_APPROVAL_ATTENDANCE;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_K_CODE			= "txtKCode";
	public static final String PRM_TXT_K_NAME			= "txtKName";
	public static final String PRM_TXT_ROUTE_CODE		= "txtRouteCode";
	public static final String PRM_PLT_OFFICE 			= "pltOffice";
	public static final String PRM_PLT_SECTION	 		= "pltSection";

	// tB[h
	public String[][] aryAttendanceRoute;

	private String 	txtKCode;
	private String 	txtKName;
	private String 	txtRouteCode;
	private String 	pltOffice;
	private String 	pltSection;

	// tB[hyѐ
	public static final String NAM_K_CODE		= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME		= CommonConst.NAM_K_NAME;
	public static final String NAM_ROUTE_CODE	= CommonConst.NAM_APPROVAL_ROUTE + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_OFFICE	 	= CommonConst.NAM_OFFICE;
	public static final String NAM_SECTION 	= CommonConst.NAM_STATION;

	public static final String NAM_CODE		= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_LAYER1		= CommonConst.NAM_1ST_APPROVED;
	public static final String NAM_LAST_LAYER	= CommonConst.NAM_2ND_APPROVED;

	public static final int    LEN_CODE		= CommonConst.LEN_K_CODE;
	public static final int    LEN_NAME		= CommonConst.LEN_K_NAME;

	// \[gL[
	public final String KEY_SECTION	= "keySectionCode";
	public final String KEY_K_CODE		= "keyKCode";
	public final String KEY_OFFICE 	= "keyOffice";

	// [h(0FȂA1F)
	private int searchmode;

	// v_E
	public String[][] aryPltOffice;
	public String[][] aryPltSection;
	public String[][] aryPltUser;
	public String[][] aryPltUnit;

	/**
	 * RXgN^
	 */
	public AttendanceRouteListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtKCode		= "";
		txtKName		= "";
		txtRouteCode	= "";
		pltOffice 		= "";
		pltSection		= "";
		aryAttendanceRoute	= new String[0][0];
		setFormerKey(KEY_SECTION);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtKCode		= request.getParameter(PRM_TXT_K_CODE);
		txtKName		= request.getParameter(PRM_TXT_K_NAME);
		txtRouteCode	= request.getParameter(PRM_TXT_ROUTE_CODE);
		pltOffice 		= request.getParameter(PRM_PLT_OFFICE);
		pltSection		= request.getParameter(PRM_PLT_SECTION);
	}

	/**
	 * tB[hݒ
	 * @param listAttendanceRoute ΑӏF[gXg
	 */
	public void setFields(List listAttendanceRoute) {
		// Xg̐ݒ
		list = listAttendanceRoute;
		// f[^̎擾
		count = listAttendanceRoute.size();
		// z̏
		aryAttendanceRoute = new String[count][6];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listAttendanceRoute.iterator();
		while (it.hasNext()) {
			AttendanceRouteDto dto = (AttendanceRouteDto)it.next();
			aryAttendanceRoute[i][0] = String.valueOf(dto.getRouteId());
			aryAttendanceRoute[i][1] = escapeHTML(getCodeName(dto.getSCode(), aryPltSection));
			aryAttendanceRoute[i][2] = escapeHTML(getCodeName(dto.getKCode(), aryPltUser));
			aryAttendanceRoute[i][3] = escapeHTML(getCodeName(dto.getLayer1(), aryPltUnit));
			aryAttendanceRoute[i][4] = escapeHTML(getCodeName(dto.getLastLayer(), aryPltUnit));
			aryAttendanceRoute[i][5] = escapeHTML(getCodeName(dto.getJCode(), aryPltOffice));
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getEscAryAttendanceRoute() { return aryAttendanceRoute.clone(); }

	public String getTxtKCode() 	{ return txtKCode		; }
	public String getTxtKName() 	{ return txtKName		; }
	public String getTxtRouteCode()	{ return txtRouteCode	; }
	public String getPltOffice() 	{ return pltOffice		; }
	public String getPltSection() 	{ return pltSection		; }

	public String getEscTxtKCode() 		{ return escapeHTML(txtKCode)		; }
	public String getEscTxtKName()		{ return escapeHTML(txtKName)		; }
	public String getEscTxtRouteCode()	{ return escapeHTML(txtRouteCode)	; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
