/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

public class KeisanInformationCardVo extends MosPVo {

	private static final long serialVersionUID = 5208549895641511511L;

	//URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/keisanInformationCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/keisanInformationCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/keisanInformationCard.css";

	//ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ATT_CALCULATE_MENU + CommonConst.NAM_INFORMATION;

	//萔
	public static final int MODE_UPDATE = 1;

	//p[^[
	public static final String PRM_TXT_KTNEN 		= "txtKTNen";
	public static final String PRM_PLT_KTTUKI   	= "pltKTTuki";
	public static final String PRM_TXT_KSNEN   	= "txtKSNen";
	public static final String PRM_PLT_KSTUKI   	= "pltKSTuki";
	public static final String PRM_HID_KSHI  		= "hidKShi";
	public static final String PRM_PLT_KKANRYOU  	= "pltKKanryou";

	//tB[h
	private String  	txtKTnen 	;	
	private String 		pltKTtuki 	;
	private String  	txtKSnen 	;	
	private String		pltKStuki	;
	private String		hidKShi		;
	private String		lblKShi		;
	private String		pltKKanryou	;

	//[h(1FXV)
	private int mode;

	//tB[hyѐ
	public static final String NAM_KTNEN 		= CommonConst.NAM_ATTENDANCE_CALCULATE + CommonConst.NAM_YEAR;
	public static final String NAM_KTTUKI 		= CommonConst.NAM_ATTENDANCE_CALCULATE + CommonConst.NAM_MONTH;
	public static final String NAM_KSNEN 		= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_SUPPLY + CommonConst.NAM_YEAR;
	public static final String NAM_KSTUKI		= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_SUPPLY + CommonConst.NAM_MONTH;
	public static final String NAM_KSHI 		= CommonConst.NAM_CONFIRM_PAYMENT + CommonConst.NAM_PROVIDED_DATE ;
	public static final String NAM_KKANRYOU 	= CommonConst.NAM_CALCULATE_END + CommonConst.NAM_INFORMATION ;

	public static final int LEN_YEAR			= CommonConst.LEN_YEAR;

	// v_EXg
	public String[][] aryPltMonth;
	public String[][] aryPltDays;
	public String[][] aryPltCompleteFlag;

	/**
	 * RXgN^
	 */
	public KeisanInformationCardVo(){
		super();
		mode = 0;
		setExtraCss	(EXTRA_CSS);
		addExtraJs	(EXTRA_JS);
		setRetUrl	(RETURN_URL);
		txtKTnen		= "0";
		pltKTtuki		= "0";
		txtKSnen		= "0";
		pltKStuki		= "0";
		hidKShi			= "0";
		lblKShi			= "0";
		pltKKanryou		= "0";
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request){
		txtKTnen 	= request.getParameter(PRM_TXT_KTNEN 		);
		pltKTtuki  	= request.getParameter(PRM_PLT_KTTUKI    	);
		txtKSnen  	= request.getParameter(PRM_TXT_KSNEN    	);
		pltKStuki 	= request.getParameter(PRM_PLT_KSTUKI    	);
		hidKShi  	= request.getParameter(PRM_HID_KSHI   		);
		pltKKanryou = request.getParameter(PRM_PLT_KKANRYOU   	);
		lblKShi 	= hidKShi;
	}

	/**
	 * tB[hݒ(DTOVOɃZbg)
	 * @param dto Xg
	 */
	public void setFields(MKintaiKeisanDto dto){

		txtKTnen 	= String.valueOf(dto.getKTNen());
		pltKTtuki 	= String.valueOf(dto.getKTTuki());
		txtKSnen 	= String.valueOf(dto.getKSNen());
		pltKStuki 	= String.valueOf(dto.getKSTuki());
		hidKShi 	= String.valueOf(dto.getKShi());
		pltKKanryou = dto.getKKanryou();
		lblKShi 	= hidKShi;		
	}

	/**
	 * tB[hݒ(DTOVOɃZbg)
	 * @param date1 ΑӌvZN
	 * @param date2 ^xN
	 */
	public void setFields(Date date1, Date date2){
		txtKTnen 	= String.valueOf(MospUtility.getYear(date1));
		pltKTtuki 	= String.valueOf(MospUtility.getMonth(date1));
		txtKSnen 	= String.valueOf(MospUtility.getYear(date2));
		pltKStuki 	= String.valueOf(MospUtility.getMonth(date2));
		hidKShi 	= String.valueOf(MospUtility.getDay(date2));
		pltKKanryou = CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_OFF;
		lblKShi 	= hidKShi;		
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MKintaiKeisanDto dto) {
		dto.setKTNen	(Integer.parseInt(txtKTnen)		);
		dto.setKTTuki	(Integer.parseInt(pltKTtuki)	);
		dto.setKSNen	(Integer.parseInt(txtKSnen)		);
		dto.setKSTuki	(Integer.parseInt(pltKStuki)	);
		dto.setKShi		(Integer.parseInt(hidKShi)		);
		dto.setKKanryou	(pltKKanryou  					);
	}

	/**
	 * tB[h̑ÓmFiLxɏj
	 * @throws MospException
	 */
	public void validate() throws MospException {
		//ÓmFJn
		startValidation();
		//K{mF
		checkRequired(txtKTnen	, NAM_KTNEN 	, PRM_TXT_KTNEN 	);
		checkRequired(txtKSnen	, NAM_KSNEN 	, PRM_TXT_KSNEN   	);
		//񒷊mF
		checkLength(txtKTnen	, LEN_YEAR		, NAM_KTNEN 	, PRM_TXT_KTNEN 	);
		checkLength(txtKSnen	, LEN_YEAR		, NAM_KSNEN 	, PRM_TXT_KSNEN   	);
		//^CvmF(p)
		checkNumber(txtKTnen	, NAM_KTNEN 	, PRM_TXT_KTNEN 	);
		checkNumber(txtKSnen	, NAM_KSNEN 	, PRM_TXT_KSNEN   	);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String  getDirectJs(Class cls) throws IllegalAccessException{
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();		
	}

	//ANZT\bh
	public String getTxtKTnen()		{ return txtKTnen		; }
	public String getPltKTtuki() 	{ return pltKTtuki		; }
	public String getTxtKSnen()		{ return txtKSnen		; }
	public String getPltKStuki()	{ return pltKStuki		; }
	public String getHidKShi() 		{ return hidKShi		; }
	public String getPltKKanryou()	{ return pltKKanryou	; }

	public String getEscTxtKTnen() 		{ return escapeHTML(txtKTnen)		; }
	public String getEscTxtKSnen()		{ return escapeHTML(txtKSnen)		; }
	public String getEscLblKShi() 		{ return escapeHTML(lblKShi)		; }

	public void setTxtKTnen  		(String txtKTnen	)	{ this.txtKTnen		= txtKTnen 		; }
	public void setPltKTtuki 		(String pltKTtuki	)	{ this.pltKTtuki 	= pltKTtuki 	; }
	public void setTxtKSnen 		(String txtKSnen	)	{ this.txtKSnen 	= txtKSnen 		; }
	public void setPltKStuki 		(String pltKStuki	)	{ this.pltKStuki 	= pltKStuki 	; }
	public void setHidKShi 		(String hidKShi		)	{ this.hidKShi 		= hidKShi 		; }
	public void setPltKKanryou 	(String pltKKanryou	)	{ this.pltKKanryou 	= pltKKanryou 	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
