/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MCodeDto;

public class CodeMasterListVo extends MosPVo {

	private static final long serialVersionUID = -6348454372992171132L;

	// URLACSS
	private static final String RETURN_URL	= "/jsp/system/codeMasterList.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/codeMasterList.js";
	private static final String EXTRA_CSS		= "/pub/system/css/codeMasterList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_CODE_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_PLT_T_ID		= "pltTId";
	public static final String PRM_TXT_T_CODE		= "txtTCode";
	public static final String PRM_TXT_T_NAME		= "txtTName";
	public static final String PRM_TXT_T_CHANGE 	= "txtTChange";

	// tB[h
	private String[]	aryTId;
	private String[]	aryTCode;
	private String[]	aryTName;
	private String[]	aryTChange;
	private String		pltTId;
	private String		txtTCode;
	private String		txtTName;
	private String		txtTChange;

	// tB[hyѐ
	public static final String NAM_CODE_ID	= CommonConst.NAM_TABLE;
	public static final String NAM_CODE		= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_NAME		= CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_CHANGE		= CommonConst.NAM_CONVERSION; 		//ϊ
	public static final int	LEN_CODE_ID		= 50;
	public static final int	LEN_CODE		= 9;
	public static final int	LEN_NAME		= 25;
	public static final int	LEN_CHANGE		= 25;

	// \[gL[
	public final String KEY_T_ID		= "keyTId";
	public final String KEY_T_CODE		= "keyTCode";
	public final String KEY_T_NAME		= "keyTName";

	// v_EXg
	public String[][] aryPltTId;

	// [h(0FȂA1F)
	private int searchmode;

	public CodeMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		pltTId			= "";
		txtTCode		= "";
		txtTName		= "";
		txtTChange		= "";
		aryTId			= new String[0];
		aryTCode		= new String[0];
		aryTName		= new String[0];
		aryTChange		= new String[0];
		setFormerKey(KEY_T_ID);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltTId		= request.getParameter(PRM_PLT_T_ID);
		txtTCode	= request.getParameter(PRM_TXT_T_CODE);
		txtTName	= request.getParameter(PRM_TXT_T_NAME);
		txtTChange	= request.getParameter(PRM_TXT_T_CHANGE);
	}

	/**
	 * tB[hݒ
	 * @param listCode	R[hXg
	 * @throws MospException
	 */
	public void setFields(List listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryTId		= new String[count];
		aryTCode	= new String[count];
		aryTName	= new String[count];
		aryTChange	= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listCode.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryTId[i]		= escapeHTML(dto.getTId());
			aryTCode[i]		= escapeHTML(dto.getTCode());
			aryTName[i]		= escapeHTML(dto.getTName());
			aryTChange[i]	= escapeHTML(dto.getTChange());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryTId		() { return aryTId.clone()		; }
	public String[] getEscAryTCode		() { return aryTCode.clone()	; }
	public String[] getEscAryTName		() { return aryTName.clone()	; }
	public String[] getEscAryTChange	() { return aryTChange.clone()	; }

	public String getPltTId			() { return pltTId		; }
	public String getTxtTCode		() { return txtTCode	; }
	public String getTxtTName		() { return txtTName	; }
	public String getTxtTChange		() { return txtTChange	; }

	public String getEscPltTId		() { return escapeHTML(pltTId)		; }
	public String getEscTxtTCode	() { return escapeHTML(txtTCode)	; }
	public String getEscTxtTName	() { return escapeHTML(txtTName)	; }
	public String getEscTxtTChange	() { return escapeHTML(txtTChange)	; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
