/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.KintaiSystemDefinitionCardVo;

public class KintaiSystemDefinitionCardAction extends MosPAction {

	// R}h
	private static final String CMD_KINTAI_SYSTEM_DEFINITION_CARD_SHOW   = "S2500";	// \
	private static final String CMD_KINTAI_SYSTEM_DEFINITION_CARD_UPDATE = "S2508";	// XV

	/**
	 * RXgN^
	 */
	public KintaiSystemDefinitionCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		// VO̎擾
		KintaiSystemDefinitionCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_KINTAI_SYSTEM_DEFINITION_CARD_SHOW)) {
			// \
			show(vo);
			// [hݒ
			vo.setMode(KintaiSystemDefinitionCardVo.MODE_UPDATE);
		} else if (cmd.equals(CMD_KINTAI_SYSTEM_DEFINITION_CARD_UPDATE)) {
			// ړ͒l擾
			vo.setParams(request);
			// ڍXV
			regist(vo);
			// \
			show(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * VOCX^X擾
	 * @return	VO
	 */
	protected KintaiSystemDefinitionCardVo getInitVo() {
		return new KintaiSystemDefinitionCardVo();
	}

	/**
	 * Action
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(KintaiSystemDefinitionCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// v_E̐ݒ
		vo.aryPltCalcMonth 		= setPltCalcMonth();
		vo.aryPltProvidedMonth 	= setPltProvidedMonth();
	}

	/**
	 * ݒ荀ڌ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	protected void show(KintaiSystemDefinitionCardVo vo) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// @JԁATԖ@J
		vo.setFieldStatutoryHours(dao.findForCondition(CommonConst.TID_STATUTORY));
		// Ԗ@JԁAԖ@J
		vo.setFieldStatutoryMonth(dao.findForCondition(CommonConst.TID_STATUTORY_MONTH));
		// ΑӒAΑӒ
		vo.setFieldCalc(dao.findForCondition(CommonConst.TID_CALCULATION));
		// ^xA^x
		vo.setFieldProvided(dao.findForCondition(CommonConst.TID_PROVIDED_DATE));
		// ͒P
		vo.setFieldInputUnit(dao.findForKey(CommonConst.TID_INPUT_UNIT_TIMES, CommonConst.TCD_MINUTES));
		// vZASxAxA[JnA[鎞
		vo.setFieldWorkSystem(dao.findForCondition(CommonConst.TID_WORK_SYSTEM));
		// pX[hL
		vo.setFieldPasswordTerm(String.valueOf(getPasswordTerm()));
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void regist(KintaiSystemDefinitionCardVo vo) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		MCodeDto dto = new MCodeDto();
		// @J
		vo.setDtoFieldStatutoryHours(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// TԖ@J		
		vo.setDtoFieldStatutoryWeek(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// Ԗ@J		
		vo.setDtoFieldStatutoryMonthHours(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// Ԗ@J		
		vo.setDtoFieldStatutoryMonthDays(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// ΑӒ
		vo.setDtoFieldCalcMonth(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// ΑӒ
		vo.setDtoFieldCalcDays(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// ^x
		vo.setDtoFieldProvidedMonth(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// ^x
		vo.setDtoFieldProvidedDays(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// ͒P	
		vo.setDtoFieldInputUnit(dto);
		// rmF
		// f[^̍XV		
		update(dto, dao, vo);
		// vZ	
		vo.setDtoFieldAutoCalc(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// SxAx	
		vo.setDtoFieldHoliday(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// [JnA[鎞	
		vo.setDtoFieldLateNight(dto);
		// f[^̍XV		
		update(dto, dao, vo);		
		// pX[hL
		vo.setDtoFieldPasswordTerm(dto);
		// f[^̍XV		
		update(dto, dao, vo);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(KintaiSystemDefinitionCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
	}

	/**
	 * ߌpv_E
	 * @return	aryPltCalcMonth
	 * @throws Exception
	 */
	protected String[][] setPltCalcMonth() throws Exception {
		String[][] aryPltCalcMonth = new String[2][2];
		aryPltCalcMonth[0][0] = CommonConst.NUM_CUT_OFF_MONTH_THIS;
		aryPltCalcMonth[0][1] = CommonConst.NAM_CUT_OFF_MONTH_THIS;
		aryPltCalcMonth[1][0] = CommonConst.NUM_CUT_OFF_MONTH_FORMER;
		aryPltCalcMonth[1][1] = CommonConst.NAM_CUT_OFF_MONTH_FORMER;
		return aryPltCalcMonth;
	}

	/**
	 * ^xpv_E
	 * @return	aryPltCalcMonth
	 * @throws Exception
	 */
	protected String[][] setPltProvidedMonth() throws Exception {
		String[][] aryPltCalcMonth = new String[2][2];
		aryPltCalcMonth[0][0] = CommonConst.NUM_PROVIDED_MONTH_THIS;
		aryPltCalcMonth[0][1] = CommonConst.NAM_PROVIDED_MONTH_THIS;
		aryPltCalcMonth[1][0] = CommonConst.NUM_PROVIDED_MONTH_FUTURE;
		aryPltCalcMonth[1][1] = CommonConst.NAM_PROVIDED_MONTH_FUTURE;
		return aryPltCalcMonth;
	}

	/**
	 * XV
	 * @param dto
	 * @param dao
	 * @param vo
	 * @throws Exception
	 */
	protected void update(MCodeDto dto, MCodeDao dao, KintaiSystemDefinitionCardVo vo) throws Exception {
		// DTO̍Ď擾
		MCodeDto retDto;
		if (chkExistDto(dao.findForUpdate(dto.getTId(), dto.getTCode()))) {
			// rmF
			chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dao.findForUpdate(dto.getTId(), dto.getTCode()), vo);
			// f[^̍XV		
			dao.update(dto);
		} else {
			// dmF
			chkDuplicate(dao.findForKey(dto.getTId(), dto.getTCode()), vo);
			// f[^̓o^		
			dao.insert(dto);
		}
		// Abvf[g̃`FbN
		retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
	}

}
