/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import java.util.Date;


import jp.mosp.common.common.BaseDto;

public class CdSocInsuranceDto extends BaseDto{
	private static final long serialVersionUID = 1812427511435550686L;
	
	protected String kCode              = ""; // ЈR[h
	protected String kName              = ""; // Ј
	protected String sCode              = ""; // R[h
	protected Date   calcDate               ; // vZN
	protected int payBasicMonth1        =  0; // xb1()
	protected int payBasicMonth2        =  0; // xb2()
	protected int payBasicMonth3        =  0; // xb3()
	protected int payBasicDay1          =  0; // xb1()
	protected int payBasicDay2          =  0; // xb2()
	protected int payBasicDay3          =  0; // xb3()
	protected int payAmount1            =  0; // K̊z1
	protected int payAmount2            =  0; // K̊z2
	protected int payAmount3            =  0; // K̊z3
	protected int goodsAmount1          =  0; // ̊z1
	protected int goodsAmount2          =  0; // ̊z2
	protected int goodsAmount3          =  0; // ̊z3
	protected int rewardTotal1          =  0; // Vv1
	protected int rewardTotal2          =  0; // Vv2
	protected int rewardTotal3          =  0; // Vv3
	protected int rewardTotalSum        =  0; // Vz
	protected int averageThreeMonths    =  0; // R
	protected int editAverage           =  0; // C
	protected int healthBefGrade        =  0; // ۏ]O
	protected int healthBefPremium      =  0; // ۏ]Oی
	protected int pensionBefGrade       =  0; // N]O
	protected int pensionBefPremium     =  0; // N]Oی
	protected int healthDecGrade        =  0; // ی蓙
	protected int healthDecPremium      =  0; // یی
	protected int pensionDecGrade       =  0; // N蓙
	protected int pensionDecPremium     =  0; // Nی
	protected int retroactivePayment    =  0; // kyxz
	protected Date raiseDownSalaryDate      ; // ~N
	protected int  raiseDownSalaryBasis =  0; // ~̌z
	protected Date expectedDate             ; // KpN
	protected int  calcResult           =  0; // vZ
	
	
	public String getKCode            () { return kCode                 ; } // ЈR[h
	public String getKName            () { return kName                 ; } // Ј
	public String getSCode            () { return sCode                 ; } // R[h
	public Date getCalcDate           () { return getDateField(calcDate); } // vZN
	public int getPayBasicMonth1      () { return payBasicMonth1        ; } // xb1()
	public int getPayBasicMonth2      () { return payBasicMonth2        ; } // xb2()
	public int getPayBasicMonth3      () { return payBasicMonth3        ; } // xb3()
	public int getPayBasicDay1        () { return payBasicDay1          ; } // xb1()
	public int getPayBasicDay2        () { return payBasicDay2          ; } // xb2()
	public int getPayBasicDay3        () { return payBasicDay3          ; } // xb3()
	public int getPayAmount1          () { return payAmount1            ; } // K̊z1
	public int getPayAmount2          () { return payAmount2            ; } // K̊z2
	public int getPayAmount3          () { return payAmount3            ; } // K̊z3
	public int getGoodsAmount1        () { return goodsAmount1          ; } // ̊z1
	public int getGoodsAmount2        () { return goodsAmount2          ; } // ̊z2
	public int getGoodsAmount3        () { return goodsAmount3          ; } // ̊z3
	public int getRewardTotal1        () { return rewardTotal1          ; } // Vv1
	public int getRewardTotal2        () { return rewardTotal2          ; } // Vv2
	public int getRewardTotal3        () { return rewardTotal3          ; } // Vv3
	public int getRewardTotalSum      () { return rewardTotalSum        ; } // Vz
	public int getAverageThreeMonths  () { return averageThreeMonths    ; } // R
	public int getEditAverage         () { return editAverage           ; } // C
	public int getHealthBefGrade      () { return healthBefGrade        ; } // ۏ]O
	public int getHealthBefPremium    () { return healthBefPremium      ; } // ۏ]Oی
	public int getPensionBefGrade     () { return pensionBefGrade       ; } // N]O
	public int getPensionBefPremium   () { return pensionBefPremium     ; } // N]Oی
	public int getHealthDecGrade      () { return healthDecGrade        ; } // ی蓙
	public int getHealthDecPremium    () { return healthDecPremium      ; } // یی
	public int getPensionDecGrade     () { return pensionDecGrade       ; } // N蓙
	public int getPensionDecPremium   () { return pensionDecPremium     ; } // Nی
	public int getRetroactivePayment  () { return retroactivePayment    ; } // kyxz
	public Date getRaiseDownSalaryDate() { return getDateField(raiseDownSalaryDate); } // ~N
	public int getRaiseDownSalaryBasis() { return raiseDownSalaryBasis ; } // ~̌z
	public Date getExpectedDate       () { return getDateField(expectedDate); } // KpN
	public int getCalcResult          () { return calcResult            ; } // vZ
	
	public void setKCode              (String kCode               ) { this.kCode               = kCode                  ; } // ЈR[h
	public void setKName              (String kName               ) { this.kName               = kName                  ; } // Ј
	public void setSCode             (String sCode                ) { this.sCode        		 = sCode                  ; } // R[h
	public void setCalcDate           (Date  calcDate             ) { this.calcDate            = getDateField(calcDate) ; } // vZN
	public void setPayBasicMonth1     (int   payBasicMonth1       ) { this.payBasicMonth1      = payBasicMonth1         ; } // xb1()
	public void setPayBasicMonth2     (int   payBasicMonth2       ) { this.payBasicMonth2      = payBasicMonth2         ; } // xb2()
	public void setPayBasicMonth3     (int   payBasicMonth3       ) { this.payBasicMonth3      = payBasicMonth3         ; } // xb3()
	public void setPayBasicDay1       (int   payBasicDay1         ) { this.payBasicDay1        = payBasicDay1           ; } // xb1()
	public void setPayBasicDay2       (int   payBasicDay2         ) { this.payBasicDay2        = payBasicDay2           ; } // xb2()
	public void setPayBasicDay3       (int   payBasicDay3         ) { this.payBasicDay3        = payBasicDay3           ; } // xb3()

	public void setPayAmount1          (int   payAmount1          ) { this.payAmount1           = payAmount1            ; } // K̊z1
	public void setPayAmount2          (int   payAmount2          ) { this.payAmount2           = payAmount2            ; } // K̊z2
	public void setPayAmount3          (int   payAmount3          ) { this.payAmount3           = payAmount3            ; } // K̊z3
	public void setGoodsAmount1        (int   goodsAmount1        ) { this.goodsAmount1         = goodsAmount1          ; } // ̊z1
	public void setGoodsAmount2        (int   goodsAmount2        ) { this.goodsAmount2         = goodsAmount2          ; } // ̊z2
	public void setGoodsAmount3        (int   goodsAmount3        ) { this.goodsAmount3         = goodsAmount3          ; } // ̊z3
	public void setRewardTotal1        (int   rewardTotal1        ) { this.rewardTotal1         = rewardTotal1          ; } // Vv1
	public void setRewardTotal2        (int   rewardTotal2        ) { this.rewardTotal2         = rewardTotal2          ; } // Vv2
	public void setRewardTotal3        (int   rewardTotal3        ) { this.rewardTotal3         = rewardTotal3          ; } // Vv3
	public void setRewardTotalSum      (int   rewardTotalSum      ) { this.rewardTotalSum       = rewardTotalSum        ; } // Vz
	public void setAverageThreeMonths  (int   averageThreeMonths  ) { this.averageThreeMonths   = averageThreeMonths    ; } // R
	public void setEditAverage         (int   editAverage         ) { this.editAverage          = editAverage           ; } // C
	public void setHealthBefGrade      (int   healthBefGrade      ) { this.healthBefGrade       = healthBefGrade        ; } // ۏ]O
	public void setHealthBefPremium    (int   healthBefPremium    ) { this.healthBefPremium     = healthBefPremium      ; } // ۏ]Oی
	public void setPensionBefGrade     (int   pensionBefGrade     ) { this.pensionBefGrade      = pensionBefGrade       ; } // N]O
	public void setPensionBefPremium   (int   pensionBefPremium   ) { this.pensionBefPremium    = pensionBefPremium     ; } // N]Oی
	public void setHealthDecGrade      (int   healthDecGrade      ) { this.healthDecGrade       = healthDecGrade        ; } // ی蓙
	public void setHealthDecPremium    (int   healthDecPremium    ) { this.healthDecPremium     = healthDecPremium      ; } // یی
	public void setPensionDecGrade     (int   pensionDecGrade     ) { this.pensionDecGrade      = pensionDecGrade       ; } // N蓙
	public void setPensionDecPremium   (int   pensionDecPremium   ) { this.pensionDecPremium    = pensionDecPremium     ; } // Nی
	public void setRetroactivePayment  (int   retroactivePayment  ) { this.retroactivePayment   = retroactivePayment    ; } // kyxz
	public void setRaiseDownSalaryDate (Date  raiseDownSalarydate ) { this.raiseDownSalaryDate  = getDateField(raiseDownSalarydate); } // ~N
	public void setRaiseDownSalaryBasis(int   raiseDownSalaryBasis) { this.raiseDownSalaryBasis = raiseDownSalaryBasis ; } // ~̌z
	public void setExpectedDate        (Date  expectedDate        ) { this.expectedDate         = getDateField(expectedDate); } // KpN
	public void setCalcResult          (int   calcResult          ) { this.calcResult           = calcResult           ; } // vZ
}
