/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.dto.MSyukkinboDto;

public class AttendanceQuitCardVo extends AttendanceMenuVo {

	private static final long serialVersionUID = -5662028312748138291L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/attendanceQuitCard.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/attendanceQuitCard.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/attendanceQuitCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.NAM_INPUT_QUIT;

	// p[^
	public static final String PRM_LBL_WORK_TYPE		= "lblWorkType"		;
	public static final String PRM_TXT_QUIT_HOUR 		= "txtQuitHour"		;
	public static final String PRM_TXT_QUIT_MIN 		= "txtQuitMin"		;
	public static final String PRM_PLT_HALF_HOLIDAY 	= "pltHalfHoliday"	;
	public static final String PRM_TXT_WORK_HOUR 		= "txtWorkHour"		;
	public static final String PRM_TXT_WORK_MIN 		= "txtWorkMin"		;
	public static final String PRM_TXT_BREAK_HOUR 	= "txtBreakHour"	;
	public static final String PRM_TXT_BREAK_MIN 		= "txtBreakMin"		;
	public static final String PRM_LBL_ACTUAL_HOUR	= "lblActualHour"	;
	public static final String PRM_LBL_ACTUAL_MIN		= "lblActualMin"	;

	public static final String PRM_PLT_LEAVE_EARLY_REASON			= "pltLeaveEarlyReason"		;
	public static final String PRM_TXT_LEAVE_EARLY_HOUR			= "txtLeaveEarlyHour"		;
	public static final String PRM_TXT_LEAVE_EARLY_MIN			= "txtLeaveEarlyMin"		;
	public static final String PRM_PLT_LEAVE_EARLY_CERTIFICATE 	= "pltLeaveEarlyCertificate";
	public static final String PRM_TXT_LEAVE_EARLY_COMMENT 		= "txtLeaveEarlyComment"	;

	public static final String PRM_TXT_OVER_HOUR 				= "txtOverHour"				;
	public static final String PRM_TXT_OVER_MIN 				= "txtOverMin"				;
	public static final String PRM_TXT_WORK_ON_HOLIDAY_HOUR 	= "txtWorkOnHolidayHour"	;
	public static final String PRM_TXT_WORK_ON_HOLIDAY_MIN 	= "txtWorkOnHolidayMin"		;
	public static final String PRM_TXT_LATE_NIGHT_HOUR 		= "txtLateNightHour"		;
	public static final String PRM_TXT_LATE_NIGHT_MIN 		= "txtLateNightMin"			;

	public static final String PRM_CKB_SYOKUJI 	= "ckbSyokuji"	;
	public static final String PRM_CKB_CYOKU1 	= "ckbCyoku1"	;	
	public static final String PRM_CKB_CYOKU2 	= "ckbCyoku2"	;
	public static final String PRM_CKB_CYOKU3 	= "ckbCyoku3"	;
	public static final String PRM_CKB_HOKA1		= "ckbHoka1"	;
	public static final String PRM_CKB_HOKA2		= "ckbHoka2"	;
	public static final String PRM_CKB_HOKA3	 	= "ckbHoka3"	;
	public static final String PRM_CKB_HOKA4		= "ckbHoka4"	;
	public static final String PRM_CKB_HOKA5		= "ckbHoka5"	;

	// tB[hyѐ
	public static final String NAM_WORKING_TYPE			= CommonConst.NAM_WORKING_TYPE;
	public static final String NAM_QUIT_TIME				= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
	public static final String NAM_QUIT_TIME_HOUR 		= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_QUIT_TIME_MIN 			= CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_HALF_HOLIDAY			= CommonConst.NAM_VACATION_LEAVE_HALF 	+ CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_WORKING_TIME			= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORKING_TIME_HOUR 		= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_WORKING_TIME_MIN 		= CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_INTERVAL_TIME			= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_INTERVAL_TIME_HOUR 	= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_INTERVAL_TIME_MIN 		= CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_ACTUAL_WORK_TIME		= CommonConst.NAM_ACTUAL_WORK_TIME 		+ CommonConst.NAM_COMMON_TIME;

	public static final String NAM_LEAVE_EARLY_REASON			= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_REASON;
	public static final String NAM_LEAVE_EARLY_TIME			= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LEAVE_EARLY_TIME_HOUR		= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LEAVE_EARLY_TIME_MIN		= CommonConst.NAM_LEAVE_EARLY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LEAVE_EARLY_CERTIFICATE	= CommonConst.NAM_CERTIFICATE;
	public static final String NAM_LEAVE_EARLY_COMMENT 		= CommonConst.NAM_COMMENT;

	public static final String NAM_OVER_TIME				= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_OVER_TIME_HOUR			= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_OVER_TIME_MIN			= CommonConst.NAM_OVERTIME 			+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_WORK_ON_HOLIDAY 		= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_WORK_ON_HOLIDAY_HOUR 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_WORK_ON_HOLIDAY_MIN 	= CommonConst.NAM_WORK_ON_HOLIDAY 	+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;
	public static final String NAM_LATE_NIGHT 			= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME;
	public static final String NAM_LATE_NIGHT_HOUR 		= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_LATE_NIGHT_MIN 		= CommonConst.NAM_LATE_NIGHT 		+ CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;

	public static final String NAM_ALLOWANCE 	= CommonConst.NAM_ALLOWANCE;

	public static final int	LEN_HOUR  		= CommonConst.LEN_TIME_HOUR;
	public static final int	LEN_MIN  		= CommonConst.LEN_TIME_MIN;
	public static final int	LEN_COMMENT		= 50;

	// tB[h
	private String lblWorkType;
	private String txtQuitHour;
	private String txtQuitMin;
	private String pltHalfHoliday;
	private String txtWorkHour;
	private String txtWorkMin;
	private String txtBreakHour;
	private String txtBreakMin;
	private String lblActualHour;
	private String lblActualMin;

	private String pltLeaveEarlyReason;
	private String txtLeaveEarlyHour;
	private String txtLeaveEarlyMin;
	private String pltLeaveEarlyCertificate;
	private String txtLeaveEarlyComment;

	private String txtOverHour;
	private String txtOverMin;
	private String txtWorkOnHolidayHour;
	private String txtWorkOnHolidayMin;
	private String txtLateNightHour;
	private String txtLateNightMin;

	private String ckbSyokuji;
	private String ckbCyoku1;
	private String ckbCyoku2;
	private String ckbCyoku3;
	private String ckbHoka1;
	private String ckbHoka2;
	private String ckbHoka3;
	private String ckbHoka4;
	private String ckbHoka5;

	// 蓖
	public String[][] aryAllowance;
	// Ζ`
	public String[][] aryWorkType;

	// v_EXg
	public String[][] aryPltLeaveEarlyReason;
	public String[][] aryPltLeaveEarlyCertificate;
	public String[][] aryPltHalfHoliday;

	/**
	 * RXgN^
	 */	
	public AttendanceQuitCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = MODE_EDIT;
		aryAllowance = new String[0][0];
		aryWorkType = new String[0][0];
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		super.setParams(request);
		txtQuitHour 		= request.getParameter(PRM_TXT_QUIT_HOUR);
		txtQuitMin 			= request.getParameter(PRM_TXT_QUIT_MIN);
		pltHalfHoliday 		= request.getParameter(PRM_PLT_HALF_HOLIDAY);
		txtWorkHour 		= request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin 			= request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour		= request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin			= request.getParameter(PRM_TXT_BREAK_MIN);

		pltLeaveEarlyReason			= request.getParameter(PRM_PLT_LEAVE_EARLY_REASON);
		txtLeaveEarlyHour 			= request.getParameter(PRM_TXT_LEAVE_EARLY_HOUR);
		txtLeaveEarlyMin 			= request.getParameter(PRM_TXT_LEAVE_EARLY_MIN);
		pltLeaveEarlyCertificate	= request.getParameter(PRM_PLT_LEAVE_EARLY_CERTIFICATE);
		txtLeaveEarlyComment		= request.getParameter(PRM_TXT_LEAVE_EARLY_COMMENT);

		txtOverHour				= request.getParameter(PRM_TXT_OVER_HOUR);
		txtOverMin				= request.getParameter(PRM_TXT_OVER_MIN);
		txtWorkOnHolidayHour	= request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		txtWorkOnHolidayMin		= request.getParameter(PRM_TXT_WORK_ON_HOLIDAY_MIN);
		txtLateNightHour		= request.getParameter(PRM_TXT_LATE_NIGHT_HOUR);
		txtLateNightMin			= request.getParameter(PRM_TXT_LATE_NIGHT_MIN);

		ckbSyokuji 	= getCheckBoxParam(request.getParameter(PRM_CKB_SYOKUJI));
		ckbCyoku1 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU1));
		ckbCyoku2 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU2));
		ckbCyoku3 	= getCheckBoxParam(request.getParameter(PRM_CKB_CYOKU3));
		ckbHoka1 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA1));
		ckbHoka2 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA2));
		ckbHoka3 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA3));
		ckbHoka4 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA4));
		ckbHoka5 	= getCheckBoxParam(request.getParameter(PRM_CKB_HOKA5));

	}

	/**
	 * tB[hݒ
	 * @param dto	ΏDTO
	 * @throws MospException 
	 */
	public void setFields(MSyukkinboDto dto) {
		txtQuitHour 	= util.convStringTimeToStringHour(dto.getTaJikoku());
		txtQuitMin		= util.convStringTimeToStringMinutes(dto.getTaJikoku());
		pltHalfHoliday 	= dto.getTHankyuKb();
		txtWorkHour  	= util.convIntegerTimeToStringHour(dto.getKinmuJi());
		txtWorkMin  	= util.convIntegerTimeToStringMinutes(dto.getKinmuJi());
		txtBreakHour 	= util.convIntegerTimeToStringHour(dto.getKyukeiJi());
		txtBreakMin 	= util.convIntegerTimeToStringMinutes(dto.getKyukeiJi());

		pltLeaveEarlyReason 		= dto.getSoRiyuu();
		txtLeaveEarlyHour 			= util.convIntegerTimeToStringHour(dto.getSoJikan());
		txtLeaveEarlyMin 			= util.convIntegerTimeToStringMinutes(dto.getSoJikan());
		pltLeaveEarlyCertificate 	= dto.getSoSyoumei();
		txtLeaveEarlyComment 		= dto.getSoComent();

		txtOverHour 				= util.convIntegerTimeToStringHour(dto.getZaJikan());
		txtOverMin 					= util.convIntegerTimeToStringMinutes(dto.getZaJikan());
		txtWorkOnHolidayHour 		= util.convIntegerTimeToStringHour(dto.getKsJikan());
		txtWorkOnHolidayMin 		= util.convIntegerTimeToStringMinutes(dto.getKsJikan());
		txtLateNightHour			= util.convIntegerTimeToStringHour(dto.getSnJikan());
		txtLateNightMin				= util.convIntegerTimeToStringMinutes(dto.getSnJikan());

		ckbSyokuji 	= String.valueOf(dto.getSyokuji());
		ckbCyoku1 	= String.valueOf(dto.getCyoku1());
		ckbCyoku2 	= String.valueOf(dto.getCyoku2());
		ckbCyoku3 	= String.valueOf(dto.getCyoku3());
		ckbHoka1 	= String.valueOf(dto.getHoka1());
		ckbHoka2 	= String.valueOf(dto.getHoka2());
		ckbHoka3 	= String.valueOf(dto.getHoka3());
		ckbHoka4 	= String.valueOf(dto.getHoka4());
		ckbHoka5 	= String.valueOf(dto.getHoka5());
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto	ΏDTO
	 */
	@Override
	public void setDtoFields(MSyukkinboDto dto) {
		super.setDtoFields(dto);
		dto.setTaJikoku(util.convStringTimeFormatted(txtQuitHour, txtQuitMin));
		dto.setTHankyuKb(pltHalfHoliday);
		dto.setKinmuJi(util.convStringTimeToIntegerTime(txtWorkHour, txtWorkMin));
		dto.setKyukeiJi(util.convStringTimeToIntegerTime(txtBreakHour, txtBreakMin));
		dto.setSoRiyuu(pltLeaveEarlyReason);
		dto.setSoJikan(util.convStringTimeToIntegerTime(txtLeaveEarlyHour, txtLeaveEarlyMin));
		dto.setSoSyoumei(pltLeaveEarlyCertificate);
		dto.setSoComent(txtLeaveEarlyComment);
		dto.setZaJikan(util.convStringTimeToIntegerTime(txtOverHour, txtOverMin));
		dto.setKsJikan(util.convStringTimeToIntegerTime(txtWorkOnHolidayHour, txtWorkOnHolidayMin));
		dto.setSnJikan(util.convStringTimeToIntegerTime(txtLateNightHour, txtLateNightMin));
		dto.setSyokuji(Integer.parseInt(ckbSyokuji));
		dto.setCyoku1(Integer.parseInt(ckbCyoku1));
		dto.setCyoku2(Integer.parseInt(ckbCyoku2));
		dto.setCyoku3(Integer.parseInt(ckbCyoku3));
		dto.setHoka1(Integer.parseInt(ckbHoka1));
		dto.setHoka2(Integer.parseInt(ckbHoka2));
		dto.setHoka3(Integer.parseInt(ckbHoka3));
		dto.setHoka4(Integer.parseInt(ckbHoka4));
		dto.setHoka5(Integer.parseInt(ckbHoka5));
		dto.setTaTimes(util.getDateTime(util.getNowDate()));
		dto.setSnRiyuu(CommonConst.NUM_ATTENDANCE_REQUEST);
		dto.setUpdtTimes(util.getDateTime(util.getNowDate()));

	}

	/**
	 * tB[h
	 */
	public void initFields() {
		Date nowDate = new Date();
		txtQuitHour 			= String.valueOf(MospUtility.getHour(nowDate));
		txtQuitMin 				= String.valueOf(MospUtility.getMinute(nowDate));
		pltHalfHoliday 			= "";
		txtWorkHour 			= "0";
		txtWorkMin 				= "0";
		txtBreakHour 			= "0";
		txtBreakMin 			= "0";

		pltLeaveEarlyReason 	= "";
		txtLeaveEarlyHour 		= "0";
		txtLeaveEarlyMin 		= "0";
		pltLeaveEarlyCertificate= "";
		txtLeaveEarlyComment 	= "";

		txtOverHour 			= "0";
		txtOverMin 				= "0";
		txtWorkOnHolidayHour 	= "0";
		txtWorkOnHolidayMin 	= "0";
		txtLateNightHour = "0";
		txtLateNightMin = "0";

		ckbSyokuji 				= "0";
		ckbCyoku1 				= "0";
		ckbCyoku2 				= "0";
		ckbCyoku3 				= "0";
		ckbHoka1 				= "0";
		ckbHoka2 				= "0";
		ckbHoka3 				= "0";
		ckbHoka4 				= "0";
		ckbHoka5 				= "0";
	}

	/**
	 * x\ڃZbg
	 * @param dto	ΏDTO
	 */
	public void setLabelInfo(MSyukkinboDto dto) {
		// Ζ`Ԗ̂̃Zbg
		for (int i = 0; i < aryWorkType.length; i++) {
			if (dto.getKinmu().equals(aryWorkType[i][0])) {
				setLblWorkType(aryWorkType[i][1]);
			}
		}
		// Ԃ̃Zbg
		//  = Ζ - xeԁicƋxeԊ܂ށj
		int actual = 0;
		if (dto.getKinmuJi() != 0) {
			actual = dto.getKinmuJi() - dto.getKyukeiJi();
		}
		setLblActualHour(util.convIntegerTimeToStringHour(actual));
		setLblActualMin(util.convIntegerTimeToStringMinutes(actual));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtQuitHour			, NAM_QUIT_TIME			, PRM_TXT_QUIT_HOUR);
		checkRequired(txtQuitMin			, NAM_QUIT_TIME			, PRM_TXT_QUIT_MIN);
		checkRequired(txtWorkHour			, NAM_WORKING_TIME		, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin			, NAM_WORKING_TIME 		, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour			, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin			, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkRequired(txtLeaveEarlyHour		, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkRequired(txtLeaveEarlyMin		, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkRequired(txtOverHour			, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkRequired(txtOverMin			, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkRequired(txtWorkOnHolidayHour	, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkRequired(txtWorkOnHolidayMin	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkRequired(txtLateNightHour		, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkRequired(txtLateNightMin		, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		// mF
		checkNumber(txtQuitHour			, NAM_QUIT_TIME			, PRM_TXT_QUIT_HOUR);
		checkNumber(txtQuitMin			, NAM_QUIT_TIME			, PRM_TXT_QUIT_MIN);
		checkNumber(txtWorkHour			, NAM_WORKING_TIME		, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin			, NAM_WORKING_TIME 		, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour		, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin			, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkNumber(txtLeaveEarlyHour	, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkNumber(txtLeaveEarlyMin	, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkNumber(txtOverHour			, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkNumber(txtOverMin			, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkNumber(txtWorkOnHolidayHour, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkNumber(txtWorkOnHolidayMin	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkNumber(txtLateNightHour	, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkNumber(txtLateNightMin		, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		// mF	
		checkLength(txtQuitHour	, LEN_HOUR		, NAM_QUIT_TIME		, PRM_TXT_QUIT_HOUR);
		checkLength(txtQuitMin	, LEN_MIN		, NAM_QUIT_TIME		, PRM_TXT_QUIT_MIN);
		checkLength(txtWorkHour	, LEN_HOUR		, NAM_WORKING_TIME	, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin	, LEN_MIN		, NAM_WORKING_TIME	, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour		, LEN_HOUR	, NAM_INTERVAL_TIME		, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin			, LEN_MIN	, NAM_INTERVAL_TIME 	, PRM_TXT_BREAK_MIN);
		checkLength(txtLeaveEarlyHour	, LEN_HOUR	, NAM_LEAVE_EARLY_TIME	, PRM_TXT_LEAVE_EARLY_HOUR);
		checkLength(txtLeaveEarlyMin	, LEN_MIN	, NAM_LEAVE_EARLY_TIME 	, PRM_TXT_LEAVE_EARLY_MIN);
		checkLength(txtOverHour			, LEN_HOUR	, NAM_OVER_TIME			, PRM_TXT_OVER_HOUR);
		checkLength(txtOverMin			, LEN_MIN	, NAM_OVER_TIME 		, PRM_TXT_OVER_MIN);
		checkLength(txtWorkOnHolidayHour, LEN_HOUR	, NAM_WORK_ON_HOLIDAY	, PRM_TXT_WORK_ON_HOLIDAY_HOUR);
		checkLength(txtWorkOnHolidayMin	, LEN_MIN	, NAM_WORK_ON_HOLIDAY 	, PRM_TXT_WORK_ON_HOLIDAY_MIN);
		checkLength(txtLateNightHour	, LEN_HOUR	, NAM_LATE_NIGHT		, PRM_TXT_LATE_NIGHT_HOUR);
		checkLength(txtLateNightMin		, LEN_MIN	, NAM_LATE_NIGHT 		, PRM_TXT_LATE_NIGHT_MIN);

		checkLength(txtLeaveEarlyComment, LEN_COMMENT, NAM_LEAVE_EARLY_COMMENT, PRM_TXT_LEAVE_EARLY_COMMENT);

		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtQuitHour	() { return txtQuitHour		; }
	public String getTxtQuitMin		() { return txtQuitMin		; }
	public String getPltHalfHoliday	() { return pltHalfHoliday	; }
	public String getTxtWorkHour	() { return txtWorkHour		; }
	public String getTxtWorkMin		() { return txtWorkMin		; }
	public String getTxtBreakHour	() { return txtBreakHour	; }
	public String getTxtBreakMin	() { return txtBreakMin		; }

	public String getPltLeaveEarlyReason		() { return pltLeaveEarlyReason			; }
	public String getTxtLeaveEarlyHour			() { return txtLeaveEarlyHour			; }
	public String getTxtLeaveEarlyMin			() { return txtLeaveEarlyMin			; }
	public String getPltLeaveEarlyCertificate	() { return pltLeaveEarlyCertificate	; }
	public String getTxtLeaveEarlyComment		() { return txtLeaveEarlyComment		; }

	public String getTxtOverHour			() { return txtOverHour				; }
	public String getTxtOverMin				() { return txtOverMin				; }
	public String getTxtWorkOnHolidayHour	() { return txtWorkOnHolidayHour	; }
	public String getTxtWorkOnHolidayMin	() { return txtWorkOnHolidayMin		; }
	public String getTxtLateNightHour		() { return txtLateNightHour		; }
	public String getTxtLateNightMin		() { return txtLateNightMin			; }

	public String getCkbSyokuji	() { return ckbSyokuji	; }
	public String getCkbCyoku1	() { return ckbCyoku1	; }
	public String getCkbCyoku2	() { return ckbCyoku2	; }
	public String getCkbCyoku3	() { return ckbCyoku3	; }
	public String getCkbHoka1	() { return ckbHoka1	; }
	public String getCkbHoka2	() { return ckbHoka2	; }
	public String getCkbHoka3	() { return ckbHoka3	; }
	public String getCkbHoka4	() { return ckbHoka4	; }
	public String getCkbHoka5	() { return ckbHoka5	; }

	public String getEscTxtQuitHour		() { return escapeHTML(txtQuitHour		); }
	public String getEscTxtQuitMin		() { return escapeHTML(txtQuitMin		); }
	public String getEscPltHalfHoliday	() { return escapeHTML(pltHalfHoliday	); }
	public String getEscTxtWorkHour		() { return escapeHTML(txtWorkHour		); }
	public String getEscTxtWorkMin		() { return escapeHTML(txtWorkMin		); }
	public String getEscTxtBreakHour	() { return escapeHTML(txtBreakHour		); }
	public String getEscTxtBreakMin		() { return escapeHTML(txtBreakMin		); }

	public String getEscPltLeaveEarlyReason			() { return escapeHTML(pltLeaveEarlyReason		); }
	public String getEscTxtLeaveEarlyHour			() { return escapeHTML(txtLeaveEarlyHour		); }
	public String getEscTxtLeaveEarlyMin			() { return escapeHTML(txtLeaveEarlyMin			); }
	public String getEscPltLeaveEarlyCertificate	() { return escapeHTML(pltLeaveEarlyCertificate	); }
	public String getEscTxtLeaveEarlyComment		() { return escapeHTML(txtLeaveEarlyComment		); }

	public String getEscTxtOverHour				() { return escapeHTML(txtOverHour			); }
	public String getEscTxtOverMin				() { return escapeHTML(txtOverMin			); }
	public String getEscTxtWorkOnHolidayHour	() { return escapeHTML(txtWorkOnHolidayHour	); }
	public String getEscTxtWorkOnHolidayMin		() { return escapeHTML(txtWorkOnHolidayMin	); }
	public String getEscTxtLateNightHour		() { return escapeHTML(txtLateNightHour		); }
	public String getEscTxtLateNightMin			() { return escapeHTML(txtLateNightMin		); }

	public String getEscCkbSyokuji	() { return getCheckBoxChecked(ckbSyokuji	); }
	public String getEscCkbCyoku1	() { return getCheckBoxChecked(ckbCyoku1	); }
	public String getEscCkbCyoku2	() { return getCheckBoxChecked(ckbCyoku2	); }
	public String getEscCkbCyoku3	() { return getCheckBoxChecked(ckbCyoku3	); }
	public String getEscCkbHoka1	() { return getCheckBoxChecked(ckbHoka1		); }
	public String getEscCkbHoka2	() { return getCheckBoxChecked(ckbHoka2		); }
	public String getEscCkbHoka3	() { return getCheckBoxChecked(ckbHoka3		); }
	public String getEscCkbHoka4	() { return getCheckBoxChecked(ckbHoka4		); }
	public String getEscCkbHoka5	() { return getCheckBoxChecked(ckbHoka5		); }

	public String getEscLblWorkType		() { return escapeHTML(lblWorkType		); }	
	public String getEscLblActualHour	() { return escapeHTML(lblActualHour	); }
	public String getEscLblActualMin	() { return escapeHTML(lblActualMin		); }

	public void setLblWorkType		(String lblWorkType) 	{ this.lblWorkType 		= lblWorkType	; }
	public void setLblActualHour	(String lblActualHour) 	{ this.lblActualHour 	= lblActualHour	; }
	public void setLblActualMin	(String lblActualMin) 	{ this.lblActualMin 	= lblActualMin	; }

	public String[][] getAryAllowance() { return aryAllowance.clone(); }

}
