/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.io.Serializable;
//import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
//import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;

//import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.vo.EmployeeApprovalListVo;

public class EmployeeApprovalListAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_APPROVAL_LIST_SHOW 		= "K2110";
	public  static final String CMD_APPROVAL_LIST_RE_SEARCH 	= "K2112";
	private static final String CMD_APPROVAL_LIST_SORT 		= "K2113";

	/**
	 * RXgN^
	 */
	public EmployeeApprovalListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// RlNV擾
		getConnection();
		// MANAGERmF
		confirmManagerAuth();
		// VO̎擾
		EmployeeApprovalListVo vo;
		vo = (EmployeeApprovalListVo)getStoredVo(CommonConst.VO_EMPLOYEE_APPROVAL_LIST);
		if (vo == null) {
			vo = new EmployeeApprovalListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_EMPLOYEE_APPROVAL_LIST, vo);
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// [U[擾
		getInfo(user.getUserId());
		// ͏擾
		setParams(vo);
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_LIST_SHOW)) {
			// 
			serachEmployeeList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();			
			sortList(vo);
		} else if (cmd.equals(CMD_APPROVAL_LIST_RE_SEARCH)) {
			// Č
			serachEmployeeList(vo);
			vo.setPageButton();
			sortList(vo);
		} else if (cmd.equals(CMD_APPROVAL_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ͏擾
	 * @param vo
	 * @throws Exception
	 */
	private void setParams(EmployeeApprovalListVo vo) throws Exception {
		// v_E擾
		vo.arySectionAll	= getSectionArrayAll();
		vo.aryPositionAll	= getPositionArray();
		vo.aryPltYear 		= util.getYearArray(MospUtility.getYear(getCalcMonth()));
		vo.aryPltMonth 		= util.getMonthArray();
		// Ώ۔N擾
		vo.setParams(request);
		if (vo.getPltSelectYear() == null) {
			vo.setPltSelectYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
			vo.setPltSelectMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
		}
		// l{ݒ
		vo.setLblKCode(mKihon.getKCode());
		vo.setLblKName(mKihon.getSimei());
		vo.setLblSectionName(getSectionName(mKihon.getSCode()));
	}

	/**
	 * ЈXg
	 * @param vo EmployeeListVoCX^X
	 * @throws Exception
	 */
	private void serachEmployeeList(EmployeeApprovalListVo vo) throws Exception {
		/*		
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// Ώ۔N擾
		Date targetDate = util.getFirstDateOfMonth(vo.getPltSelectYear(), vo.getPltSelectMonth());
		// ͈͎擾
		int startDate = util.convDateToInteger(getStartDate(targetDate));
		// 		
		MKihonDao mKihonDao = new MKihonDao();
		mKihonDao.initDao(cfg, cmd, aspUser, user, conn);
		// ̐ݒ
		List<MKihonDto> mKihonList = new ArrayList<MKihonDto>();
		String[][] aryRouteInfo = getBelongRouteInfoArray(mKihon.getKCode(), targetDate);
		List<MKihonDto> addMkihonList = new ArrayList<MKihonDto>();
		for (int i = 0; i < aryRouteInfo.length; i++) {
			// I̎Јꗗ
			List<MKihonDto> selectSectionUserList = mKihonDao.findForApproval(
					aryRouteInfo[i][0],
					mKihon.getJCode(),
					mKihon.getKCode(),
					user.getDataLevel(),
					startDate
			);
			Iterator<MKihonDto> it = selectSectionUserList.iterator();
			while (it.hasNext()) {
				MKihonDto mKihonDto = (MKihonDto)it.next();
				mKihonList.add(mKihonDto);
			}
			// ǉЈ
			MKihonDto addMKihonDto = mKihonDao.findForKey(aryRouteInfo[i][1]);
			if (chkExistDto(addMKihonDto)) {
				boolean isExist = false;
				if (mKihonList.size() != 0) {
					for (int k = 0; k < mKihonList.size(); k++) {
						// ꗗɂłɒǉЈ񂪓o^Ă邩
						if (addMKihonDto.getKCode().equals(mKihonList.get(k).getKCode())) {
							isExist = true;
							break;
						}
					}
				}
				// ꗗɑ݂ȂΒǉB
				if (!isExist) {
					addMkihonList.add(addMKihonDto);
				}
			}
		}
		// ǉЈꗗ֒ǉ
		for (int i = 0; i < addMkihonList.size(); i++) {
			mKihonList.add(addMkihonList.get(i));
		}
		 */
		// Ώ۔N擾
		Date targetDate = util.getFirstDateOfMonth(vo.getPltSelectYear(), vo.getPltSelectMonth());
		// ̐ݒ
		List<MKihonDto> mKihonList = getApprovalEmployeeList(targetDate);
		// ΑӏF@\mF
		if (isAttendanceApprovalFunction()) {
			// VOݒ
			vo.setFields(mKihonList);
			// Ώۂꍇ̃bZ[Wݒ
			if (vo.getEscAryKCode().length == 0) {
				vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			}
		} else {
			// XgɂB
			mKihonList.clear();
			// VOݒ
			vo.setFields(mKihonList);
			// ΑӏF@\ꍇ̃bZ[Wݒ
			vo.addErrMessage(CommonConst.MSG_ATTENDANCE_APPROVAL_FUNCTION3);
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, EmployeeApprovalListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(EmployeeApprovalListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, EmployeeApprovalListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1321988381196408314L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -2913545521784316945L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}

	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 3158913862750258976L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

	/**
	 * EʂɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 3947836481650506034L;
		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}

}
