/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import jp.mosp.common.common.InstanceFactory;
import jp.mosp.common.common.MospException;

/**
 * PartNX̃CX^X𐶐NX
 * @author yoshida
 * 	@version	0.0.1
 */
public class PartFactory {

	/**
	 * p[g
	 * @param className		BasePartpΏPartClass
	 * @param partInfo		CX^X̏ɕKvȏDTO
	 * @return				ΏPartClass̃CX^X
	 * @throws MospException
	 */
	public static BasePart create(String className, PartInfo partInfo) throws MospException {
		BasePart part = null;
		Object obj = getInstance(className);
		if (obj instanceof BasePart) {
			part = (BasePart) obj;
			part.init(partInfo);
		}
		return part;
	}

	/**
	 * NXCX^X擾B<br>
	 * @param className NX
	 * @return NX̃CX^X
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws MosPException
	 */
	static Object getInstance(
			String className
	) throws MospException {
		return InstanceFactory.loadInstance(className);
	}

}
