/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.Date;

import jp.mosp.workflow.dao.CtOvertimeRequestDao;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

/**
 * cƐ\ɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class OverTimePart extends BasePart {

	/**
	 * RXgN^
	 */
	public OverTimePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public OverTimePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * cƐ\e[uDAO̎擾
	 * @return	ςCtOvertimeRequestDaoCX^X
	 * @throws Exception
	 */
	public CtOvertimeRequestDao getCtOvertimeRequestDao() throws Exception {
		return (CtOvertimeRequestDao) getPreparedDao(CtOvertimeRequestDao.class.getCanonicalName());
	}

	/**
	 * cƐ\擾
	 * @param voucher		Ώۓ`[ԍ
	 * @return	cƐ\DTO
	 * @throws Exception
	 */
	public CtOvertimeRequestDto getOverTimeRequest(int voucher) throws Exception {
		return getCtOvertimeRequestDao().findForKey(voucher);
	}

	/**
	 * Ώ۔NcƐ\擾
	 * @param kCode				ΏێЈR[h
	 * @param targetDate		Ώ۔N
	 * @return	cƐ\DTO
	 * @throws Exception
	 */
	public CtOvertimeRequestDto getTargetOverTimeRequest(
			String kCode,
			Date targetDate
	) throws Exception {
		return getCtOvertimeRequestDao().findForWorkDate(
				kCode,
				DatePart.convDateFormattedByHyphen(targetDate)
		);
	}

}
