/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAuthorityDto;

public class CmAuthorityDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "CM_AUTHORITY"	;
	public static final String KEY_1 	= "AUTHCODE"		;	//R[h

	// 
	public static final String COL_AUTH_CODE 		= "AUTHCODE"	;	//R[h
	public static final String COL_AUTH_NAME 		= "AUTHNAME"	;	//l[
	public static final String COL_EMPLOYEE  		= "EMPLOYEE"	;	//]ƈj[
	public static final String COL_MANAGER  		= "MANAGER"		;	//}l[W[j[
	public static final String COL_PAYROLL  		= "PAYROLL"		;	//^j[
	public static final String COL_HUMAN  			= "HUMAN"		;	//lj[
	public static final String COL_INSURANCE  		= "INSURANCE"	;	//Љیj[
	public static final String COL_BONUS  			= "BONUS"		;	//ܗ^j[
	public static final String COL_ADJUSTMENT 		= "ADJUSTMENT"	;	//Nj[
	public static final String COL_EXPENSE  		= "EXPENSE"		;	//oj[
	public static final String COL_SERVICE1  		= "SERVICE1"	;	
	public static final String COL_SERVICE2  		= "SERVICE2"	;	
	public static final String COL_SERVICE3  		= "SERVICE3"	;	
	public static final String COL_SERVICE4  		= "SERVICE4"	;	
	public static final String COL_SERVICE5  		= "SERVICE5"	;	
	public static final String COL_DELETE_FLAG		= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public CmAuthorityDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmAuthorityDto> mappingAll() throws SQLException {
		List<CmAuthorityDto> all = new ArrayList<CmAuthorityDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return cm_serviceDto cm_serviceR[h
	 * @throws SQLException
	 */
	private CmAuthorityDto mapping() throws SQLException {
		CmAuthorityDto dto = new CmAuthorityDto();
		dto.setAuthCode 	(rs.getString (COL_AUTH_CODE	));	//R[h
		dto.setAuthName 	(rs.getString (COL_AUTH_NAME	));	//l[
		dto.setEmployee 	(rs.getString (COL_EMPLOYEE		));	//]ƈj[
		dto.setManager 		(rs.getString (COL_MANAGER		));	//}l[W[j[
		dto.setPayroll 		(rs.getString (COL_PAYROLL		));	//^j[
		dto.setHuman 		(rs.getString (COL_HUMAN		));	//lj[
		dto.setInsurance 	(rs.getString (COL_INSURANCE	));	//Љیj[
		dto.setBonus 		(rs.getString (COL_BONUS		));	//ܗ^j[
		dto.setAdjustment 	(rs.getString (COL_ADJUSTMENT	));	//Nj[
		dto.setExpense 		(rs.getString (COL_EXPENSE		));	//oj[
		dto.setService1 	(rs.getString (COL_SERVICE1		));	
		dto.setService2 	(rs.getString (COL_SERVICE2		));
		dto.setService3 	(rs.getString (COL_SERVICE3		));	
		dto.setService4 	(rs.getString (COL_SERVICE4		));	
		dto.setService5 	(rs.getString (COL_SERVICE5		));	
		dto.setDeleteFlag 	(rs.getInt    (COL_DELETE_FLAG	));	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmAuthorityDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmAuthorityDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param authcode R[h(L[)
	 * @return CmAuthorityDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmAuthorityDto findForKey(
			String authcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, authcode);
			executeQuery();
			CmAuthorityDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param authcode R[h(L[)
	 * @return CmAuthorityDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmAuthorityDto findForUpdate(
			String authcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, authcode);
			executeQuery();
			CmAuthorityDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param authcode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String authcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_AUTH_CODE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   authcode  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * @return
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmAuthorityDto> findForAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF + " ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<CmAuthorityDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂ錟f[^擾
	 * @param authcode R[h
	 * @param authname 	
	 * @param employee 	]ƈj[
	 * @param manager 	}l[W[j[
	 * @param payroll 	^j[
	 * @param human 	lj[
	 * @param deleteflag 폜tO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForFunctionCondition(
			String authcode,
			String authname,
			String employee,
			String manager,
			String payroll,
			String human,
			String deleteflag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_AUTH_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_AUTH_NAME);
		sb.append(" LIKE ? AND ");
		sb.append(COL_EMPLOYEE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_MANAGER);
		sb.append(" LIKE ? AND ");
		sb.append(COL_PAYROLL);
		sb.append(" LIKE ? AND ");
		sb.append(COL_HUMAN);
		sb.append(" LIKE ? ");
		if (!deleteflag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   	authcode 	+ "%");
			setParam(index++, "%" + authname 	+ "%");
			setParam(index++, "%" + employee 	+ "%");
			setParam(index++, "%" + manager 	+ "%");
			setParam(index++, "%" + payroll 	+ "%");
			setParam(index++, "%" + human		+ "%");
			if (!deleteflag.equals("")) {
				setParam(index++, deleteflag);
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂ錟f[^擾
	 * @param authcode R[h
	 * @param authname 	
	 * @param employee 	]ƈj[
	 * @param manager 	}l[W[j[
	 * @param payroll 	^j[
	 * @param human 	lj[
	 * @param service1 	̑Pj[
	 * @param service2 	̑Qj[
	 * @param deleteflag 폜tO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForFunctionCondition(
			String authcode,
			String authname,
			String employee,
			String manager,
			String payroll,
			String human,
			String service1,
			String service2,
			String deleteflag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_AUTH_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_AUTH_NAME);
		sb.append(" LIKE ? AND ");
		sb.append(COL_EMPLOYEE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_MANAGER);
		sb.append(" LIKE ? AND ");
		sb.append(COL_PAYROLL);
		sb.append(" LIKE ? AND ");
		sb.append(COL_HUMAN);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SERVICE1);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SERVICE2);
		sb.append(" LIKE ? ");
		if (!deleteflag.equals("")) {
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   	authcode 	+ "%");
			setParam(index++, "%" + authname 	+ "%");
			setParam(index++, "%" + employee 	+ "%");
			setParam(index++, "%" + manager 	+ "%");
			setParam(index++, "%" + payroll 	+ "%");
			setParam(index++, "%" + human		+ "%");
			setParam(index++, "%" + service1	+ "%");
			setParam(index++, "%" + service2	+ "%");
			if (!deleteflag.equals("")) {
				setParam(index++, deleteflag);
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾iL̂݁j
	 * @param authcode R[h(L[)
	 * @return CmAuthorityDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmAuthorityDto findForAuth(
			String authcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_AUTH_CODE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, authcode);
			executeQuery();
			CmAuthorityDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmAuthorityDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto , true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}	

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmAuthorityDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto , false);
			setParam(index++, dto.getAuthCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(CmAuthorityDto dto , boolean isInsert) throws SQLException {
		setParam(index++, dto.getAuthCode	());	//T[rXR[h
		setParam(index++, dto.getAuthName	());	//T[rXl[
		setParam(index++, dto.getEmployee	());	//]ƈj[
		setParam(index++, dto.getManager	());	//}l[W[j[
		setParam(index++, dto.getPayroll	());	//^j[
		setParam(index++, dto.getHuman		());	//lj[
		setParam(index++, dto.getInsurance	());	//Љیj[
		setParam(index++, dto.getBonus		());	//ܗ^j[
		setParam(index++, dto.getAdjustment	());	//Nj[
		setParam(index++, dto.getExpense	());	//oj[
		setParam(index++, dto.getService1	());	
		setParam(index++, dto.getService2	());	
		setParam(index++, dto.getService3	());	
		setParam(index++, dto.getService4	());	
		setParam(index++, dto.getService5	());	
		setParam(index++, dto.getDeleteFlag	());	//폜tO
		setCommonParams(isInsert);
	}
}
