<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.base.PayrollConst"
import = "jp.mosp.payroll.common.vo.AdjustmentListVo"
%><%
AdjustmentListVo vo = (AdjustmentListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryKCode           = vo.getEscAryKCode          ();
String[] aryAdjustYear      = vo.getEscAryAdjustYear     ();
String[] aryAdjustStatus    = vo.getEscAryAdjustStatus   ();
String[] aryTaxGap          = vo.getEscAryTaxGap         ();
String[] aryFinalIncomeTax  = vo.getEscAryFinalIncomeTax ();
String[] aryIncomeDeductSum = vo.getEscAryIncomeDeductSum();
String[] aryIncomeTaxSum    = vo.getEscAryIncomeTaxSum   ();
String[] aryTaxedPaymentSum = vo.getEscAryTaxedPaymentSum();
%><%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_PAYROLL) %>
<div class="Body" id="adjustmentList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Report">
		<table id="tblToAdjustCalc">
			<tr>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'P3001')"><%= PayrollConst.NAM_TO_ADJUSTMENT_CALC %></button>
				</td>
			</tr>
		</table>
		<table id="tblReport">
			<tr>
				<td>
					<%= PayrollConst.NAM_OUTPUT_LUMP_DATA + PayrollConst.STR_TITLE_SEPARATOR %>
				</td>
				<td class="YearTd">
					<select id="<%= AdjustmentListVo.PRM_PLT_REPORT_YEAR %>" name="<%= AdjustmentListVo.PRM_PLT_REPORT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltAdjustYear, vo.getStrReportYear()) %>
					</select><%= PayrollConst.NAM_YEAR %>
				</td>
				<%--
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3030')"><%= PayrollConst.NAM_WITHHOLD_SLIP %></button>
				</td>
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3040')"><%= PayrollConst.NAM_WITHHOLD_BOOK %></button>
				</td>
				 --%>
				<td>
					<button type="button" onclick="submitFile(document.form, 'P3050')"><%= PayrollConst.NAM_OUTPUT_ADJUSTMENT %></button>
				</td>
				<td>
					<%--
					<button type="button" onclick=""><%= PayrollConst.NAM_PAYMENT_LEDGER %></button>
					<button type="button" onclick="submitFile(document.form, 'U3340')"><%= PayrollConst.NAM_PAYMENT_LEDGER %></button>
					--%>
				</td>
			</tr>
		</table>
	</div>
	<hr>
	<div class="Search">
		<table>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= PayrollConst.NAM_M_KIHON_KCODE %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= AdjustmentListVo.PRM_TXT_K_CODE %>" name="<%= AdjustmentListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= PayrollConst.NAM_M_KIHON_SHIME %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= AdjustmentListVo.PRM_TXT_K_NAME %>" name="<%= AdjustmentListVo.PRM_TXT_K_NAME %>" value="<%= vo.getEscTxtKName() %>" />
				</td>
				<td id="tdStation">
					<span class="TitleLabel"><%= PayrollConst.NAM_ADJUST_STATUS %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= AdjustmentListVo.PRM_PLT_ADJUST_STATUS %>" name="<%= AdjustmentListVo.PRM_PLT_ADJUST_STATUS %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAdjustSatus, vo.getPltAdjustStatus()) %>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P3012')"><%= PayrollConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td>
					<span class="TitleLabel">&nbsp;&nbsp;&nbsp;&nbsp;<%= PayrollConst.NAM_ADJUST_YEAR %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<select id="<%= AdjustmentListVo.PRM_PLT_ADJUST_YEAR %>" name="<%= AdjustmentListVo.PRM_PLT_ADJUST_YEAR %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAdjustYear, vo.getStrAdjustYear()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel">&nbsp;<%= PayrollConst.NAM_K_KANA %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= AdjustmentListVo.PRM_TXT_K_KANA %>" name="<%= AdjustmentListVo.PRM_TXT_K_KANA %>" value="<%= vo.getEscTxtKKana() %>" />
				</td>
				<td>
					<span class="TitleLabel">&nbsp;&nbsp;&nbsp;&nbsp;<%= PayrollConst.NAM_FINAL_INCOME_TAX %><%= PayrollConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="NumberTextBox" id="<%= AdjustmentListVo.PRM_TXT_INC_TAX_FROM %>" name="<%= AdjustmentListVo.PRM_TXT_INC_TAX_FROM %>" value="<%= vo.getEscTxtIncTaxFrom() %>" />
					<%= PayrollConst.STR_TERM %>
					<input type="text" class="NumberTextBox" id="<%= AdjustmentListVo.PRM_TXT_INC_TAX_TO   %>" name="<%= AdjustmentListVo.PRM_TXT_INC_TAX_TO   %>" value="<%= vo.getEscTxtIncTaxTo  () %>" />
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th class="ButtonTh"      ></th>
					<th id="thKCode"           onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_K_CODE            %>', '')">&nbsp;<%= PayrollConst.NAM_M_KIHON_KCODE     %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE           ) %></th>
					<th id="thYear"            onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_ADJUST_YEAR       %>', '')">&nbsp;<%= PayrollConst.NAM_ADJUST_YEAR       %>&nbsp;<%= vo.getSortMark(vo.KEY_ADJUST_YEAR      ) %></th>
					<th id="thStatus"          onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_ADJUST_STATUS     %>', '')">&nbsp;<%= PayrollConst.NAM_ADJUST_STATUS     %>&nbsp;<%= vo.getSortMark(vo.KEY_ADJUST_STATUS    ) %></th>
					<th id="thTaxedPaymentSum" onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_TAXED_PAYMENT_SUM %>', '')">&nbsp;<%= PayrollConst.NAM_TAXED_PAYMENT_SUM %>&nbsp;<%= vo.getSortMark(vo.KEY_TAXED_PAYMENT_SUM) %></th>
					<th id="thIncomeTaxSum"    onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_INCOME_TAX_SUM    %>', '')">&nbsp;<%= PayrollConst.NAM_INCOME_TAX_SUM    %>&nbsp;<%= vo.getSortMark(vo.KEY_INCOME_TAX_SUM   ) %></th>
					<th id="thIncomeDeductSum" onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_INCOME_DEDUCT_SUM %>', '')">&nbsp;<%= PayrollConst.NAM_INCOME_DEDUCT_SUM %>&nbsp;<%= vo.getSortMark(vo.KEY_INCOME_DEDUCT_SUM) %></th>
					<th id="thFinalIncomeTax"  onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_FINAL_INCOME_TAX  %>', '')">&nbsp;<%= PayrollConst.NAM_FINAL_INCOME_TAX  %>&nbsp;<%= vo.getSortMark(vo.KEY_FINAL_INCOME_TAX ) %></th>
					<th id="thTaxGap"          onclick="doSubmitKey(document.form, 'P3014', '<%= vo.KEY_TAX_GAP           %>', '')">&nbsp;<%= PayrollConst.NAM_TAX_GAP           %>&nbsp;<%= vo.getSortMark(vo.KEY_TAX_GAP          ) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P3060', '<%= aryKCode[i] %>', '<%= aryAdjustYear[i] %>')"><%= PayrollConst.NAM_REFER %></button>
					</td>
					<td                 ><%= aryKCode          [i] %></td>
					<td class="CenterTd"><%= aryAdjustYear     [i] %></td>
					<td                 ><%= aryAdjustStatus   [i] %></td>
					<td class="RightTd" ><%= aryTaxedPaymentSum[i] %></td>
					<td class="RightTd" ><%= aryIncomeTaxSum   [i] %></td>
					<td class="RightTd" ><%= aryIncomeDeductSum[i] %></td>
					<td class="RightTd" ><%= aryFinalIncomeTax [i] %></td>
					<td class="RightTd" ><%= aryTaxGap         [i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
