<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.payroll.vo.AttendanceCompileCardVo"
%><%
AttendanceCompileCardVo vo = (AttendanceCompileCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.CMD_MENU_PAYROLL, vo.CMD_ATT_CALCULATE_MENU ,vo.ATT_CALCULATE_MENU_TITLE) %>
<div class="Body" id="CompileCard">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Card">
		<table >
			<tbody>
				<tr>
					<td class="CommentTd" colspan="2">
						<p><%= CommonConst.MSG_ATTENDANCE_CALCULATE_INFO1 %></p>
						<p><%= CommonConst.MSG_ATTENDANCE_CALCULATE_INFO2 %></p>
						<p><%= CommonConst.MSG_ATTENDANCE_CALCULATE_INFO3 %></p>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%= AttendanceCompileCardVo.NAM_CALCULATE_TARGET %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<%= vo.getEscLblStartCompileDate() %>
						<%= CommonConst.STR_TERM %>
						<%= vo.getEscLblEndCompileDate() %>
						<input type="hidden" id="<%= AttendanceCompileCardVo.PRM_HID_YEAR %>" name="<%= AttendanceCompileCardVo.PRM_HID_YEAR %>" value="<%=vo.getHidCompileYear() %>" />
						<input type="hidden" id="<%= AttendanceCompileCardVo.PRM_HID_MONTH %>" name="<%= AttendanceCompileCardVo.PRM_HID_MONTH %>" value="<%=vo.getHidCompileMonth() %>" />					
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceCompileCardVo.NAM_SECTION %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<select class="StationSelect" id="<%= AttendanceCompileCardVo.PRM_PLT_SECTION %>" name="<%= AttendanceCompileCardVo.PRM_PLT_SECTION %>">
							<%= HtmlUtility.getSelectOption(vo.aryPltSection, vo.getPltSection()) %>
						</select>
					</td>
				</tr>
				<tr>
					<td class="TitleTd">
						<%=AttendanceCompileCardVo.NAM_K_CODE %><%=CommonConst.STR_TITLE_SEPARATOR%>
					</td>
					<td class="InputTd">
						<input type="text" class="UserIdText" id="<%= AttendanceCompileCardVo.PRM_TXT_KCODE %>" name="<%= AttendanceCompileCardVo.PRM_TXT_KCODE %>" value="<%= vo.getEscTxtKCode() %>" />
						<%= CommonConst.MSG_ATTENDANCE_CALCULATE_ALONE %>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" id="btnStart" class="ExecuteButton" onclick="submitForm(document.form)"><%= CommonConst.NAM_CALCULATE_START %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
