/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jdom.Element;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.util.ImageInfo;
import org.jopendocument.util.ImageUtils;

abstract class BytesProducer {
    BytesProducer() {
    }

    abstract byte[] getBytes(Element var1);

    abstract String getFormat();

    static final class ImageProducer
    extends BytesProducer {
        private final Image img;
        private final boolean keepRatio;

        public ImageProducer(Image image, boolean bl) {
            this.img = image;
            this.keepRatio = bl;
        }

        public byte[] getBytes(Element element) {
            BufferedImage bufferedImage;
            if (this.keepRatio) {
                float f = new ODFrame(element).getRatio();
                bufferedImage = ImageUtils.createQualityResizedImage(this.img, f, true, Color.WHITE, true);
            } else {
                bufferedImage = ImageUtils.createQualityResizedImage(this.img, this.img.getWidth(null), this.img.getHeight(null), true, true, Color.WHITE, true);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x100000);
            try {
                ImageIO.write((RenderedImage)bufferedImage, this.getFormat(), byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to export " + bufferedImage + " to " + this.getFormat());
            }
            return byteArrayOutputStream.toByteArray();
        }

        public String getFormat() {
            return "png";
        }
    }

    static final class ByteArrayProducer
    extends BytesProducer {
        private final byte[] data;
        private final boolean keepRatio;

        public ByteArrayProducer(byte[] byArray) {
            this(byArray, false);
        }

        public ByteArrayProducer(byte[] byArray, boolean bl) {
            this.data = byArray;
            this.keepRatio = bl;
        }

        public byte[] getBytes(Element element) {
            if (this.keepRatio) {
                ODFrame oDFrame;
                float f;
                ImageInfo imageInfo = new ImageInfo();
                imageInfo.setInput(new ByteArrayInputStream(this.data));
                if (!imageInfo.check()) {
                    throw new IllegalStateException("unable to parse the picture");
                }
                float f2 = (float)imageInfo.getWidth() / (float)imageInfo.getHeight();
                if (f2 > (f = (oDFrame = new ODFrame(element)).getRatio())) {
                    float f3 = oDFrame.getWidth() / f2;
                    float f4 = oDFrame.getHeight() - f3;
                    oDFrame.setSVGAttr("y", (double)oDFrame.getY() + (double)f4 / 2.0);
                    oDFrame.setSVGAttr("height", f3);
                } else {
                    float f5 = oDFrame.getHeight() * f2;
                    float f6 = oDFrame.getWidth() - f5;
                    oDFrame.setSVGAttr("x", (double)oDFrame.getX() + (double)f6 / 2.0);
                    oDFrame.setSVGAttr("width", f5);
                }
                element.removeAttribute("end-cell-address", element.getNamespace("table"));
                element.removeAttribute("end-x", element.getNamespace("table"));
                element.removeAttribute("end-y", element.getNamespace("table"));
            }
            return this.data;
        }

        public String getFormat() {
            return null;
        }
    }
}

