/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.apache.commons.collections.map.LazyMap;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.Log;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.CacheTimeOut;
import org.jopendocument.util.cache.CacheWatcher;
import org.jopendocument.util.cache.CacheWatcherFactory;
import org.jopendocument.util.cc.ITransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICache<K, V, D> {
    private static final Level LEVEL = Level.FINEST;
    private final LinkedHashMap<K, V> cache;
    private final Set<K> running = new HashSet<K>();
    private final int delay;
    private final int size;
    private Timer timer;
    private final String name;
    private final Map<K, CacheTimeOut<K>> timeoutTasks;
    private Map<D, CacheWatcher<K, D>> watchers;
    private final CollectionMap<K, CacheWatcher<K, D>> watchersByKey;

    public ICache() {
        this(60);
    }

    public ICache(int n) {
        this(n, -1);
    }

    public ICache(int n, int n2) {
        this(n, n2, null);
    }

    public ICache(int n, int n2, String string) {
        this.delay = n;
        if (n2 == 0) {
            throw new IllegalArgumentException("0 size");
        }
        this.size = n2;
        this.cache = new LinkedHashMap(n2 < 0 ? 64 : n2);
        this.timer = null;
        this.name = string;
        this.timeoutTasks = new HashMap<K, CacheTimeOut<K>>();
        this.watchers = null;
        this.watchersByKey = new CollectionMap(HashSet.class);
    }

    private final Timer getTimer() {
        if (this.timer == null) {
            this.timer = this.name == null ? new Timer(true) : new Timer("cache for " + this.name, true);
        }
        return this.timer;
    }

    public final void setWatcherFactory(final CacheWatcherFactory<K, D> cacheWatcherFactory) {
        this.watchers = LazyMap.decorate(new HashMap(), new ITransformer<D, CacheWatcher<K, D>>(){

            @Override
            public CacheWatcher<K, D> transformChecked(D d) {
                try {
                    return cacheWatcherFactory.createWatcher(ICache.this, d);
                }
                catch (Exception exception) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "could not create watcher for " + d, exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CacheResult<V> get(K k) {
        ICache iCache = this;
        synchronized (iCache) {
            if (this.cache.containsKey(k)) {
                this.log("IN cache", k);
                return new CacheResult<V>(this.cache.get(k));
            }
            if (this.isRunning(k)) {
                this.log("RUNNING", k);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return CacheResult.getInterrupted();
                }
                return this.get(k);
            }
            this.log("NOT in cache", k);
            return CacheResult.getNotInCache();
        }
    }

    public final synchronized void addRunning(K k) {
        this.running.add(k);
    }

    public final synchronized void removeRunning(K k) {
        this.running.remove(k);
        this.notifyAll();
    }

    public final synchronized boolean isRunning(K k) {
        return this.running.contains(k);
    }

    public final synchronized CacheResult<V> check(K k) {
        CacheResult<V> cacheResult = this.get(k);
        if (cacheResult.getState() == CacheResult.State.NOT_IN_CACHE) {
            this.addRunning(k);
        }
        return cacheResult;
    }

    public final synchronized void put(K k, V v) {
        this.put(k, v, Collections.emptySet());
    }

    public final synchronized Set<? extends CacheWatcher<K, D>> put(K k, V v, Set<? extends D> set) {
        if (this.size > 0 && this.cache.size() == this.size) {
            this.clear(this.cache.keySet().iterator().next());
        }
        this.cache.put(k, v);
        this.removeRunning(k);
        for (D d : set) {
            if (this.watchers == null) continue;
            CacheWatcher<K, D> cacheWatcher = this.watchers.get(d);
            cacheWatcher.add(k);
            this.watchersByKey.put((Object)k, (Object)cacheWatcher);
        }
        CacheTimeOut<K> cacheTimeOut = new CacheTimeOut<K>(this, k);
        this.timeoutTasks.put(k, cacheTimeOut);
        this.getTimer().schedule((TimerTask)cacheTimeOut, this.delay * 1000);
        return (Set)this.watchersByKey.getNonNull(k);
    }

    public final synchronized void clear(K k) {
        this.log("clear", k);
        if (this.cache.containsKey(k)) {
            this.cache.remove(k);
            this.timeoutTasks.remove(k).cancel();
            Set set = (Set)this.watchersByKey.getNonNull(k);
            this.watchersByKey.remove(k);
            if (set != null) {
                for (CacheWatcher cacheWatcher : set) {
                    cacheWatcher.remove(k);
                    if (!cacheWatcher.isEmpty()) continue;
                    cacheWatcher.die();
                    this.watchers.remove(cacheWatcher.getData());
                }
            }
        }
    }

    final synchronized boolean dependsOn(D d) {
        return this.watchers.containsKey(d);
    }

    private final void log(String string, Object object) {
        if (Log.get().isLoggable(LEVEL)) {
            Log.get().log(LEVEL, string + ": " + object);
        }
    }

    public final synchronized int size() {
        return this.cache.size();
    }

    public final String toString() {
        return this.getClass().getName() + ", keys cached: " + this.timeoutTasks.keySet();
    }
}

