/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.style;

import java.awt.Color;
import java.awt.Font;
import org.jopendocument.util.ValueHelper;

public class StyleTextProperties {
    private Color color;
    private String fontName;
    private String fontSize;
    private String fontWeight;
    Font lastFont;
    double lastResizeFactor;

    public Color getColor() {
        return this.color;
    }

    public Font getFont(double d) {
        Font font;
        if (this.lastResizeFactor == d) {
            return this.lastFont;
        }
        String string = this.fontName;
        int n = 0;
        if (this.fontWeight != null && this.fontWeight.equals("bold")) {
            n = 1;
        }
        if (this.fontSize == null) {
            this.fontSize = "10pt";
            System.err.println("Assert default font size: 10");
        }
        String string2 = this.fontSize.substring(0, this.fontSize.length() - 2);
        int n2 = Integer.valueOf(string2);
        if (string.equalsIgnoreCase("Times")) {
            string = "Times New Roman";
        }
        if (string == null) {
            throw new IllegalStateException("font name null!!");
        }
        this.lastFont = font = new Font(string, n, (int)((double)(n2 * 360) / d));
        this.lastResizeFactor = d;
        return font;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String string) {
        if (string != null) {
            this.color = ValueHelper.getColor(string);
        }
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontSize(String string) {
        this.fontSize = string;
    }

    public void setFontWeight(String string) {
        this.fontWeight = string;
    }

    public String toString() {
        return "StyleTextProperty:" + this.fontName + " " + this.fontSize + " " + this.fontWeight;
    }
}

