/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import jp.mosp.common.common.MospException;

public class InstanceFactory {
    public static Object loadInstance(String className) throws MospException {
        Object obj = null;
        try {
            if (className == null) {
                throw new NullPointerException();
            }
            obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException(5010, "\u30af\u30e9\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        catch (ClassNotFoundException e) {
            throw new MospException(5011, className + "\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        catch (InstantiationException e) {
            throw new MospException(5012, className + "\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        catch (IllegalAccessException e) {
            throw new MospException(5013, className + "\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        return obj;
    }

    public static Object simplifiedInstance(String className) throws MospException {
        Object obj = null;
        try {
            if (className == null) {
                throw new NullPointerException();
            }
            obj = Class.forName(className).newInstance();
        }
        catch (NullPointerException e) {
            throw new MospException(5010, "\u30af\u30e9\u30b9\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        catch (ClassNotFoundException e) {
            throw new MospException(5011, className + "\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        catch (InstantiationException e) {
            throw new MospException(5012, className + "\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        catch (IllegalAccessException e) {
            throw new MospException(5013, className + "\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        return obj;
    }
}

