/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.jopendocument.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMap<K, V>
extends MultiHashMap {
    private final Class<? extends Collection<V>> collectionClass;
    private final Collection<V> collectionSpecimen;

    public CollectionMap() {
        this(ArrayList.class);
    }

    public CollectionMap(Class clazz) {
        this.collectionClass = clazz;
        this.collectionSpecimen = null;
    }

    public CollectionMap(Collection<V> collection) {
        this.collectionClass = null;
        this.collectionSpecimen = collection;
        if (!(collection instanceof Cloneable)) {
            throw new IllegalArgumentException(collection + " not a cloneable.");
        }
        this.collectionSpecimen.clear();
    }

    public Collection<V> getNonNull(K k) {
        Collection<V> collection = (Collection<V>)super.get(k);
        return collection == null ? this.createCollection(collection) : collection;
    }

    @Override
    protected Collection<V> createCollection(Collection collection) {
        if (this.collectionClass != null) {
            try {
                if (collection == null) {
                    return this.collectionClass.newInstance();
                }
                return this.collectionClass.getConstructor(Collection.class).newInstance(collection);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.collectionSpecimen != null) {
            Method method;
            try {
                method = this.collectionSpecimen.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Cloneable w/o clone()", noSuchMethodException);
            }
            try {
                Collection collection2 = (Collection)method.invoke(this.collectionSpecimen, new Object[0]);
                if (collection != null) {
                    collection2.addAll(collection);
                }
                return collection2;
            }
            catch (Exception exception) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", exception);
            }
        }
        return super.createCollection(collection);
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void merge(MultiMap multiMap) {
        for (Map.Entry entry : multiMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Collection<V> collection2 = this.createCollection(collection);
            this.putAll(entry.getKey(), collection2);
        }
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            this.merge((MultiMap)map);
        } else {
            super.putAll(map);
        }
    }

    public boolean putAll(K k, V ... VArray) {
        return this.putAll((Object)k, Arrays.asList(VArray));
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

