/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import java.util.List;
import java.util.Vector;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.office.OfficeAnnotation;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableCellRangeSource;
import org.jopendocument.model.table.TableDetective;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTableCell {
    private StyleStyle cellStyle;
    private TableTableColumn column;
    private boolean covered;
    private List<DrawFrame> drawFrames;
    private DrawImage drawImage;
    protected OfficeAnnotation officeAnnotation;
    protected TableTableRow row;
    protected String tableBooleanValue;
    protected TableCellRangeSource tableCellRangeSource;
    protected String tableCurrency;
    protected String tableDateValue;
    protected TableDetective tableDetective;
    protected String tableFormula;
    protected int tableNumberColumnsRepeated = 1;
    protected int tableNumberColumnsSpanned = 1;
    protected String tableNumberMatrixColumnsSpanned;
    protected String tableNumberMatrixRowsSpanned;
    protected int tableNumberRowsSpanned = 1;
    protected String tableProtected;
    protected String tableStringValue;
    protected String tableStyleName;
    protected String tableTimeValue;
    protected String tableValidationName;
    protected String tableValue;
    protected String tableValueType;
    private TextP textP;

    public void addDrawFrame(DrawFrame drawFrame) {
        if (this.drawFrames == null) {
            this.drawFrames = new Vector<DrawFrame>();
        }
        this.drawFrames.add(drawFrame);
    }

    protected TableTableCell cloneCell() {
        TableTableCell tableTableCell = new TableTableCell();
        tableTableCell.tableNumberColumnsRepeated = this.tableNumberColumnsRepeated;
        tableTableCell.tableNumberRowsSpanned = this.tableNumberRowsSpanned;
        tableTableCell.tableNumberColumnsSpanned = this.tableNumberColumnsSpanned;
        tableTableCell.tableStyleName = this.tableStyleName;
        tableTableCell.tableValidationName = this.tableValidationName;
        tableTableCell.tableFormula = this.tableFormula;
        tableTableCell.tableNumberMatrixRowsSpanned = this.tableNumberMatrixRowsSpanned;
        tableTableCell.tableNumberMatrixColumnsSpanned = this.tableNumberMatrixColumnsSpanned;
        tableTableCell.tableValueType = this.tableValueType;
        tableTableCell.tableValue = this.tableValue;
        tableTableCell.tableDateValue = this.tableDateValue;
        tableTableCell.tableTimeValue = this.tableTimeValue;
        tableTableCell.tableBooleanValue = this.tableBooleanValue;
        tableTableCell.tableStringValue = this.tableStringValue;
        tableTableCell.tableCurrency = this.tableCurrency;
        tableTableCell.tableProtected = this.tableProtected;
        tableTableCell.tableCellRangeSource = this.tableCellRangeSource;
        tableTableCell.tableDetective = this.tableDetective;
        tableTableCell.officeAnnotation = this.officeAnnotation;
        tableTableCell.textP = this.textP;
        tableTableCell.covered = this.covered;
        tableTableCell.drawImage = this.drawImage;
        tableTableCell.drawFrames = this.drawFrames;
        return tableTableCell;
    }

    private void computeStyle() {
        if (this.column == null) {
            return;
        }
        String string = this.getStyleName();
        if (string == null) {
            string = this.column.getTableDefaultCellStyleName();
        }
        this.cellStyle = this.row.getTable().getCellStyle(string);
        if (this.cellStyle == null) {
            System.err.println(string + " not found");
            Thread.dumpStack();
        }
    }

    public List<DrawFrame> getDrawFrames() {
        return this.drawFrames;
    }

    public OfficeAnnotation getOfficeAnnotation() {
        return this.officeAnnotation;
    }

    public TableTableRow getRow() {
        return this.row;
    }

    public StyleStyle getStyle() {
        return this.cellStyle;
    }

    public String getStyleName() {
        return this.tableStyleName;
    }

    public String getTableBooleanValue() {
        return this.tableBooleanValue;
    }

    public TableCellRangeSource getTableCellRangeSource() {
        return this.tableCellRangeSource;
    }

    public String getTableCurrency() {
        return this.tableCurrency;
    }

    public String getTableDateValue() {
        return this.tableDateValue;
    }

    public TableDetective getTableDetective() {
        return this.tableDetective;
    }

    public String getTableFormula() {
        return this.tableFormula;
    }

    public int getTableNumberColumnsRepeated() {
        return this.tableNumberColumnsRepeated;
    }

    public int getTableNumberColumnsSpanned() {
        return this.tableNumberColumnsSpanned;
    }

    public String getTableNumberMatrixColumnsSpanned() {
        return this.tableNumberMatrixColumnsSpanned;
    }

    public String getTableNumberMatrixRowsSpanned() {
        return this.tableNumberMatrixRowsSpanned;
    }

    public int getTableNumberRowsSpanned() {
        return this.tableNumberRowsSpanned;
    }

    public String getTableProtected() {
        if (this.tableProtected == null) {
            return "false";
        }
        return this.tableProtected;
    }

    public String getTableStringValue() {
        return this.tableStringValue;
    }

    public String getTableTimeValue() {
        return this.tableTimeValue;
    }

    public String getTableValidationName() {
        return this.tableValidationName;
    }

    public String getTableValue() {
        return this.tableValue;
    }

    public String getTableValueType() {
        if (this.tableValueType == null) {
            return "string";
        }
        return this.tableValueType;
    }

    public TextP getTextP() {
        return this.textP;
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean bl) {
        this.covered = bl;
    }

    public void setOfficeAnnotation(OfficeAnnotation officeAnnotation) {
        this.officeAnnotation = officeAnnotation;
    }

    public void setRowAndColumn(TableTableRow tableTableRow, TableTableColumn tableTableColumn) {
        this.row = tableTableRow;
        this.column = tableTableColumn;
        this.computeStyle();
    }

    public void setTableBooleanValue(String string) {
        this.tableBooleanValue = string;
    }

    public void setTableCellRangeSource(TableCellRangeSource tableCellRangeSource) {
        this.tableCellRangeSource = tableCellRangeSource;
    }

    public void setTableCurrency(String string) {
        this.tableCurrency = string;
    }

    public void setTableDateValue(String string) {
        this.tableDateValue = string;
    }

    public void setTableDetective(TableDetective tableDetective) {
        this.tableDetective = tableDetective;
    }

    public void setTableFormula(String string) {
        this.tableFormula = string;
    }

    public void setTableNumberColumnsRepeated(String string) {
        if (string != null) {
            this.tableNumberColumnsRepeated = Integer.valueOf(string);
        }
    }

    public void setTableNumberColumnsSpanned(String string) {
        if (string != null) {
            this.tableNumberColumnsSpanned = Integer.valueOf(string);
        }
    }

    public void setTableNumberMatrixColumnsSpanned(String string) {
        this.tableNumberMatrixColumnsSpanned = string;
    }

    public void setTableNumberMatrixRowsSpanned(String string) {
        this.tableNumberMatrixRowsSpanned = string;
    }

    public void setTableNumberRowsSpanned(String string) {
        if (string != null) {
            this.tableNumberRowsSpanned = Integer.valueOf(string);
        }
    }

    public void setTableProtected(String string) {
        this.tableProtected = string;
    }

    public void setTableStringValue(String string) {
        this.tableStringValue = string;
    }

    public void setTableStyleName(String string) {
        this.tableStyleName = string;
        this.computeStyle();
    }

    public void setTableTimeValue(String string) {
        this.tableTimeValue = string;
    }

    public void setTableValidationName(String string) {
        this.tableValidationName = string;
    }

    public void setTableValue(String string) {
        this.tableValue = string;
    }

    public void setTableValueType(String string) {
        this.tableValueType = string;
    }

    public void setTextP(TextP textP) {
        if (this.textP != null) {
            System.err.println("TableTableCell: Warning: no support for multiple TextP in a Cell");
        } else {
            this.textP = textP;
        }
    }

    public String toString() {
        return "Cell: style:" + this.getStyleName() + " TestP:" + this.getTextP();
    }
}

