/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.table.TableModel;
import org.apache.commons.collections.map.LinkedMap;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.spreadsheet.Sheet;

public class SpreadSheet
implements ODDocument {
    private final ODPackage originalFile;
    private final LinkedMap sheets;

    public static SpreadSheet createFromFile(File file) throws IOException {
        return SpreadSheet.create(new ODPackage(file));
    }

    public static SpreadSheet create(ODPackage oDPackage) {
        return new SpreadSheet(oDPackage.getDocument("content.xml"), oDPackage.getDocument("styles.xml"), oDPackage);
    }

    public static SpreadSheet createEmpty(TableModel tableModel) throws IOException {
        return SpreadSheet.createEmpty(tableModel, NS.getOD());
    }

    public static SpreadSheet createEmpty(TableModel tableModel, NS nS) throws IOException {
        Element element;
        ContentTypeVersioned contentTypeVersioned;
        Document document = new Document(new Element("document", nS.getOFFICE()));
        if (nS.getVersion().equals("OpenOffice.org")) {
            document.setDocType(new DocType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd"));
        }
        if ((contentTypeVersioned = ContentTypeVersioned.fromType(ContentType.SPREADSHEET, nS.getVersion())).getVersion().equals("OpenOffice.org")) {
            document.getRootElement().setAttribute("class", contentTypeVersioned.getShortName(), nS.getOFFICE());
        }
        document.getRootElement().addContent(new Element("automatic-styles", nS.getOFFICE()));
        Element element2 = new Element("body", nS.getOFFICE());
        if (contentTypeVersioned.getVersion().equals("OpenDocument")) {
            element = new Element(contentTypeVersioned.getShortName(), nS.getOFFICE());
            element2.addContent(element);
        } else {
            element = element2;
        }
        document.getRootElement().addContent(element2);
        Element element3 = Sheet.createEmpty(nS);
        element.addContent(element3);
        SpreadSheet spreadSheet = new SpreadSheet(document, null);
        spreadSheet.getSheet(0).merge(tableModel, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel tableModel, File file, NS nS) throws IOException {
        return SpreadSheet.createEmpty(tableModel, nS).saveAs(file);
    }

    public SpreadSheet(Document document, Document document2) {
        this(document, document2, null);
    }

    private SpreadSheet(Document document, Document document2, ODPackage oDPackage) {
        this.originalFile = oDPackage != null ? oDPackage : new ODPackage();
        this.originalFile.putFile("content.xml", document);
        if (document2 != null) {
            this.originalFile.putFile("styles.xml", document2);
        }
        this.sheets = new LinkedMap();
        for (Element element : this.getBody().getChildren("table", this.getNS().getTABLE())) {
            this.sheets.put(element.getAttributeValue("name", this.getNS().getTABLE()), element);
        }
    }

    final Document getContent() {
        return this.getPackage().getContent().getDocument();
    }

    private final String getVersion() {
        return this.getPackage().getVersion();
    }

    private Element getBody() {
        Element element = this.getContent().getRootElement().getChild("body", this.getNS().getOFFICE());
        if (this.getVersion().equals("OpenOffice.org")) {
            return element;
        }
        return element.getChild("spreadsheet", this.getNS().getOFFICE());
    }

    protected final String[] resolve(String string) {
        Attribute attribute;
        Object object;
        try {
            object = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + string + "']/@table:base-cell-address");
            attribute = (Attribute)((XPath)object).selectSingleNode(this.getBody());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException();
        }
        if (attribute != null) {
            object = attribute.getValue().replaceAll("\\$", "");
            int n = ((String)object).indexOf(46);
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            return new String[]{string2, string3};
        }
        return null;
    }

    public Object getValueAt(String string) {
        if (Sheet.isCellRef(string)) {
            throw new IllegalArgumentException(string + " is a cell range, you must use it on a sheet");
        }
        String[] stringArray = this.resolve(string);
        return this.getSheet(stringArray[0]).getValueAt(stringArray[1]);
    }

    public final NS getNS() {
        return NS.get(this.getVersion());
    }

    public XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public Sheet getSheet(int n) {
        return this.getSheet((String)this.sheets.get(n));
    }

    public Sheet getSheet(String string) {
        Object object = this.sheets.get(string);
        if (object instanceof Element) {
            object = new Sheet(this, (Element)object);
            this.sheets.put(string, object);
        }
        return (Sheet)object;
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }

    public final ODPackage getPackage() {
        return this.originalFile;
    }
}

