/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmUserDao
extends BaseDao {
    public static final String TABLE = "CM_USER";
    public static final String KEY_01 = "USER_ID";
    public static final String COL_USER_ID = "USER_ID";
    public static final String COL_PASSWORD = "PASSWORD";
    public static final String COL_K_CODE = "K_CODE";
    public static final String COL_USER_NAME = "USER_NAME";
    public static final String COL_AUTHORITY = "AUTHORITY";
    public static final String COL_DATA_LEVEL = "DATA_LEVEL";
    public static final String COL_CHANGE_PASS = "CHANGE_PASS";
    public static final String COL_DELETE_FLAG = "DELETE_FLAG";

    public CmUserDao() {
        this.INSERT_DATE = "INSERT_DATE";
        this.INSERT_USER = "INSERT_USER";
        this.UPDATE_DATE = "UPDATE_DATE";
        this.UPDATE_USER = "UPDATE_USER";
    }

    public CmUserDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
        this();
        this.initDao(cfg, cmd, aspUser, user, conn);
    }

    private List<CmUserDto> mappingAll() throws SQLException {
        ArrayList<CmUserDto> all = new ArrayList<CmUserDto>();
        while (this.rs.next()) {
            all.add(this.mapping());
        }
        return all;
    }

    private CmUserDto mapping() throws SQLException {
        CmUserDto dto = new CmUserDto();
        dto.setUserId(this.rs.getString("USER_ID"));
        dto.setPassword(this.rs.getString(COL_PASSWORD));
        dto.setKCode(this.rs.getString(COL_K_CODE));
        dto.setUserName(this.rs.getString(COL_USER_NAME));
        dto.setAuthority(this.rs.getString(COL_AUTHORITY));
        dto.setDataLevel(this.rs.getInt(COL_DATA_LEVEL));
        dto.setChangePass(this.rs.getDate(COL_CHANGE_PASS));
        dto.setDeleteFlag(this.rs.getInt(COL_DELETE_FLAG));
        this.mappingCommonInfo(dto);
        return dto;
    }

    public List<CmUserDto> findAllCmUser() throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getOrderForKey(this.getClass()));
            this.executeQuery();
            List<CmUserDto> list = this.mappingAll();
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CmUserDto findForKey(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getConditionForKey(this.getClass()));
            this.setParam(this.index++, userId);
            this.executeQuery();
            CmUserDto cmUserDto = null;
            if (this.rs.next()) {
                cmUserDto = this.mapping();
            }
            CmUserDto cmUserDto2 = cmUserDto;
            return cmUserDto2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CmUserDto findForUpdate(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getConditionForKey(this.getClass()) + this.getForUpdate());
            this.setParam(this.index++, userId);
            this.executeQuery();
            CmUserDto cmUserDto = null;
            if (this.rs.next()) {
                cmUserDto = this.mapping();
            }
            CmUserDto cmUserDto2 = cmUserDto;
            return cmUserDto2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CmUserDto> findCmUserForCondition(String userId, String userName, String authority, String deleteFlag) throws SQLException, IllegalAccessException, NoSuchFieldException {
        this.index = 1;
        StringBuffer sb = new StringBuffer();
        sb.append("WHERE ");
        sb.append("USER_ID");
        sb.append(" LIKE ? AND ");
        sb.append(COL_USER_NAME);
        sb.append(" LIKE ? ");
        if (!authority.equals("")) {
            sb.append("AND ");
            sb.append(COL_AUTHORITY);
            sb.append(" = ? ");
        }
        if (!deleteFlag.equals("")) {
            sb.append("AND ");
            sb.append(COL_DELETE_FLAG);
            sb.append(" = ? ");
        }
        try {
            this.prepareStatement(this.getSelectQuery(this.getClass()) + sb.toString() + this.getOrderForKey(this.getClass()));
            this.setParam(this.index++, userId + "%");
            this.setParam(this.index++, "%" + userName + "%");
            if (!authority.equals("")) {
                this.setParam(this.index++, authority);
            }
            if (!deleteFlag.equals("")) {
                this.setParam(this.index++, Integer.parseInt(deleteFlag));
            }
            this.executeQuery();
            List<CmUserDto> list = this.mappingAll();
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int insert(CmUserDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getInsertQuery(this.getClass()));
            this.setParams(dto, true);
            this.executeUpdate();
            this.chkInsert(1);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(CmUserDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(dto, false);
            this.setParam(this.index++, dto.getUserId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    private void setParams(CmUserDto dto, boolean isInsert) throws SQLException {
        this.setParam(this.index++, dto.getUserId());
        this.setParam(this.index++, dto.getPassword());
        this.setParam(this.index++, dto.getKCode());
        this.setParam(this.index++, dto.getUserName());
        this.setParam(this.index++, dto.getAuthority());
        this.setParam(this.index++, dto.getDataLevel());
        this.setParam(this.index++, dto.getChangePass());
        this.setParam(this.index++, dto.getDeleteFlag());
        this.setCommonParams(isInsert);
    }
}

