/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import jp.mosp.common.common.MospException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiReadUtility {
    protected static final String SHEET_NAME = "Sheet1";
    private POIFSFileSystem fs;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFRow row;
    private HSSFCell cell;

    public PoiReadUtility() {
    }

    public PoiReadUtility(String filePath) {
        try {
            this.readFile(filePath);
            this.setWorkBook();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PoiReadUtility(File file) {
        try {
            this.readFile(file);
            this.setWorkBook();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readFile(String filePath) throws FileNotFoundException, IOException {
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(filePath));
    }

    private void readFile(File file) throws FileNotFoundException, IOException {
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
    }

    private void setWorkBook() throws IOException {
        this.wb = new HSSFWorkbook(this.fs);
    }

    protected HSSFSheet getSheet() {
        return this.sheet;
    }

    protected void setSheet() throws MospException {
        this.sheet = this.wb.getSheet(SHEET_NAME);
        if (this.sheet == null) {
            throw new MospException(1040, "\u5b58\u5728\u3057\u306a\u3044\u30b7\u30fc\u30c8\u306b\u5bfe\u3059\u308b\u64cd\u4f5c\u3092\u8a66\u307f\u307e\u3057\u305f\u3002");
        }
    }

    protected void setSheet(String sheetname) throws MospException {
        this.sheet = this.wb.getSheet(sheetname);
        if (this.sheet == null) {
            this.setSheet();
        }
    }

    protected void setCell(short cellno) {
        this.cell = this.row.getCell(cellno);
    }

    protected void setRow(HSSFRow row) {
        this.row = row;
    }

    protected HSSFCell getCell() {
        return this.cell;
    }

    protected HSSFRow getRow() {
        return this.row;
    }

    protected void setRow(int rowno) {
        this.row = this.sheet.getRow(rowno);
    }

    protected String getStringCellValue() {
        return this.cell.getStringCellValue();
    }

    protected String getStringCellValue(short cellno) {
        this.setCell(cellno);
        if (this.getCell() != null) {
            return this.cell.getStringCellValue();
        }
        return null;
    }

    protected double getNumberCellValue() {
        return this.cell.getNumericCellValue();
    }

    protected Date getDateCellValue() {
        return this.cell.getDateCellValue();
    }

    protected String getCellValue(short cellno) {
        String value = "";
        this.setCell(cellno);
        if (this.getCell() != null) {
            value = this.cell.getCellType() == 0 ? String.valueOf(Double.valueOf(this.getNumberCellValue()).intValue()) : (this.cell.getCellType() == 2 ? this.cell.getCellFormula() : (this.cell.getCellType() == 3 ? "" : this.getStringCellValue()));
        }
        return value;
    }
}

