/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.se.SeUtility;

public final class MospUtility {
    public static String getMospJarVersion() {
        return "1.1.39";
    }

    public static Object getInstance(Properties ctl, String key) throws IllegalAccessException, InstantiationException, MospException {
        return MospUtility.getInstance(ctl.getProperty(key));
    }

    public static Object getInstance(String className) throws IllegalAccessException, InstantiationException, MospException {
        Object obj = null;
        if (className == null) {
            throw new MospException(5001);
        }
        try {
            obj = Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MospException(5002);
        }
        return obj;
    }

    public static Properties getResource(String path) throws IOException {
        Properties pr = new Properties();
        FileInputStream is = new FileInputStream(path);
        pr.loadFromXML(is);
        is.close();
        return pr;
    }

    public static void addResources(Properties pr, String path, String target) throws IOException {
        int i;
        String[] files = new File(path).list();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < files.length; ++i) {
            if (files[i].indexOf(target) <= 0) continue;
            list.add(files[i]);
        }
        Collections.sort(list);
        for (i = 0; i < list.size(); ++i) {
            FileInputStream is = new FileInputStream(path + (String)list.get(i));
            pr.loadFromXML(is);
            is.close();
        }
    }

    public static String getMessage(Properties msg, String msgCode, String rep) throws MospException {
        String strMsg = msg.getProperty(msgCode);
        if (strMsg == null) {
            throw new MospException(5005);
        }
        return MospUtility.replace(strMsg, rep);
    }

    public static String replace(String message, String rep) {
        if (message == null) {
            return null;
        }
        String[] aryRep = rep.split(",");
        String replaced = message;
        for (int i = 0; i < aryRep.length; ++i) {
            replaced = replaced.replaceAll("%" + String.valueOf(i + 1) + "%", aryRep[i]);
        }
        return replaced;
    }

    public static String generateProcSeq(boolean hasMospSeJar, String stored) {
        if (hasMospSeJar) {
            return SeUtility.generateProcSeq();
        }
        String procSeq = "0";
        if (stored != null && ValidateUtility.chkNumeric(stored)) {
            procSeq = String.valueOf(Integer.parseInt(stored) + 1);
        }
        return procSeq;
    }

    public static String getDigest(String value) throws NoSuchAlgorithmException {
        StringBuffer digest = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = value.getBytes();
        md.update(bytes);
        bytes = md.digest();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            if (b < 16) {
                digest.append("0");
            }
            digest.append(Integer.toString(b, 16));
        }
        return digest.toString();
    }

    public static String encrypt(String value, boolean hasMospSeJar) throws NoSuchAlgorithmException {
        if (hasMospSeJar) {
            return SeUtility.encrypt((String)value);
        }
        return value;
    }

    public static void convProperties(Properties ppt, String path, String name) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream fos = new FileOutputStream(path, false);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "Windows-31J");
        StringBuffer sb = new StringBuffer();
        sb.append("var ");
        sb.append(name);
        sb.append(" = new Object();");
        sb.append(MospConst.LINE_SEPARATOR);
        Enumeration<?> e = ppt.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            sb.append(name);
            sb.append("[\"");
            sb.append(key);
            sb.append("\"] = \"");
            sb.append(ppt.getProperty(key));
            sb.append("\";");
            sb.append(MospConst.LINE_SEPARATOR);
        }
        osw.write(sb.toString());
        osw.close();
        fos.close();
    }

    public static Date getDate(String strDate) throws MospException {
        try {
            DateFormat df = DateFormat.getDateInstance();
            return df.parse(strDate);
        }
        catch (ParseException e) {
            throw new MospException(5009);
        }
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String msg = sw.toString();
        msg = msg.replaceAll(MospConst.LINE_SEPARATOR, "");
        return msg;
    }

    public static int getAspFlag(Properties cfg) throws MospException {
        try {
            return Integer.parseInt(cfg.getProperty("asp.flag"));
        }
        catch (NumberFormatException e) {
            throw new MospException(5003);
        }
    }

    public static String getDateString(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static int getYear(Date date) {
        return MospUtility.getCalendarValue(date, 1);
    }

    public static int getMonth(Date date) {
        return MospUtility.getCalendarValue(date, 2) + 1;
    }

    public static int getDay(Date date) {
        return MospUtility.getCalendarValue(date, 5);
    }

    public static int getHour(Date date) {
        return MospUtility.getCalendarValue(date, 11);
    }

    public static int getMinute(Date date) {
        return MospUtility.getCalendarValue(date, 12);
    }

    public static int getCalendarValue(Date date, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static Date addYear(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(1, amount);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, amount);
        return cal.getTime();
    }

    public static Date addDay(Date date, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, amount);
        return cal.getTime();
    }

    public static Date getSystemDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static double round(double value, int scale, int mode) {
        BigDecimal bd = new BigDecimal(value);
        return bd.setScale(scale, mode).doubleValue();
    }
}

