/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;

import jp.morpho.util.ConversionList;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.ServletRequestAttributeNames;

/**
 * <P>
 * of[^̌،ʂłB
 * </P>
 * @author Kenichi Fukuda
 */
public class ValidationState
	implements Serializable
{
	/** tB[hƃbZ[W֘At}bv */
	protected ConversionMap fieldMap = new ConversionMap();

	/** bZ[W̃Xg */
	protected ConversionList messageList = new ConversionList();

	/**
	 * <P>
	 * ValidationState 쐬܂B
	 * </P>
	 */
	protected ValidationState()
	{
		super();
	}

	/**
	 * <P>
	 * 肪oꂽtB[hɑ΂ăbZ[Wǉ܂B
	 * </P>
	 * @param fieldName 肪oꂽtB[h̖O
	 * @param message ǉ郁bZ[W
	 */
	public void addInvalidField(String fieldName, String message)
	{
		if (fieldName == null)
		{
			throw new NullPointerException();
		}

		if (!fieldMap.containsKey(fieldName))
		{
			fieldMap.putObject(fieldName, new ConversionList());
		}

		if (message != null)
		{
			messageList.add(message);
			fieldMap.getList(fieldName).add(new Integer(messageList.size() - 1));
		}
	}

	/**
	 * <P>
	 * w肳ꂽtB[h̃bZ[WԂ܂B
	 * </P>
	 * @param fieldName tB[h̖O
	 * @return bZ[W̔z
	 */
	public String[] getMessages(String fieldName)
	{
		if (fieldMap.containsKey(fieldName))
		{
			ConversionList idxList = ConversionList.valueOf(fieldMap.getList(fieldName));
			if (idxList != null && idxList.size() > 0)
			{
				String[] messages = new String[idxList.size()];
				for (int i = 0; i < messages.length; i++)
				{
					messages[i] = (String)messageList.get(idxList.getInt(i));
				}
				return messages;
			}
		}

		return new String[0];
	}

	/**
	 * <P>
	 * ׂẴbZ[WԂ܂B
	 * </P>
	 * @return bZ[W̔z
	 */
	public String[] getMessages()
	{
		String[] messages = new String[messageList.size()];
		return (String[])messageList.toArray(messages);
	}

	/**
	 * <P>
	 * ̌،ʂɊi[Ă郁bZ[WԂ܂B
	 * </P>
	 * @return ̌،ʂɊi[Ă郁bZ[W
	 */
	public int getMessageCount()
	{
		return messageList.size();
	}

	/**
	 * <P>
	 * 肪oĂtB[h̏ꍇAtrue Ԃ܂B
	 * </P>
	 * @param fieldName tB[h̖O
	 * @return 肪oĂtB[h̏ꍇ true
	 */
	public boolean isInvalidField(String fieldName)
	{
		return fieldMap.containsKey(fieldName);
	}

	/**
	 * <P>
	 * 肪oĂtB[h̖OzɊi[ĕԂ܂B
	 * </P>
	 * @return 肪oĂtB[hi[ꂽz
	 */
	public String[] getInvalidFieldNames()
	{
		String[] fieldNames = new String[fieldMap.size()];
		return (String[])fieldMap.values().toArray(fieldNames);
	}

	/**
	 * <P>
	 * 肪oĂtB[h̐Ԃ܂B
	 * </P>
	 * @return 肪oĂtB[h̐
	 */
	public int getInvalidFieldCount()
	{
		return fieldMap.size();
	}

	/**
	 * <P>
	 * w肳ꂽvIuWFNgof[^̌،ʂ擾܂B
	 * </P>
	 * @return of[^̌،
	 */
	public static synchronized ValidationState getInstance(HttpServletRequest request)
	{
		ValidationState vs = (ValidationState)request.getAttribute(ServletRequestAttributeNames.validationState);
		if (vs == null)
		{
			vs = new ValidationState();
			request.setAttribute(ServletRequestAttributeNames.validationState, vs);
		}
		return vs;
	}

}
