/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * HTTP p[^ݒ肳ꂽK\Ƀ}b`邩؂邽߂̃NXłB
 * gpł鐳K\ɂẮAjava.util.regex.Pattern ̐K\\QƂĂB
 * </P>
 * @author Kenichi Fukuda
 * @see java.util.regex.Pattern
 */
public class RegexValidator extends AbstractFieldValidator
{
	private String pattern = null;

	/**
	 * <P>
	 * w肳ꂽvIuWFNg HTTP p[^̑Ó؂܂B
	 * </P>
	 * @param request vIuWFNg
	 * @throws ValidationException Ó؂Ƃɖ肪oꂽꍇ
	 */
	public void validate(HttpActionRequest request) throws ValidationException
	{
		if (pattern == null)
		{
			throw new ValidationException("pattern is not set");
		}

		String value = request.getParameter(this.getFieldName());

		if (!this.isValidate(value))
		{
			return;
		}
		this.validateRequired(value);

		try
		{
			Pattern p = Pattern.compile(pattern);
			Matcher m = p.matcher(value);
			if (!m.find())
			{
				throw new ValidationException("value is not match");
			}
		}
		catch (Exception e)
		{
			throw new ValidationException(e);
		}

	}

	/**
	 * <P>
	 * ݒ肳Ă鐳K\Ԃ܂B
	 * </P>
	 * @return ݒ肳Ă鐳K\Bݒ肳ĂȂꍇ null
	 */
	public String getPattern()
	{
		return pattern;
	}

	/**
	 * <P>
	 * K\ݒ肵܂B
	 * </P>
	 * @param value K\
	 */
	public void setPattern(String value)
	{
		pattern = value;
	}

}
