/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * HTTP p[^ double lł邩؂邽߂̃NXłB
 * ŏlݒ肳Ăꍇ͍ŏlȏł邩Aőlݒ肳Ăꍇ͍őlȉł邩؂܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class DoubleValidator extends AbstractFieldValidator
{
	private Double minimum = null;
	private Double maximum = null;

	/**
	 * <P>
	 * w肳ꂽvIuWFNg HTTP p[^̑Ó؂܂B
	 * </P>
	 * @param request vIuWFNg
	 * @throws ValidationException Ó؂Ƃɖ肪oꂽꍇ
	 */
	public void validate(HttpActionRequest request) throws ValidationException
	{
		String value = request.getParameter(this.getFieldName());

		if (!this.isValidate(value))
		{
			return;
		}
		this.validateRequired(value);

		double number = 0;
		try
		{
			number = Double.parseDouble(value);
		}
		catch (Exception e)
		{
			throw new ValidationException("value is not double");
		}

		if (minimum != null)
		{
			if (minimum.doubleValue() > number)
			{
				throw new ValidationException("out of range");
			}
		}

		if (maximum != null)
		{
			if (maximum.doubleValue() < number)
			{
				throw new ValidationException("out of range");
			}
		}

		if (this.getCompareFieldName() != null)
		{
			if (this.getCompareOperator() == null)
			{
				throw new ValidationException("compare operator is not set");
			}
			else
			{
				ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
				double compareValue = form.getDouble(this.getCompareFieldName());
				String ope = this.getCompareOperator().trim();
				if (ope.equals(">"))
				{
					if (!(number > compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals(">="))
				{
					if (!(number >= compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("=="))
				{
					if (!(number == compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<="))
				{
					if (!(number <= compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<"))
				{
					if (!(number < compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("!="))
				{
					if (!(number != compareValue))
					{
						throw new ValidationException("compare error");
					}
				}
				else
				{
					throw new ValidationException("compare operator is not supported:" + ope);
				}
			}
		}
	}

	/**
	 * <P>
	 * ŏlݒ肵܂B
	 * </P>
	 * @param value ŏl
	 */
	public void setMinimum(double value)
	{
		this.minimum = new Double(value);
	}

	/**
	 * <P>
	 * őlݒ肵܂B
	 * </P>
	 * @param value ől
	 */
	public void setMaximum(double value)
	{
		this.maximum = new Double(value);
	}

	/**
	 * <P>
	 * ݒ肳ĂőlԂ܂B
	 * </P>
	 * @return ݒ肳ĂőlBݒ肳ĂȂꍇ 0
	 */
	public double getMaximum()
	{
		return (maximum != null) ? maximum.doubleValue() : 0;
	}

	/**
	 * <P>
	 * ݒ肳ĂŏlԂ܂B
	 * </P>
	 * @return ݒ肳ĂŏlBݒ肳ĂȂꍇ 0
	 */
	public double getMinimum()
	{
		return (minimum != null) ? minimum.doubleValue() : 0;
	}

	/**
	 * <P>
	 * őlݒ肳Ăꍇ true Ԃ܂B
	 * </P>
	 * @return őlݒ肳Ăꍇ true
	 */
	public boolean isMaximumSet()
	{
		return (maximum != null);
	}

	/**
	 * <P>
	 * ŏlݒ肳Ăꍇ true Ԃ܂B
	 * </P>
	 * @return ŏlݒ肳Ăꍇ true
	 */
	public boolean isMinimumSet()
	{
		return (minimum != null);
	}

}
