/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;

/**
 * <P>
 * HTML ̃tH[^OnhłB
 * </P>
 * <P>
 * HTML ̃tH[́Äꕔ𐬂Aʏ̓eƃ}[NtAăRg[ƌĂ΂ʂȗvfAXɂRg[̃x܂݂܂B
 * Rg[ɂ̓`FbN{bNXAWI{^Aj[Ȃǂ܂B
 * [U͈ʂɁAeLXgǉAj[ڂIԁAĂRg[ύXătH[uvǍtH[̂߂ Web T[o⃁[T[õG[WFgւƃtH[o܂B
 * </P>
 * <P>
 * FORM  HTML 4 `͎̂ƂłB
 * <PRE>
 * &lt;!ELEMENT FORM - - (%block;|SCRIPT)+ -(FORM) -- interactive form --&gt;
 * &lt;!ATTLIST FORM
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   action      %URI;          #REQUIRED -- server-side form handler --
 *   method      (GET|POST)     GET       -- HTTP method used to submit the form--
 *   enctype     %ContentType;  "application/x-www-form-urlencoded"
 *   accept      %ContentTypes; #IMPLIED  -- list of MIME types for file upload --
 *   name        CDATA          #IMPLIED  -- name of form for scripting --
 *   onsubmit    %Script;       #IMPLIED  -- the form was submitted --
 *   onreset     %Script;       #IMPLIED  -- the form was reset --
 *   accept-charset %Charsets;  #IMPLIED  -- list of supported charsets --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class FormTag extends ControlTagSupport
{

	/**
	 * <P>
	 * FormTag 쐬܂B
	 * </P>
	 */
	public FormTag()
	{
		super();
	}

	/**
	 * <P>
	 * accept Ԃ܂B
	 * </P>
	 * @return accept 
	 */
	public String getAccept()
	{
		return getAttributeMap().getString("accept");
	}

	/**
	 * <P>
	 * accept-charset Ԃ܂B
	 * </P>
	 * @return accept-charset 
	 */
	public String getAcceptCharset()
	{
		return getAttributeMap().getString("accept-charset");
	}

	/**
	 * <P>
	 * action Ԃ܂B
	 * </P>
	 * @return action 
	 */
	public String getAction()
	{
		return getAttributeMap().getString("action");
	}

	/**
	 * <P>
	 * enctype Ԃ܂B
	 * </P>
	 * @return enctype 
	 */
	public String getEnctype()
	{
		return getAttributeMap().getString("enctype");
	}

	/**
	 * <P>
	 * method Ԃ܂B
	 * </P>
	 * @return method 
	 */
	public String getMethod()
	{
		return getAttributeMap().getString("method");
	}

	/**
	 * <P>
	 * name Ԃ܂B
	 * </P>
	 * @return name 
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * onreset Ԃ܂B
	 * </P>
	 * @return onreset 
	 */
	public String getOnreset()
	{
		return getAttributeMap().getString("onreset");
	}

	/**
	 * <P>
	 * onsubmit Ԃ܂B
	 * </P>
	 * @return onsubmit 
	 */
	public String getOnsubmit()
	{
		return getAttributeMap().getString("onsubmit");
	}

	/**
	 * <P>
	 * accept ݒ肵܂B
	 * </P>
	 * @param accept accept 
	 */
	public void setAccept(String accept)
	{
		getAttributeMap().putString("accept", accept);
	}

	/**
	 * <P>
	 * accept-charset ݒ肵܂B
	 * </P>
	 * @param acceptCharset accept-charset 
	 */
	public void setAcceptCharset(String acceptCharset)
	{
		getAttributeMap().putString("accept-charset", acceptCharset);
	}

	/**
	 * <P>
	 * action ݒ肵܂B
	 * </P>
	 * @param action action 
	 */
	public void setAction(String action)
	{
		getAttributeMap().putString("action", action);
	}

	/**
	 * <P>
	 * enctype ݒ肵܂B
	 * </P>
	 * @param enctype enctype 
	 */
	public void setEnctype(String enctype)
	{
		getAttributeMap().putString("enctype", enctype);
	}

	/**
	 * <P>
	 * method ݒ肵܂B
	 * </P>
	 * @param method method 
	 */
	public void setMethod(String method)
	{
		getAttributeMap().putString("method", method);
	}

	/**
	 * <P>
	 * name ݒ肵܂B
	 * </P>
	 * @param name name 
	 */
	public void setName(String name)
	{
		getAttributeMap().putString("name", name);
	}

	/**
	 * <P>
	 * onreset ݒ肵܂B
	 * </P>
	 * @param onreset onreset 
	 */
	public void setOnreset(String onreset)
	{
		getAttributeMap().putString("onreset", onreset);
	}

	/**
	 * <P>
	 * onsubmit ݒ肵܂B
	 * </P>
	 * @param onsubmit onsubmit 
	 */
	public void setOnsubmit(String onsubmit)
	{
		getAttributeMap().putString("onsubmit", onsubmit);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</form>");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		HttpActionRequest request =
			HttpActionRequestFactory.getInstance().getRequest(
				(HttpServletRequest)pageContext.getRequest());

		//FORM^O쐬܂
		StringBuffer buf = new StringBuffer();
		buf.append("<form");

		//w肳ĂȂɃftHglݒ肵܂
		if (!this.getAttributeMap().containsKey("action"))
		{
			this.setAction(request.getRequestURI());
		}
		if (!this.getAttributeMap().containsKey("method"))
		{
			this.setMethod("post");
		}

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			buf.append(" ").append(keys[i]).append("=\"");
			if (!keys[i].equalsIgnoreCase("action"))
			{
				buf.append(this.getAttributeMap().getString(keys[i]));
			}
			else
			{
				HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
				String url = this.getAttributeMap().getString("action");
				buf.append(response.encodeURL(url));
			}
			buf.append("\"");
		}

		buf.append(">");

		ActionMappingManager amm = getActionMappingManager();

		//Xe[^X hidden ^O쐬܂
		buf.append("<input type=\"hidden\" name=\"").append(amm.getStatusParameterName());
		buf.append("\" value=\"").append(request.getStatus());
		buf.append("\">");

		//ANV hidden ^O쐬܂
		buf.append("<input type=\"hidden\" name=\"").append(amm.getActionParameterName());
		buf.append("\" value=\"\">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
