/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <P>
 * ̃NX́Av󂯎T[ubg̃pX̃Gg\܂B
 * T[ubgv󂯎ۂɁACӂ̃ANV}bsOI悤ɂ邽߂ɁAANV}bsO}l[Wɂ̃Ggǉ܂B
 * </P>
 * <P>
 * T[ubgv󂯎ۂɁACӂ̃ANV}bsOI悤ɂ邽߂ɁA2 ̃\bh  addActionHandlerEntry(ActionHandlerEntry) AaddActionViewEntry(ActionViewEntry) gpăGgǉKv܂B
 * O҂͗vANVnh̃GgǉA҂͗vɕ\ʂ\ANVr[̃Ggǉ܂B
 * </P>
 * <P>
 * setServletPath(String) \bhŎw肷T[ubg URL ́Aweb.xml ɂĔzuT[ubg URL  łB
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionServletPath
	implements Serializable
{
	/** null ̃ANV}bsOΉ URL */
	private static final String NULL_SERVLETPATH = "";

	/** null ̃Xe[^X̒l */
	private static final String NULL_STATUS = "";

	/** null ̃ANV̒l */
	private static final String NULL_ACTION = "";

	/** ANV}bsOΉ URL */
	private String servletPath = null;

	/** ANVnhGg̃}bv */
	private Map actionHandlerEntries = new HashMap();

	/** ANVr[Gg̃}bv */
	private Map actionViewEntries = new HashMap();

	/**
	 * <P>
	 * ActionServletPath 쐬܂B
	 * </P>
	 */
	public ActionServletPath()
	{
		super();
	}

	/**
	 * <P>
	 * ANV}bsOΉT[ubg URL 擾܂B
	 * </P>
	 * @return ANV}bsOΉT[ubg URL
	 */
	public synchronized String getServletPath()
	{
		return (servletPath != null) ? servletPath : NULL_SERVLETPATH;
	}

	/**
	 * <P>
	 * ANV}bsOΉT[ubg URL ݒ肵܂B
	 * </P>
	 * @param servletPath ANV}bsOΉT[ubg URL
	 */
	public synchronized void setServletPath(String servletPath)
	{
		this.servletPath = servletPath;
	}

	/**
	 * <P>
	 * łɓL[̃ANVnhGgǉĂ邩ǂ𔻒肵܂B
	 * ANVnhGg̃}bvw̃L[̃}bsOێꍇAO IllegalArgumentException X[܂B
	 * </P>
	 * @param key }bvɂ邩ǂ肳L[
	 * @exception IllegalArgumentException ANVnhGg̃}bvw̃L[̃}bsOێĂꍇ
	 */
	private synchronized void checkActionHandlerMapping(String key)
	{
		if (actionHandlerEntries.containsKey(key))
		{
			throw new IllegalArgumentException("ActionHandlerEntry Mapping Key already exists: " + key);
		}
	}

	/**
	 * <P>
	 * łɓL[̃ANVr[GgǉĂ邩ǂ𔻒肵܂B
	 * ANVr[Gg̃}bvw̃L[̃}bsOێꍇAO IllegalArgumentException X[܂B
	 * </P>
	 * @param key }bvɂ邩ǂ肳L[
	 * @exception IllegalArgumentException ANVr[Gg̃}bvw̃L[̃}bsOێĂꍇ
	 */
	private synchronized void checkActionViewMapping(String key)
	{
		if (this.actionViewEntries.containsKey(key))
		{
			throw new IllegalArgumentException("ActionViewEntry Mapping Key already exists: " + key);
		}
	}

	/**
	 * <P>
	 * w肳ꂽANVnhGgǉ܂B
	 * </P>
	 * @param entry ǉANVnhGg
	 */
	public synchronized void addActionHandlerEntry(
		ActionHandlerEntry entry)
	{
		String key = generateActionHandlerMappingKey(entry.getStatus(), entry.getAction());
		checkActionHandlerMapping(key);
		actionHandlerEntries.put(key, entry);
	}

	/**
	 * <P>
	 * ANVnhGg擾܂B
	 * </P>
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnhGgBꂪȂꍇ null
	 */
	public synchronized ActionHandlerEntry getActionHandlerEntry(
		String status, String action)
	{
		return (ActionHandlerEntry)actionHandlerEntries.get(generateActionHandlerMappingKey(status, action));
	}

	/**
	 * <P>
	 * w肳ꂽANVr[Ggǉ܂B
	 * </P>
	 * @param entry ǉANVr[Gg
	 */
	public synchronized void addActionViewEntry(
		ActionViewEntry entry)
	{
		String key = generateActionViewMappingKey(entry.getStatus());
		checkActionViewMapping(key);
		actionViewEntries.put(key, entry);
	}

	/**
	 * <P>
	 * ANVr[Gg擾܂B
	 * </P>
	 * @param status vXe[^X̒l
	 * @return ANVr[GgBꂪȂꍇ null
	 */
	public synchronized ActionViewEntry getActionViewEntry(String status)
	{
		return (ActionViewEntry)actionViewEntries.get(generateActionViewMappingKey(status));
	}

	/**
	 * <P>
	 * ANVnhGg}bvIuWFNgɊ֘At邽߂̃L[쐬܂B
	 * </P>
	 * <P>
	 * ͎̂悤ȃL[쐬܂B
	 * <CODE>
	 * ActionHandlerEntry[status=<I>Xe[^X̒l</I>,action=<I>ANV̒l</I>]
	 * </CODE>
	 * </P>
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnhGg̃L[
	 */
	public synchronized String generateActionHandlerMappingKey(String status, String action)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("ActionHandlerEntry[");
		buf.append("status=").append((status != null) ? status : NULL_STATUS);
		buf.append(",");
		buf.append("action=").append((action != null) ? action : NULL_ACTION);
		buf.append("]");

		return buf.toString();
	}

	/**
	 * <P>
	 * ANVr[Gg}bvIuWFNgɊ֘At邽߂̃L[쐬܂B
	 * </P>
	 * <P>
	 * ͎̂悤ȃL[쐬܂B
	 * <CODE>
	 * ActionViewEntry[status=<I>Xe[^X̒l</I>]
	 * </CODE>
	 * </P>
	 * @param status vXe[^X̒l
	 * @return ANVr[Gg̃L[
	 */
	public synchronized String generateActionViewMappingKey(String status)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("ActionViewEntry[");
		buf.append("status=").append((status != null) ? status : NULL_STATUS);
		buf.append("]");

		return buf.toString();
	}

}
