/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action;

import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.PluginKeys;

/**
 * <P>
 * ̃NX́AActionMappingManager C^tF[X̃XPg񋟂ÃC^tF[X̂ɕKvȍƗʂŏɗ}܂B
 * ANV}bsO}l[Wɂ́ÃNXgāA̃\bhKv܂B
 * ActionMappingManager C^tF[X̎dlŐĂ悤ɁAʏ́AȂ void RXgN^񋟂ĂB
 * </P>
 * @author Kenichi Fukuda
 */
public abstract class AbstractActionMappingManager
	implements ActionMappingManager
{

	/**
	 * <P>
	 * vXe[^X̃p[^̖OԂ܂B
	 * </P>
	 * @return vXe[^X̃p[^̖O
	 * @see jp.morpho.webapp.action.ActionMappingManager#getStatusParameterName()
	 */
	public abstract String getStatusParameterName();

	/**
	 * <P>
	 * vANṼp[^̖OԂ܂B
	 * </P>
	 * @return vANṼp[^̖O
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionParameterName()
	 */
	public abstract String getActionParameterName();

	/**
	 * <P>
	 * ANVnh`FCԂ܂B
	 * ANVnh`FĆAActionMappingManager  getActionHandlers(String, String, String) \bh getActionView(String, String) \bhĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh`FC
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlerChain(String, String, String)
	 */
	public abstract ActionHandlerChain getActionHandlerChain(
		String servletPath,
		String status,
		String action);

	/**
	 * <P>
	 * ANVnh̔zԂ܂B
	 * ԂꂽANVnh̔źAANVnh`FC doActionHandler \bhŏɌĂяo܂B
	 * </P>
	 * <P>
	 * ̃\bh́AvANVnh擾邽߂ɁAANVnh`FCĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh̔z
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlers(String, String, String)
	 */
	public abstract ActionHandler[] getActionHandlers(
		String servletPath,
		String status,
		String action)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * ANVr[̃pX (JSP Ȃ) Ԃ܂B
	 * ANVr[́AANVnh`FC doActionHandler \bhŁAANVnhĂяoꂽAɃCN[h܂B
	 * </P>
	 * <P>
	 * Xe[^X̒ĺAANVnhŕύX邱Ƃ邽߁AT[ubgv󂯎̒lƕKv܂B
	 * ̃\bh́AANVnh`FC doActionHandler \bhŁAׂẴANVnhsꂽɌĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @return ANVr[̃pX
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionView(String, String)
	 */
	public abstract String getActionView(String servletPath, String status)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * vOCʂ邽߂̃L[Ԃ܂B
	 * vOC̃L[́ApbP[WƓKɏ]Kv܂B
	 * ̎dlł́Ajp.morpho.* Ɉv閼O\񂵂Ă܂B
	 * </P>
	 * @return vOCʂ邽߂̃L[
	 * @see jp.morpho.webapp.Plugin#getPluginKey()
	 */
	public final String getPluginKey()
	{
		return PluginKeys.actionMappingManager;
	}

	/**
	 * <P>
	 * vOCReLXgݒ肵܂B
	 * t[[Nł́AvOCCX^Xǉꂽɂ̃\bhĂяo܂B
	 * </P>
	 * @param fc ̃CX^Xǉ FrameworkContext IuWFNg
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void setPluginContext(PluginContext fc)
		throws PluginException
	{
	}

	/**
	 * <P>
	 * pluginActivate \bh́ACX^XԂɂȂƂɌĂяo܂B
	 * CX^X܂B
	 * </P>
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void pluginActivate()
		throws PluginException
	{
	}

	/**
	 * <P>
	 * t[[Nł́AvOCIuWFNg̗LԂI点Oɂ̃\bhĂяo܂B
	 * ׂẴ\[X܂B
	 * </P>
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void pluginRemove()
		throws PluginException
	{
	}

}
