/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * <P>
 * ̓Xg[t@Ng̋@\`܂B
 * ̓Xg[t@NǵA̓Xg[t@CApXAoCgzAURL Ȃǂ̃IuWFNg琶邽߂Ɏgp܂B
 * </P>
 * <P>
 * ̎ getInputStream \bh́AExpandedInputStream Ԃ܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class InputStreamFactory
{

	/**
	 * <P>
	 * InputStreamFactory IuWFNg쐬܂B
	 * </P>
	 */
	public InputStreamFactory()
	{
		super();
	}

	/**
	 * <P>
	 * t@CVXe̎ۂ̃t@C (File IuWFNg file ɂw) ɐڑ邱ƂɂAFileInputStream 쐬܂B
	 * ̃t@C̐ڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckRead \bhAfile ɂĕ\pXƂČĂяo܂B
	 * </P>
	 * <P>
	 * w肳ꂽt@C݂ȂAʂ̃t@Cł͂ȂfBNgł邩A܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param file ǂݍ݂̂߂ɊJt@C
	 * @return t@Cǂݍނ߂̓̓Xg[ (ExpandedInputStream)
	 * @exception FileNotFoundException t@C݂ȂAʂ̃t@Cł͂ȂfBNgł邩A܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckRead \bht@Cւ̓ǂݍ݃ANZXۂꍇ
	 */
	public synchronized InputStream getInputStream(File file) throws FileNotFoundException
	{
		return new ExpandedInputStream(new FileInputStream(file));
	}

	/**
	 * <P>
	 * t@CVXe̎ۂ̃t@C (pX path ɂw) ɐڑ邱ƂɂAFileInputStream 쐬܂B
	 * ̃t@C̐ڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckRead \bh name ƂČĂяo܂B
	 * </P>
	 * <P>
	 * w肳ꂽt@C݂ȂAʂ̃t@Cł͂ȂfBNgł邩A܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param name VXeˑ̃t@C
	 * @return t@Cǂݍނ߂̓̓Xg[ (ExpandedInputStream)
	 * @exception FileNotFoundException t@C݂ȂAʂ̃t@Cł͂ȂfBNgł邩A܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckRead \bht@Cւ̓ǂݍ݃ANZXۂꍇ
	 */
	public synchronized InputStream getInputStream(String path) throws FileNotFoundException
	{
		return getInputStream(new File(path));
	}

	/**
	 * <P>
	 * bytes obt@zƂĎg悤ɁAByteArrayInputStream 쐬܂B
	 * obt@z̓Rs[܂B
	 * pos ̏l 0 ŁAcount ̏l bytes ̒łB
	 * </P>
	 * @param bytes ̓obt@
	 * @return oCgzǂݍނ߂̓̓Xg[ (ExpandedInputStream)
	 */
	public synchronized InputStream getInputStream(byte[] bytes)
	{
		return new ExpandedInputStream(new ByteArrayInputStream(bytes));
	}

	/**
	 * <P>
	 * bytes obt@zƂĎg悤ɁAByteArrayInputStream 쐬܂B
	 * pos ̏l offset ŁAcount ̏l offset + len łB
	 * obt@z̓Rs[܂B
	 * obt@̃}[N͎w肵ItZbgɐݒ肳܂B
	 * </P>
	 * @param bytes ̓obt@
	 * @param offset obt@̃oCgǂݍ݊JnItZbg
	 * @param length obt@ǂݍލőoCg
	 * @return oCgzǂݍނ߂̓̓Xg[ (ExpandedInputStream)
	 */
	public synchronized InputStream getInputStream(byte[] bytes, int offset, int length)
	{
		return new ExpandedInputStream(new ByteArrayInputStream(bytes, offset, length));
	}

	/**
	 * <P>
	 * url ւ̐ڑmA̐ڑǂݍ݂s߂ InputStream 쐬܂B
	 * </P>
	 * @param url URL
	 * @return URL ڑ͂ǂݍނ߂̓̓Xg[ (ExpandedInputStream)
	 * @exception IOException o͗Oꍇ
	 */
	public synchronized InputStream getInputStream(URL url) throws IOException
	{
		return new ExpandedInputStream(url.openStream());
	}
}
