/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.io.InputStream;
import java.net.URL;

import javax.servlet.ServletContext;

import jp.morpho.config.Configuration;
import jp.morpho.config.ConfigureException;


/**
 * <P>
 * of[^ t@Ng̎łB
 * </P>
 * @author Kenichi Fukuda
 */
public class ValidatorFactoryImpl extends ValidatorFactory
{
	/**
	 * <P>
	 * ValidatorFactoryImpl 쐬܂B
	 * </P>
	 */
	public ValidatorFactoryImpl()
	{
		super();
	}

	/**
	 * <P>
	 * of[^ IuWFNg𐶐ANX[_ XML `t@Cǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * </P>
	 * @param name NX[_ XML `t@C̖O
	 * @return NX[_ XML `t@C̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public synchronized Validator generateValidator(String name) throws ValidatorException
	{
		ClassLoader cl = Thread.currentThread().getContextClassLoader();
		if (cl == null)
		{
			cl = getClass().getClassLoader();
		}

		URL configURL = cl.getResource(name);

		InputStream in = null;
		try
		{
			in = configURL.openStream();
			return this.generateValidator(in);
		}
		catch (Exception e)
		{
			throw new ValidatorException(e);
		}
		finally
		{
			try
			{
				in.close();
			}
			catch (Exception e)
			{
			}
		}
	}

	/**
	 * <P>
	 * of[^ IuWFNg𐶐A̓Xg[ǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * </P>
	 * @param in of[^ f[^̓Xg[
	 * @return ̓Xg[̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public Validator generateValidator(InputStream in)
		throws ValidatorException
	{
		Validator v = null;
		v = new ValidatorSequence();
		Configuration config = new Configuration();
		try
		{
			config.configure(v, in);
		}
		catch (ConfigureException e)
		{
			throw new ValidatorException(e);
		}

		return v;
	}

	/**
	 * <P>
	 * of[^ IuWFNg𐶐Aw肳ꂽpXɂ XML `t@Cǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * ̃\bh́ANX[_ɊÂă\[X generateValidator(String) Ƃ͈قȂprɎg܂B
	 * ̃\bhł́ANX[_gp܂B
	 * \[X̌ɂ ServletContext IuWFNggp܂B
	 * </P>
	 * @param path \[Xւ̃pXw肷 String
	 * @return w肳ꂽpXɂ XML `t@C̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public Validator generateValidator(ServletContext sc, String path)
		throws ValidatorException
	{
		InputStream in = null;
		try
		{
			in = sc.getResourceAsStream(path);
			return this.generateValidator(in);
		}
		catch (Exception e)
		{
			throw new ValidatorException(e);
		}
		finally
		{
			try
			{
				in.close();
			}
			catch (Exception e)
			{
			}
		}
	}

}
