/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;
import jp.morpho.webapp.servlet.jsp.tagext.PropertySupportTag;

/**
 * <P>
 * SELECT vfɂč쐬ꂽj[̑IłB
 * w肳ꂽXR[v̑ɐݒ肳Ă郊Xg畡 OPTION vf쐬܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class OptionsTag
	extends BaseTag
	implements PropertySupportTag
{

	/** ̃^ÕvpeB */
	private ConversionMap property = new ConversionMap();

	/** ̃^OT|[gvpeB */
	private ConversionMap supportedPropertyMap = new ConversionMap();

	/**
	 * <P>
	 * OptionsTag 쐬܂B
	 * </P>
	 */
	public OptionsTag()
	{
		super();

		//coreattrs
		supportedPropertyMap.putString("id", "");
		supportedPropertyMap.putString("class", "");
		supportedPropertyMap.putString("style", "");
		supportedPropertyMap.putString("title", "");

		//events
		supportedPropertyMap.putString("onclick", "");
		supportedPropertyMap.putString("ondblclick", "");
		supportedPropertyMap.putString("onmousedown", "");
		supportedPropertyMap.putString("onmouseup", "");
		supportedPropertyMap.putString("onmouseover", "");
		supportedPropertyMap.putString("onmousemove", "");
		supportedPropertyMap.putString("onmouseout", "");
		supportedPropertyMap.putString("onkeypress", "");
		supportedPropertyMap.putString("onkeydown", "");
		supportedPropertyMap.putString("onkeyup", "");

		//i18n
		supportedPropertyMap.putString("lang", "");
		supportedPropertyMap.putString("dir", "");

		//option
		supportedPropertyMap.putString("selected", "");
		supportedPropertyMap.putString("disabled", "");
		supportedPropertyMap.putString("label", "");
		supportedPropertyMap.putString("value", "");

		//options
		supportedPropertyMap.putString("text", "");
	}

	/**
	 * <P>
	 * name Ԃ܂B
	 * </P>
	 * @return name 
	 */
	public String getName()
	{
		return getAttributeMap().getString("name");
	}

	/**
	 * <P>
	 * name ݒ肵܂B
	 * </P>
	 * @param name name 
	 */
	public void setName(String name)
	{
		getAttributeMap().putString("name", name);
	}

	/**
	 * <P>
	 * scope Ԃ܂B
	 * </P>
	 * @return scope 
	 */
	public String getScope()
	{
		return getAttributeMap().getString("scope");
	}

	/**
	 * <P>
	 * scope ݒ肵܂B
	 * </P>
	 * @param scope scope 
	 */
	public void setScope(String scope)
	{
		getAttributeMap().putString("scope", scope);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		int scope = PageContext.PAGE_SCOPE;
		if ("request".equals(this.getScope()))
		{
			scope = PageContext.REQUEST_SCOPE;
		}
		else if ("session".equals(this.getScope()))
		{
			scope = PageContext.SESSION_SCOPE;
		}
		else if ("application".equals(this.getScope()))
		{
			scope = PageContext.APPLICATION_SCOPE;
		}
		List list = (List)pageContext.getAttribute(this.getName(), scope);

		for (int i = 0; i < list.size(); i++)
		{
			buf.append(getOptionTag((Map)list.get(i)));
		}

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * w肳ꂽ}bvɊ֘AtĂl OPTION vf쐬܂B
	 * </P>
	 * @return OPTION vf
	 */
	protected String getOptionTag(Map ti) throws JspException
	{
		ConversionMap tagInfo = ConversionMap.valueOf(ti);

		//SELECT^ÕCX^X擾
		Tag tag = this.getParent();
		while (!(tag instanceof SelectTag))
		{
			if (tag == null)
			{
				throw new JspException("Parent Tag is not found.");
			}
			tag = tag.getParent();
		}
		SelectTag parent = (SelectTag)tag;

		//OPTION^O쐬
		StringBuffer buf = new StringBuffer();
		buf.append("<option");

		String keys[] = new String[property.size()];
		keys = (String[])property.keySet().toArray(keys);
		HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
		for (int i = 0; i < keys.length; i++)
		{
			if (keys[i].equals("disabled") ||
				keys[i].equals("selected"))
			{
				if (tagInfo.getBoolean(property.getString(keys[i])))
				{
					buf.append(" ").append(keys[i]);
				}
			}
			else if (keys[i].equals("value"))
			{
				buf.append(" ").append(keys[i]).append("=\"").append(encoder.encode(tagInfo.getString(property.getString(keys[i])))).append("\"");
			}
			else if (keys[i].equals("text"))
			{
				//
			}
			else
			{
				buf.append(" ").append(keys[i]).append("=\"").append(tagInfo.getString(property.getString(keys[i]))).append("\"");
			}
		}

		if (!property.containsKey("selected"))
		{
			HttpActionRequest request =
				HttpActionRequestFactory.getInstance().getRequest(
					(HttpServletRequest)pageContext.getRequest());
			ConversionMap param = ConversionMap.valueOf(request.getParameterMap());
			if (!param.isNull(parent.getName()))
			{
				if (param.isArray(parent.getName()))
				{
					String values[] = (String[])param.getObject(parent.getName());
					String val = tagInfo.getString(property.getString("value"));
					for (int i = 0; i < values.length; i++)
					{
						if (val.equals(values[i]))
						{
							buf.append(" ").append("selected");
							break;
						}
					}
				}
				else
				{
					if (tagInfo.getString(property.getString("value")).equals(param.getString(parent.getName())))
					{
						buf.append(" ").append("selected");
					}
				}
			}
		}

		buf.append(">");
		buf.append(encoder.encode(tagInfo.getString(property.getString("text"))));
		buf.append("</option>");

		return buf.toString();
	}

	/**
	 * <P>
	 * w肳ꂽL[vpeBÃ^ÕvpeBXgT܂B
	 * ̃vpeBȂꍇ́Anull Ԃ܂B
	 * </P>
	 * @param key vpeBL[
	 * @return w肳ꂽL[l̃^ÕvpeBXg̒l
	 */
	public String getProperty(String key)
	{
		if (!supportedPropertyMap.containsKey(key))
		{
			throw new IllegalArgumentException(key + " is not supported");
		}

		return property.getString(key);
	}

	/**
	 * <P>
	 * ̃^OɃvpeBݒ肵܂B
	 * vpeB̃L[ђlɕgƂ`t܂B
	 * </P>
	 * @param key ̃^ÕvpeBXgɔzuL[
	 * @param value key ɑΉl
	 */
	public void setProperty(String key, String value)
	{
		if (!supportedPropertyMap.containsKey(key))
		{
			throw new IllegalArgumentException(key + " is not supported");
		}

		property.putString(key, value);
	}

}
