/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletContext;

import jp.morpho.config.Configuration;
import jp.morpho.util.ConversionList;
import jp.morpho.util.PrimitiveHolderList;
import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoderImpl;

/**
 * <P>
 * ̃NX́ATagTemplate IuWFNgێAJavaServer Pages ɂăJX^^OsꂽۂɁÃ^O֑񋟂܂B
 * </P>
 * @author user
 */
public class TagManager
	implements Plugin
{
	/** vOC ReLXg */
	private PluginContext pluginContext = null;

	/** ݒt@CpX̃Xg */
	private PrimitiveHolderList configPathList = new ConversionList();

	/** v󂯎T[ubg̃pX̃}bv */
	private Map tagTemplateMap = new HashMap();

	/** HTML̂߂̃GR[fBOIuWFNg */
	private HtmlEncoder htmlEncoder = null;

	/** null ̃^O */
	private static final String NULL_NAME = "";

	/** null ̃^O^Cv */
	private static final String NULL_TAGTYPE = "";

	/**
	 * <P>
	 * TagManager \z܂B
	 * </P>
	 */
	public TagManager()
	{
		super();
		this.setHtmlEncoder(new HtmlEncoderImpl());
	}

	/**
	 * <P>
	 * ׂĂ̐ݒt@CpX폜܂B
	 * </P>
	 */
	public synchronized void removeAllConfigurationFilePaths()
	{
		configPathList.clear();
	}

	/**
	 * <P>
	 * ݒt@CpXǉ܂B
	 * ݒt@C̓t[[N pluginActivate() \bhĂяoꂽƂɓǂݍ܂܂B
	 * </P>
	 * @param path ݒt@CpX
	 */
	public synchronized void addConfigurationFilePath(String path)
	{
		configPathList.add(path);
	}

	/**
	 * <P>
	 * ݒt@CpXK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return ݒt@CpXK؂ȏŊi[Ăz
	 */
	public synchronized String[] getConfigurationFilePaths()
	{
		String[] paths = new String[configPathList.size()];
		return (String[])configPathList.toArray(paths);
	}

	/**
	 * <P>
	 * TagTemplate IuWFNg}bvIuWFNgɊ֘At邽߂̃L[쐬܂B
	 * </P>
	 * <P>
	 * ͎̂悤ȃL[쐬܂B
	 * <CODE>
	 * TagTemplate[tagType=<I>^Õ^Cv</I>,name=<I>^O</I>]
	 * </CODE>
	 * </P>
	 * @param tagType ^Õ^Cv
	 * @param name ^O
	 * @return TagTemplate IuWFNg̃L[
	 */
	public synchronized String generateTagTemplateKey(String tagType, String name)
	{
		StringBuffer buf = new StringBuffer();
		buf.append("TagTemplate[");
		buf.append("tagType=").append((tagType != null) ? tagType : NULL_TAGTYPE);
		buf.append(",");
		buf.append("name=").append((name != null) ? name : NULL_NAME);
		buf.append("]");

		return buf.toString();
	}

	/**
	 * <P>
	 * ̃ReLXg TagTemplate ǉ܂B
	 * </P>
	 * @param fe ReLXgɒǉ TagTemplate
	 * @exception IllegalArgumentException ^O^CvœO TagTemplate ꍇ
	 */
	public synchronized void addTagTemplate(TagTemplate fe)
	{
		String key = generateTagTemplateKey(fe.getTagType(), fe.getName());
		if (tagTemplateMap.containsKey(key))
		{
			throw new IllegalArgumentException("TagTemplate already exists: " + key);
		}
		tagTemplateMap.put(key, fe);
	}

	/**
	 * <P>
	 * ̃ReLXgw肳ꂽO TagTemplate Ԃ܂B
	 * ReLXg̖O TagTemplate ێĂȂꍇ null Ԃ܂B
	 * </P>
	 * @param tagType TagTemplate ̃^O^Cv
	 * @param name TagTemplate ̖O
	 * @return w肳ꂽO TagTemplate B̖Oɑ΂ TagTemplate ReLXgɂȂꍇ null
	 */
	public synchronized TagTemplate getTagTemplate(String tagType, String name)
	{
		String key = generateTagTemplateKey(tagType, name);
		return (TagTemplate)tagTemplateMap.get(key);
	}

	/**
	 * <P>
	 * TagManager vOCʂ邽߂̃L[Ԃ܂B
	 * </P>
	 * @return TagManager vOCʂ邽߂̃L[
	 * @see jp.morpho.webapp.Plugin#getPluginKey()
	 */
	public final String getPluginKey()
	{
		return PluginKeys.tagManager;
	}

	/**
	 * Returns the htmlEncoder.
	 * @return HtmlEncoder
	 */
	public HtmlEncoder getHtmlEncoder()
	{
		return htmlEncoder;
	}

	/**
	 * Sets the htmlEncoder.
	 * @param htmlEncoder The htmlEncoder to set
	 */
	public void setHtmlEncoder(HtmlEncoder htmlEncoder)
	{
		this.htmlEncoder = htmlEncoder;
	}

	/**
	 * <P>
	 * vOCReLXgݒ肵܂B
	 * t[[Nł́AvOCCX^Xǉꂽɂ̃\bhĂяo܂B
	 * </P>
	 * @param fc ̃CX^Xǉ FrameworkContext IuWFNg
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void setPluginContext(PluginContext fc)
		throws PluginException
	{
		pluginContext = fc;
	}

	/**
	 * <P>
	 * ݒt@Cǂݍ݁A^O }l[W܂B
	 * </P>
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void pluginActivate()
		throws PluginException
	{
		ServletContext sc = pluginContext.getFrameworkContext().getServletContext();
		String[] paths = getConfigurationFilePaths();
		for (int i = 0; i < paths.length; i++)
		{
			InputStream in = null;
			try
			{
				URL url = sc.getResource(paths[i]);
				in = url.openStream();
				Configuration config = new Configuration();
				config.configure(this, in);
			}
			catch (Exception e)
			{
				Logger log = Logger.getLogger("jp.morpho");
				log.log(Level.WARNING, e.getMessage(), e);
			}
			finally
			{
				try
				{
					in.close();
				}
				catch (Exception e)
				{
				}
			}
		}
	}

	/**
	 * <P>
	 * t[[Nł́AvOCIuWFNg̗LԂI点Oɂ̃\bhĂяo܂B
	 * ׂẴ\[X܂B
	 * </P>
	 * @exception PluginException ̃\bhɂăX[A炩̃G[ŏQƂ
	 */
	public void pluginRemove()
		throws PluginException
	{
		pluginContext = null;
	}

}
