/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * <P>
 * Xgɑ΂ĕύXJ҂̎ŃTuNXɂg\ƂAList C^tF[X̊ȈՂȎ񋟂܂B
 * ̃NX́Abp[܂̓fR[^̃p^[ɊÂĎĂ܂B
 * e\bh́Abvꂽ}bvIuWFNg̃\bhftHgŌĂяo܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ListWrapper implements List
{

	//bv List
	private List wrapped = null;

	/**
	 * <P>
	 * w̃Xgbv ListWrapper \z܂B
	 * </P>
	 * @param list bv郊Xg
	 * @exception IllegalArgumentException Xg null ̏ꍇ
	 */
	public ListWrapper(List list)
	{
		super();

		//List  null ̏ꍇ IllegalArgumentException X[܂
		if (list == null)
		{
			throw new IllegalArgumentException("list must not null");
		}

		this.wrapped = list;
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ size() ĂяoƂłB
	 * <P>
	 * @see java.util.List#size()
	 */
	public int size()
	{
		return wrapped.size();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ isEmpty() ĂяoƂłB
	 * <P>
	 * @see java.util.List#isEmpty()
	 */
	public boolean isEmpty()
	{
		return wrapped.isEmpty();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ contains(Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#contains(Object)
	 */
	public boolean contains(Object key)
	{
		return wrapped.contains(key);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ iterator() ĂяoƂłB
	 * <P>
	 * @see java.util.List#iterator()
	 */
	public Iterator iterator()
	{
		return wrapped.iterator();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ toArray() ĂяoƂłB
	 * <P>
	 * @see java.util.List#toArray()
	 */
	public Object[] toArray()
	{
		return wrapped.toArray();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ toArray(Object[]) ĂяoƂłB
	 * <P>
	 * @see java.util.List#toArray(Object[])
	 */
	public Object[] toArray(Object[] a)
	{
		return wrapped.toArray(a);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ toArray(Object[]) ĂяoƂłB
	 * <P>
	 * @see java.util.List#toArray(Object[])
	 */
	public boolean add(Object o)
	{
		return wrapped.add(o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ remove(Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#remove(Object)
	 */
	public boolean remove(Object o)
	{
		return wrapped.remove(o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ containsAll(Collection) ĂяoƂłB
	 * <P>
	 * @see java.util.List#containsAll(Collection)
	 */
	public boolean containsAll(Collection c)
	{
		return wrapped.containsAll(c);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ addAll(Collection) ĂяoƂłB
	 * <P>
	 * @see java.util.List#addAll(Collection)
	 */
	public boolean addAll(Collection c)
	{
		return wrapped.addAll(c);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ addAll(int, Collection) ĂяoƂłB
	 * <P>
	 * @see java.util.List#addAll(int, Collection)
	 */
	public boolean addAll(int index, Collection c)
	{
		return wrapped.addAll(index, c);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ removeAll(Collection) ĂяoƂłB
	 * <P>
	 * @see java.util.List#removeAll(Collection)
	 */
	public boolean removeAll(Collection c)
	{
		return wrapped.removeAll(c);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ retainAll(Collection) ĂяoƂłB
	 * <P>
	 * @see java.util.List#retainAll(Collection)
	 */
	public boolean retainAll(Collection c)
	{
		return wrapped.retainAll(c);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ clear() ĂяoƂłB
	 * <P>
	 * @see java.util.List#clear()
	 */
	public void clear()
	{
		wrapped.clear();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ get(int) ĂяoƂłB
	 * <P>
	 * @see java.util.List#get(int)
	 */
	public Object get(int index)
	{
		return wrapped.get(index);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ set(int, Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#set(int, Object)
	 */
	public Object set(int index, Object o)
	{
		return wrapped.set(index, o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ add(int, Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#add(int, Object)
	 */
	public void add(int index, Object o)
	{
		wrapped.add(index, o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ remove(int) ĂяoƂłB
	 * <P>
	 * @see java.util.List#remove(int)
	 */
	public Object remove(int index)
	{
		return wrapped.remove(index);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ indexOf(Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#indexOf(Object)
	 */
	public int indexOf(Object o)
	{
		return wrapped.indexOf(o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ lastIndexOf(Object) ĂяoƂłB
	 * <P>
	 * @see java.util.List#lastIndexOf(Object)
	 */
	public int lastIndexOf(Object o)
	{
		return wrapped.lastIndexOf(o);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ listIterator() ĂяoƂłB
	 * <P>
	 * @see java.util.List#listIterator()
	 */
	public ListIterator listIterator()
	{
		return wrapped.listIterator();
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ listIterator(int) ĂяoƂłB
	 * <P>
	 * @see java.util.List#listIterator(int)
	 */
	public ListIterator listIterator(int index)
	{
		return wrapped.listIterator(index);
	}

	/**
	 * <P>
	 * ̃\bh̃ftHg̓́AbvꂽXgIuWFNgɑ΂ subList(int, int) ĂяoƂłB
	 * <P>
	 * @see java.util.List#subList(int, int)
	 */
	public List subList(int fromIndex, int toIndex)
	{
		return wrapped.subList(fromIndex, toIndex);
	}

}
