/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * <P>
 * PrimitiveHolderMap ̎łB
 * v~eBu^̒l}bsO邱Ƃł܂B
 * ̎́A}bsOꂽl𕶎֕ϊA𐔒l֕ϊ܂B
 * Ⴆ΁Â悤ɐli[AƂĎoƂł܂B
 * <PRE>
 *     map.putInt("someKey", 999);
 *     String value = map.getString("someKey");
 * </PRE>
 * i[AlƂĎoƂł܂B
 * <PRE>
 *     map.putString("someKey", "999");
 *     int value = map.getInt("someKey");
 * </PRE>
 * ti[Ajava.util.Date ƂĎoƂł܂B
 * <PRE>
 *     map.putString("someKey", "2003/04/01");
 *     java.util.Date value = map.getDate("someKey");
 * </PRE>
 * </P>
 * <P>
 * ̂悤Ȓl̕ϊ@\́AWeb y[WtH[f[^𕶎Ŏ󂯎悤 Web AvP[Vł́AɗLłB
 * </P>
 * @author Kenichi Fukuda
 */
public class ConversionMap
	extends MapWrapper
	implements PrimitiveHolderMap, Serializable
{
	//null  String ^̒l
	private static final String NULL_STRING = "";

	/**
	 * <P>
	 * w̃}bvbv ConversionMap \z܂B
	 * </P>
	 * @param map bv}bv
	 * @exception IllegalArgumentException }bv null ̏ꍇ
	 */
	public ConversionMap(java.util.Map map)
	{
		super(map);
	}

	/**
	 * <P>
	 * ConversionMap \z܂B
	 * HashMap bvV ConversionMap \z܂B
	 * </P>
	 */
	public ConversionMap()
	{
		super(new HashMap());
	}

	private Object getKey(Object key)
	{
		return key;
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl̓Xg[ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getInputStream(Object)
	 */
	public synchronized InputStream getInputStream(Object key)
	{
		return (InputStream)get(key);
	}

	/**
	 * <P>
	 * w̓̓Xg[}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putInputStream(Object, InputStream)
	 */
	public synchronized void putInputStream(Object key, InputStream value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.math.BigDecimal IuWFNgƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getBigDecimal(Object)
	 */
	public synchronized BigDecimal getBigDecimal(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigDecimal)
		{
			return (BigDecimal)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigDecimal(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 * w java.math.BigDecimal IuWFNg}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putBigDecimal(Object, BigDecimal)
	 */
	public synchronized void putBigDecimal(Object key, BigDecimal value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.math.BigInteger IuWFNgƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getBigInteger(Object)
	 */
	public synchronized BigInteger getBigInteger(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigInteger)
		{
			return (BigInteger)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigInteger(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 * w java.math.BigInteger IuWFNg}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putBigInteger(Object, BigInteger)
	 */
	public synchronized void putBigInteger(Object key, BigInteger value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O boolean ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getBoolean(Object)
	 */
	public synchronized boolean getBoolean(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return false;
		}

		if (obj instanceof Boolean)
		{
			return ((Boolean)obj).booleanValue();
		}
		else
		{
			return Boolean.valueOf(obj.toString()).booleanValue();
		}
	}

	/**
	 * <P>
	 * w boolean l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putBoolean(Object, boolean)
	 */
	public synchronized void putBoolean(Object key, boolean value)
	{
		put(key, new Boolean(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O byte ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getByte(Object)
	 */
	public synchronized byte getByte(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Byte)
		{
			return ((Byte)obj).byteValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Byte.valueOf(obj.toString()).byteValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w byte l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putByte(Object, byte)
	 */
	public synchronized void putByte(Object key, byte value)
	{
		put(key, new Byte(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O byte zƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getBytes(Object)
	 */
	public synchronized byte[] getBytes(Object key)
	{
		return (byte[])get(key);
	}

	/**
	 * <P>
	 * w byte z}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putBytes(Object, byte[])
	 */
	public synchronized void putBytes(Object key, byte[] value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O char ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getChar(Object)
	 */
	public synchronized char getChar(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Character)
		{
			return ((Character)obj).charValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return obj.toString().toCharArray()[0];
		}

		return 0;
	}

	/**
	 * <P>
	 * w char l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putChar(Object, char)
	 */
	public synchronized void putChar(Object key, char value)
	{
		put(key, new Character(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.io.Reader IuWFNgƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getReader(Object)
	 */
	public synchronized Reader getReader(Object key)
	{
		return (Reader)get(key);
	}

	/**
	 * <P>
	 * w java.io.Reader IuWFNg}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putReader(Object, Reader)
	 */
	public synchronized void putReader(Object key, Reader value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.util.Date IuWFNgƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getDate(Object)
	 */
	public synchronized Date getDate(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof java.sql.Timestamp)
		{
			//java.sql.Timestamp IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Timestamp)obj).getTime());
		}
		else if (obj instanceof java.sql.Date)
		{
			//java.sql.Date IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Date)obj).getTime());
		}
		else if (obj instanceof java.sql.Time)
		{
			//java.sql.Time IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Time)obj).getTime());
		}
		else if (obj instanceof java.util.Date)
		{
			//java.util.Date IuWFNg̏ꍇ
			return (java.util.Date)obj;
		}
		else
		{
			//java.sql.Timestamp ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Timestamp.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Date ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Date.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Time ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Time.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.util.Date ̕\̏ꍇ
			try
			{
				return new SimpleDateFormat(
					"EEE MMM dd HH:mm:ss zzz yyyy",
					Locale.US).parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//t/̕\̏ꍇ
			try
			{
				return DateFormat.getDateTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//t̕\̏ꍇ
			try
			{
				return DateFormat.getDateInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//̕\̏ꍇ
			try
			{
				return DateFormat.getTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}
		}

		return null;
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl̕\ pattern Ŏw肵t^p^[ŉ͂āAjava.util.Date IuWFNgƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @param pattern t^p^[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#parseDate(Object, String)
	 */
	public synchronized Date parseDate(Object key, String pattern)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		try
		{
			return new SimpleDateFormat(pattern).parse(obj.toString());
		}
		catch (ParseException e)
		{
		}

		return null;
	}

	/**
	 * <P>
	 * w java.util.Date l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putDate(Object, Date)
	 */
	public synchronized void putDate(Object key, Date value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O double ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getDouble(Object)
	 */
	public synchronized double getDouble(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Double)
		{
			return ((Double)obj).doubleValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).doubleValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w double l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putDouble(Object, double)
	 */
	public synchronized void putDouble(Object key, double value)
	{
		put(key, new Double(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O float ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getFloat(Object)
	 */
	public synchronized float getFloat(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Float)
		{
			return ((Float)obj).floatValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).floatValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w float l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putFloat(Object, float)
	 */
	public synchronized void putFloat(Object key, float value)
	{
		put(key, new Float(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O int ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getInt(Object)
	 */
	public synchronized int getInt(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Integer)
		{
			return ((Integer)obj).intValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).intValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w int l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putInt(Object, int)
	 */
	public synchronized void putInt(Object key, int value)
	{
		put(key, new Integer(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O long ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getLong(Object)
	 */
	public synchronized long getLong(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Long)
		{
			return ((Long)obj).longValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).longValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w long l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putLong(Object, long)
	 */
	public synchronized void putLong(Object key, long value)
	{
		put(key, new Long(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O Object ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getObject(Object)
	 */
	public synchronized Object getObject(Object key)
	{
		return get(key);
	}

	/**
	 * <P>
	 * w Object l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putObject(Object, Object)
	 */
	public synchronized void putObject(Object key, Object value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O short ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getShort(Object)
	 */
	public synchronized short getShort(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Short)
		{
			return ((Short)obj).shortValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).shortValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * w short l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putShort(Object, short)
	 */
	public synchronized void putShort(Object key, short value)
	{
		put(key, new Short(value));
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl Java vO~O String ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getString(Object)
	 */
	public synchronized String getString(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return NULL_STRING;
		}

		if (obj instanceof String)
		{
			return (String)obj;
		}
		else
		{
			return obj.toString();
		}
	}

	/**
	 * <P>
	 * w String l}bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putString(Object, String)
	 */
	public synchronized void putString(Object key, String value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * V ConversionMap \zāAw̃}bv炷ׂẴ}bsO\zV  ConversionMap ɃRs[܂B
	 * w̃}bv ConversionMap ̏ꍇ́AԂ܂B
	 * </P>
	 * @param map V\z ConversionMap Ɋi[}bsO
	 * @return ConversionMap
	 */
	public synchronized static ConversionMap valueOf(Map map)
	{
		if (map instanceof ConversionMap)
		{
			return (ConversionMap)map;
		}
		else
		{
			return new ConversionMap(map);
		}
	}

	/**
	 * <P>
	 * w肳ꂽL[Ƀ}bvĂlz̏ꍇ true Ԃ܂B
	 * </P>
	 * @param key }bvĂlzł邩ǂ肳L[
	 * @return w肳ꂽL[Ƀ}bvĂlz̏ꍇ true
	 */
	public synchronized boolean isArray(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return false;
		}

		return this.getObject(key).getClass().isArray();
	}

	/**
	 * <P>
	 * }bvw̃L[̃}bsOێꍇ true Ԃ܂B
	 * </P>
	 * @param key }bvɂ邩ǂ肳L[
	 * @return }bvw̃L[̃}bsOێꍇ true
	 * @see java.util.Map#containsKey(Object)
	 */
	public boolean containsKey(Object key)
	{
		return super.containsKey(getKey(key));
	}

	/**
	 * <P>
	 * ̃}bvŎw肳ꂽL[Ƀ}bvĂlԂ܂B
	 * }bṽL[̃}bsOێĂȂꍇ null Ԃ܂B
	 * ߂l null ́A}bvL[̃}bsOێĂȂƂƂ͂܂B
	 * ܂A}bvIɃL[ null Ƀ}bv邱Ƃ܂B
	 * containsKey(Object) \bhgƁA 2 ̏ꍇ邱Ƃł܂B
	 * <P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvAw肳ꂽL[Ƀ}bsOĂlB̃L[ɑ΂}bsO}bvɂȂꍇ  null
	 * @see java.util.Map#get(Object)
	 */
	public Object get(Object key)
	{
		return super.get(getKey(key));
	}

	/**
	 * <P>
	 * w̒lƎw肳ꂽL[̃}bvɊ֘At܂B
	 * }bvȑOɂ̃L[̃}bsOێĂꍇAÂlu܂B
	 * <P>
	 * @param key w肳l֘AtL[
	 * @param value w肳L[Ɋ֘Atl
	 * @return w肳ꂽL[Ɋ֘AlB܂́AL[̃}bsOȂꍇ nullB߂l null ́AConversionMap ȑO null Ǝw肳ꂽL[֘AtĂƂꍇ
	 * @see java.util.Map#put(Object, Object)
	 */
	public Object put(Object key, Object value)
	{
		return super.put(getKey(key), value);
	}

	/**
	 * <P>
	 * w̃}bv炷ׂẴ}bsO}bvɃRs[܂B
	 * ɂA}bvw̃}bvɌ݂L[ׂ̂Ăɑ΂ĎĂ}bsOu܂B
	 * <P>
	 * @param map }bvɊi[}bsO
	 * @see java.util.Map#putAll(Map)
	 */
	public void putAll(Map map)
	{
		Object[] keys = map.keySet().toArray();
		for (int i = 0; i < keys.length; i++)
		{
			put(getKey(keys[i]), map.get(keys[i]));
		}
	}

	/**
	 * <P>
	 * L[ɑ΂}bsO΁ÃL[}bv폜܂B
	 * <P>
	 * @param key }bsO}bv폜L[
	 * @return w肳ꂽL[Ɋ֘AlB܂́AL[̃}bsOȂꍇ nullB߂l null ́A}bvȑO null Ǝw肳ꂽL[֘AtĂƂꍇ
	 * @see java.util.Map#remove(Object)
	 */
	public Object remove(Object key)
	{
		return super.remove(getKey(key));
	}

	/**
	 * <P>
	 * w肳ꂽL[Ƀ}bvĂl NULL ̏ꍇ true Ԃ܂B
	 * </P>
	 * @param key }bvĂl NULL ł邩ǂ肳L[
	 * @return w肳ꂽL[Ƀ}bvĂl NULL ̏ꍇ true
	 */
	public synchronized boolean isNull(Object key)
	{
		return ((this.getObject(key) == null) ? true : false);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.util.List ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getList(Object)
	 */
	public synchronized java.util.List getList(Object key)
	{
		return (java.util.List)get(key);
	}

	/**
	 * <P>
	 * w java.util.List }bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putList(Object, List)
	 */
	public synchronized void putList(Object key, java.util.List value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * }bvw̃L[}bvl java.util.Map ƂĎ擾܂B
	 * </P>
	 * @param key ֘AtꂽlԂL[
	 * @return }bvw肳ꂽL[}bvl
	 * @see jp.morpho.util.PrimitiveHolderMap#getMap(Object)
	 */
	public synchronized java.util.Map getMap(Object key)
	{
		return (java.util.Map)get(key);
	}

	/**
	 * <P>
	 * w java.util.Map }bv̎w̃L[Ɗ֘At܂B
	 * </P>
	 * @param key w肳ꂽl֘AtL[
	 * @param value w肳ꂽL[Ɋ֘Atl
	 * @see jp.morpho.util.PrimitiveHolderMap#putMap(Object, Map)
	 */
	public synchronized void putMap(Object key, java.util.Map value)
	{
		put(key, value);
	}

}
