/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.morpho.io.OutputStreamFactory;
import jp.morpho.io.UploadFile;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.servlet.AbstractFilter;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;

public class FormDataParseFilter
extends AbstractFilter {
    private Logger log = Logger.getLogger("jp.morpho");
    private static final String CONST_MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String CONST_BOUNDARY = "boundary=";
    private static final String CONST_CONTENT_DISPOSITION = "content-disposition:";
    private static final String CONST_NAME = "name=";
    private static final String CONST_FILENAME = "filename=";
    private static final String CONST_CONTENT_TYPE = "content-type:";
    private static final String INITPARAM_UPLOADDIRECTORY = "uploadDirectory";
    private static final String DEFAULT_CHARACTERENCODING = "ISO8859_1";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.fine("doFilter");
        HttpActionRequest actioinRequest = HttpActionRequestFactory.getInstance().getRequest((HttpServletRequest)request);
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        try {
            if (contentType == null || !contentType.toLowerCase().startsWith(CONST_MULTIPART_FORM_DATA)) {
                this.getParameters(actioinRequest);
            } else {
                this.parseMultipartFormData(actioinRequest);
            }
            FrameworkContext fc = FrameworkContext.getInstance(this.getServletContext());
            ActionMappingManager amm = (ActionMappingManager)fc.get("jp.morpho.webapp.action.ActionMappingManager");
            String status = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getStatusParameterName());
            String action = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getActionParameterName());
            actioinRequest.setStatus(status);
            actioinRequest.setAction(action);
            ((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getStatusParameterName());
            ((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getActionParameterName());
        }
        catch (FrameworkException frameworkException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        chain.doFilter(request, response);
    }

    protected void getParameters(HttpActionRequest actioinRequest) {
        ConversionMap formValue = new ConversionMap();
        Enumeration paramNames = actioinRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = actioinRequest.getParameterValues(paramName);
            if (paramValues.length > 1) {
                formValue.putObject(paramName, paramValues);
                continue;
            }
            formValue.putString(paramName, paramValues[0]);
        }
        actioinRequest.setParameterMap(formValue);
    }

    /*
     * Unable to fully structure code
     */
    protected void parseMultipartFormData(HttpActionRequest actioinRequest) throws IOException {
        formValue = new ConversionMap();
        sPos = 0;
        ePos = 0;
        buff = new byte[1024];
        result = 0;
        parseStartTime = 0L;
        parseEndTime = 0L;
        formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        osf = new OutputStreamFactory();
        parameters = ConversionMap.valueOf(this.getInitParameterMap());
        uploadDirectory = null;
        if (parameters.getString("uploadDirectory").length() == 0) {
            uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
        } else {
            uploadDirectory = new File(parameters.getString("uploadDirectory"));
            if (!uploadDirectory.canWrite()) {
                uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
            }
        }
        ind = actioinRequest.getContentType().indexOf("boundary=");
        if (ind == -1) {
            throw new IOException("Invalid form data");
        }
        boundary = actioinRequest.getContentType().substring(ind + "boundary=".length());
        paramValue = new ByteArrayOutputStream();
        in = actioinRequest.getInputStream();
        parseStartTime = new Date().getTime();
        while ((result = in.readLine(buff, 0, buff.length)) != -1) {
            text = new String(buff, 0, result);
            if (text.toLowerCase().indexOf("content-disposition:") <= -1) continue;
            paramName = "";
            paramValue.reset();
            paramContentType = "";
            fileName = "";
            isFile = false;
            sPos = text.toLowerCase().indexOf("name=\"");
            if (sPos > -1) {
                ePos = text.toLowerCase().indexOf("\"", sPos += "name=\"".length());
                paramName = text.substring(sPos, ePos);
                isFile = false;
            }
            if ((sPos = text.toLowerCase().indexOf("filename=\"")) > -1) {
                ePos = text.toLowerCase().indexOf("\"", sPos += "filename=\"".length());
                fileName = text.substring(sPos, ePos);
                isFile = true;
            }
            if (paramName.trim().length() != 0) ** GOTO lbl48
            continue;
            while ((text = new String(buff, 0, result)).trim().length() != 0) {
                sPos = text.toLowerCase().indexOf("content-type:");
                if (sPos > -1) {
                    paramContentType = text.substring(sPos += "content-type:".length()).trim();
                }
lbl48:
                // 4 sources

                if ((result = in.readLine(buff, 0, buff.length)) != -1) continue;
            }
            if (result != -1) ** GOTO lbl53
            throw new IOException("Reset by peer");
            while ((text = new String(buff, 0, result)).toLowerCase().indexOf("--" + boundary) <= -1) {
                paramValue.write(buff, 0, result);
lbl53:
                // 2 sources

                if ((result = in.readLine(buff, 0, buff.length)) != -1) continue;
            }
            if (!isFile) {
                if (formValue.containsKey(paramName)) {
                    if (formValue.isArray(paramName)) {
                        arry = new ArrayList<Object>(Arrays.asList((Object[])formValue.getObject(paramName)));
                        arry.add(new String(paramValue.toByteArray(), 0, paramValue.size() - 2, "ISO8859_1"));
                        formValue.putObject(paramName, arry.toArray(new String[arry.size()]));
                    } else {
                        arry = new ArrayList<String>();
                        arry.add(formValue.getString(paramName));
                        arry.add(new String(paramValue.toByteArray(), 0, paramValue.size() - 2, "ISO8859_1"));
                        formValue.putObject(paramName, arry.toArray(new String[arry.size()]));
                    }
                } else {
                    formValue.putString(paramName, new String(paramValue.toByteArray(), 0, paramValue.size() - 2, "ISO8859_1"));
                }
            } else if (fileName.trim().length() > 0) {
                tempFile = File.createTempFile(formatter.format(new Date()), null, uploadDirectory);
                outputStream = osf.getOutputStream(tempFile);
                outputStream.write(paramValue.toByteArray(), 0, paramValue.size() - 2);
                outputStream.close();
                uploadFile = new UploadFile(tempFile.getAbsolutePath());
                uploadFile.setClientPath(fileName);
                uploadFile.setContentType(paramContentType);
                formValue.putObject(paramName, uploadFile);
            } else {
                formValue.putObject(paramName, null);
            }
            if (text.toLowerCase().indexOf("--" + boundary + "--") > -1) break;
        }
        paramValue.close();
        parseEndTime = new Date().getTime();
        actioinRequest.setParameterMap(formValue);
    }
}

