/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.lang.reflect.Method;

import org.xml.sax.Attributes;

/**
 * <P>
 * GetNode 饹ϡget ɽޤ
 * get ˤϡget set put call  new ޤ뤳ȤǤޤ
 * </P>
 * <P>
 * 㤨 get ϡΤ褦һ˵Ҥޤ
 * </P>
 * <P>
 * <PRE>
 *     &lt;get name="someMethod"/&gt;
 * </PRE>
 * </P>
 * <P>
 * ϡΤ褦ʥɤ񤯤ȤƱǤ
 * </P>
 * <P>
 * <PRE>
 *     someObject.getSomeMethod();
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class GetNode extends Node
{

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°ꤷ GetNode ֥Ȥޤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 */
	public GetNode(Node parent, Attributes attributes)
	{
		super(parent, attributes);
	}

	/**
	 * <P>
	 * ֤ͤޤ
	 * </P>
	 * @return 
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.GET;
	}

	/**
	 * <P>
	 * ꤵ줿֥Ȥޤ
	 * 饹ˤ褦ˡ֥ obj  get ᥽åɤƤӽФޤ
	 * </P>
	 * @param obj 륪֥
	 * @return 줿֥
	 * @exception ConfigureException ֥ȤǤʤä
	 * @see jp.morpho.config.Node#configure(Object)
	 */
	public Object configure(Object obj) throws ConfigureException
	{
		try
		{
			Class objCls = getNodeClass();
			if (objCls != null)
			{
				obj = null;
			}
			else
			{
				objCls = obj.getClass();
			}

			String name = getNodeName();

			Method method = objCls.getMethod(name, null);

			Object n = method.invoke(obj, null);
			configure(n, 0);
			return n;
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
