;;; monkey-config.el --- config file for monkey.el to run with ---

;;; License

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

;;; Developer

;; tkoba
;; talltale@users.sourceforge.jp


;;; Dependencies

;;
;; This is called by monkey.el , monkey-script.el
;;


;; ------------------------------------------
;; Usage
;; 
;; Custom following variables with your environment
;; ------------------------------------------


(defvar emacs-bin-file-path "c:/meadow/bin/Meadow.exe"
  "emacs binary path on your environment.")

(defvar monkey-installed-path "c:/meadow/site-lisp/monkey/" 
  "installed path for monkey package.")



;; ------------------------------------------
;; mode specific regular expressions.
;; ------------------------------------------


(defvar monkey-search-exp-lisp	; for Lisp Interaction and Emacs-Lisp mode.
  "^\\([ \t]*(\\(defun\\|defvar\\|defconst\\|defconstant\\|defclass\\|defcustom\\|defgroup\\)[ \t]+\\([^ ;\t\n]*\\)\\([ ;\t\n]+.*\\)\\)$")
(defvar monkey-search-exp-c    ; for C and C++ mode
  "\\(^\\([^ \t\n#/\\*]+\\)\\([0-9a-zA-Z_ \t\\*]+\\)([^\n;]*\\)$")
(defvar monkey-search-exp-perl	; for Perl and CPerl mode.
  "^\\([ \t]*\\(sub\\)[ \t]+\\(.*\\)\\)$")
(defvar monkey-search-exp-ruby	; for Ruby mode.
  "^\\([ \t]*\\(class\\|module\\|def\\|alias\\)[ \t]+\\(.*\\)\\)$")
(defvar monkey-search-exp-php    ; for PHP mode
  "^\\([ \t]*\\(public\\|private\\|protected\\)*[ \t]*\\(function\\|class\\)[ \t]+\\([^\(\{]*\\).*\\)$")
(defvar monkey-search-exp-html	; for HTML mode.
      "^\\([ \t]*<[Hh][123456].*\\|[ \t]*<[Hh][Ee][Aa][Dd].*\\|[ \t]*<[Bb][Oo][Dd][Yy].*\\|[ \t]*<[Ff][Oo][Rr][Mm].*\\)$")
(defvar monkey-search-exp-text	; for Text mode.
  "^\\([ \t]*[1234567890]+[\.]+.*\\)$")
(defvar monkey-search-exp-pascal	; for Pascal mode.
  "^\\([Pp][Rr][Oo][Cc][Ee][Dd][Uu][Rr][Ee].*\\)$")
(defvar monkey-search-exp-java	; for Java mode.
  "\\(^[ \t]*[^\n#/\\*=]+[0-9a-zA-Z_ \t\\*,\.()]+{[^\n;]*\\)$")
(defvar monkey-search-exp-basic	; for Visual Basic
  "^\\(\\([Pp][Rr][Ii][Vv][Aa][Tt][Ee]\\|[Pp][Uu][Bb][Ll][Ii][Cc]\\|[Ss][Uu][Bb]\\|[F][U][N][C][T][I][O][N]\\)[ \t]+.*\\)$")



;; ------------------------------------------
;; TAGS file name
;; ------------------------------------------


(defvar tags-name "MTAG"
  "The file containing tree of monkey project.")

(defvar monkey-exclusion-files-list
'("MTAG" "TAGS"))



;; ------------------------------------------
;; functions 
;; ------------------------------------------

(defcustom monkey-regexps nil
  "regular expresion to find class or function.")
(defcustom monkey-file-mask nil
  "regular expresion to find file.")

(defun monkey-regexps-set (inputs)
  "decide which regular expression to use. use `monkey-regexps' and `monkey-file-mask'"
  (let ((lang-type (downcase inputs)))
    (cond ((or (equal lang-type "emacs-lisp")
               (equal lang-type "e-lisp")
               (equal lang-type "el")
               (equal lang-type "lisp")
               (equal lang-type "lisp interaction"))
           (setq monkey-regexps monkey-search-exp-lisp
                 monkey-file-mask "^.*\\.\\(el\\|lisp\\)$"))
		  ((or (equal lang-type "c++")
               (equal lang-type "c")
               (equal lang-type "cpp")
               (equal lang-type "cc")
               (equal lang-type "c"))
           (setq monkey-regexps monkey-search-exp-c
                 monkey-file-mask "^.*\\.c[cp+]*$"))
		  ((or (equal lang-type "perl")
               (equal lang-type "cperl")
               (equal lang-type "pl"))
           (setq monkey-regexps monkey-search-exp-perl
                 monkey-file-mask "^.*\\.pl$"))
		  ((or (equal lang-type "ruby")
               (equal lang-type "rb"))
           (setq monkey-regexps monkey-search-exp-ruby
                 monkey-file-mask "^.*\\.rb$"))
		  ((equal lang-type "php")
           (setq monkey-regexps monkey-search-exp-php
                 monkey-file-mask "^.*\\.php[3-9]*$"))
		  ((equal lang-type "html")
           (setq monkey-regexps monkey-search-exp-html
                 monkey-file-mask "^.*\\.htm[l]*$"))
		  ((equal lang-type "text")
           (setq monkey-regexps monkey-search-exp-text
                 monkey-file-mask "^.*\\.txt$"))
		  ((equal lang-type "tex")
           (setq monkey-regexps monkey-search-exp-tex
                 monkey-file-mask "^.*\\.tex$"))
		  ((or (equal lang-type "pascal")
               (equal lang-type "pas"))
           (setq monkey-regexps monkey-search-exp-pascal
                 monkey-file-mask "^.*\\.pas$"))
		  ((or (equal lang-type "java")
               (equal lang-type "jav"))
           (setq monkey-regexps monkey-search-exp-java
                 monkey-file-mask "^.*\\.jav[a]*$"))
		  ((or (equal lang-type "basic")
		       (equal lang-type "bas"))
           (setq monkey-regexps monkey-search-exp-basic
                 monkey-file-mask "^.*\\.bas$"))
		  (t
		   (progn (setq monkey-regexps ""
                        monkey-file-mask "")
                  (error "invalied mode"))))))




(provide 'monkey-config)

