package monalipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class MonalipsePlugin extends AbstractUIPlugin
{
	public static final String PLUGIN_ID = "monalipse" ; //$NON-NLS-1$
	public static final String NATURE_ID = PLUGIN_ID + ".monalipsenature" ; //$NON-NLS-1$

	//The shared instance.
	private static MonalipsePlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	/**
	 * The constructor.
	 */
	public MonalipsePlugin(IPluginDescriptor descriptor)
	{
		super(descriptor);
		plugin = this;
		try
		{
			resourceBundle = ResourceBundle.getBundle("monalipse.MonalipsePluginResources");
		}
		catch (MissingResourceException x)
		{
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static MonalipsePlugin getDefault()
	{
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace()
	{
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key)
	{
		ResourceBundle bundle = MonalipsePlugin.getDefault().getResourceBundle();
		try
		{
			return bundle.getString(key);
		}
		catch(MissingResourceException e)
		{
			return key;
		}
	}

	public static String formatResourceString(String key, Object[] args)
	{
		return MessageFormat.format(getResourceString(key), args);
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle()
	{
		return resourceBundle;
	}

	public static InputStream getUTFInputStream(String str) throws IOException
	{
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		dout.writeUTF(str);
		return new ByteArrayInputStream(bout.toByteArray());
	}

	public static void ensureSynchronized(IFile file) throws CoreException
	{
		if(!file.isSynchronized(IResource.DEPTH_ZERO))
			file.refreshLocal(IResource.DEPTH_ZERO, new NullProgressMonitor());
	}
}
